/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BigNodesPostProcessor
implements ILayoutProcessor<LGraph> {
    private LGraph layeredGraph;

    @Override
    public void process(LGraph theLayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Big nodes post-processing", 1.0f);
        this.layeredGraph = theLayeredGraph;
        for (Layer layer : this.layeredGraph) {
            Iterable bigNodes = Iterables.filter(layer.getNodes(), (Predicate)new Predicate<LNode>(){

                public boolean apply(LNode node) {
                    return BigNodesPostProcessor.this.isInitialBigNode(node);
                }
            });
            for (LNode node : bigNodes) {
                Float originalSize = node.getProperty(InternalProperties.BIG_NODE_ORIGINAL_SIZE);
                LNode lastDummy = this.removeBigNodeChain(node);
                ArrayList toMove = Lists.newArrayList();
                for (LPort p : lastDummy.getPorts(PortSide.EAST)) {
                    toMove.add(p);
                    double offset2 = p.getPosition().x - lastDummy.getSize().x;
                    p.getPosition().x = (double)originalSize.floatValue() + offset2;
                }
                node.getSize().x = originalSize.doubleValue();
                for (LPort p : toMove) {
                    p.setNode(node);
                }
                if (this.layeredGraph.getSize().x < node.getPosition().x + node.getSize().x) {
                    this.layeredGraph.getSize().x = node.getPosition().x + node.getSize().x;
                }
                List<LLabel> labels = node.getProperty(InternalProperties.BIGNODES_ORIG_LABELS);
                node.getLabels().addAll(labels);
                Function<Void, Void> f = node.getProperty(InternalProperties.BIGNODES_POST_PROCESS);
                if (f == null) continue;
                f.apply(null);
            }
        }
        monitor.done();
    }

    private LNode removeBigNodeChain(LNode start) {
        LinkedList outs = Lists.newLinkedList(start.getOutgoingEdges());
        Iterator iterator = outs.iterator();
        if (iterator.hasNext()) {
            LEdge edge = (LEdge)iterator.next();
            LNode target = edge.getTarget().getNode();
            if (target.getType() == LNode.NodeType.BIG_NODE && !this.isInitialBigNode(target)) {
                target.getLayer().getNodes().remove(target);
                edge.getSource().setNode(null);
                edge.getTarget().setNode(null);
                return this.removeBigNodeChain(target);
            }
            return start;
        }
        return start;
    }

    private boolean isInitialBigNode(LNode node) {
        return node.getProperty(InternalProperties.BIG_NODE_INITIAL) != false && node.getProperty(InternalProperties.ORIGIN) != null;
    }
}

