/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph.transform;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphElement;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodePlacementStrategy;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.UnsupportedGraphException;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.adapters.ElkGraphAdapters;
import org.eclipse.elk.core.util.nodespacing.NodeLabelAndSizeCalculator;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.ecore.util.EcoreUtil;

class ElkGraphImporter {
    private final Map<ElkGraphElement, LGraphElement> nodeAndPortMap = Maps.newHashMap();

    ElkGraphImporter() {
    }

    public LGraph importGraph(ElkNode elkgraph) {
        LGraph topLevelGraph = this.createLGraph(elkgraph);
        Set<GraphProperties> graphProperties = topLevelGraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        this.checkExternalPorts(elkgraph, graphProperties);
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            for (ElkPort elkport : elkgraph.getPorts()) {
                this.transformExternalPort(elkgraph, topLevelGraph, elkport);
            }
        }
        this.calculateMinimumGraphSize(elkgraph, topLevelGraph);
        if (topLevelGraph.getProperty(LayeredOptions.PARTITIONING_ACTIVATE).booleanValue()) {
            graphProperties.add(GraphProperties.PARTITIONS);
        }
        if (elkgraph.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN) {
            this.importHierarchicalGraph(elkgraph, topLevelGraph);
        } else {
            this.importFlatGraph(elkgraph, topLevelGraph);
        }
        return topLevelGraph;
    }

    private void calculateMinimumGraphSize(ElkNode elkgraph, LGraph lgraph) {
        if (elkgraph.getParent() == null) {
            return;
        }
        EnumSet<SizeConstraint> sizeConstraints = lgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS);
        if (sizeConstraints.isEmpty()) {
            return;
        }
        if (elkgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.UNDEFINED) {
            elkgraph.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        }
        ElkGraphAdapters.ElkGraphAdapter graphAdapter = ElkGraphAdapters.adapt(elkgraph.getParent());
        ElkGraphAdapters.ElkNodeAdapter nodeAdapter = ElkGraphAdapters.adaptSingleNode(elkgraph);
        KVector minSize = NodeLabelAndSizeCalculator.process(graphAdapter, nodeAdapter, false, true);
        sizeConstraints.add(SizeConstraint.MINIMUM_SIZE);
        KVector configuredMinSize = lgraph.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
        configuredMinSize.x = Math.max(minSize.x, configuredMinSize.x);
        configuredMinSize.y = Math.max(minSize.y, configuredMinSize.y);
    }

    private void importFlatGraph(ElkNode elkgraph, LGraph lgraph) {
        for (ElkNode child : elkgraph.getChildren()) {
            if (child.getProperty(LayeredOptions.NO_LAYOUT).booleanValue()) continue;
            this.transformNode(child, lgraph);
        }
        for (ElkNode child : elkgraph.getChildren()) {
            boolean enableInsideSelfLoops = child.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
            for (ElkEdge elkedge : ElkGraphUtil.allOutgoingEdges(child)) {
                boolean connectsToSibling;
                ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0));
                boolean isToBeLaidOut = elkedge.getProperty(LayeredOptions.NO_LAYOUT) == false;
                boolean isInsideSelfLoop = enableInsideSelfLoops && elkedge.isSelfloop() && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                boolean connectsToGraph = targetNode == elkgraph;
                boolean bl = connectsToSibling = targetNode.getParent() == elkgraph;
                if (!isToBeLaidOut || isInsideSelfLoop || !connectsToGraph && !connectsToSibling) continue;
                this.transformEdge(elkedge, elkgraph, lgraph);
            }
        }
        boolean enableInsideSelfLoops = elkgraph.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
        for (ElkEdge elkedge : ElkGraphUtil.allOutgoingEdges(elkgraph)) {
            boolean connectsToChild;
            ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0));
            boolean isToBeLaidOut = elkedge.getProperty(LayeredOptions.NO_LAYOUT) == false;
            boolean isInsideSelfLoop = enableInsideSelfLoops && elkedge.isSelfloop() && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            boolean bl = connectsToChild = targetNode.getParent() == elkgraph;
            if (!isToBeLaidOut || !connectsToChild && !isInsideSelfLoop) continue;
            this.transformEdge(elkedge, elkgraph, lgraph);
        }
    }

    private void importHierarchicalGraph(ElkNode elkgraph, LGraph lgraph) {
        ElkNode elknode;
        LinkedList elknodeQueue = Lists.newLinkedList();
        Direction parentGraphDirection = lgraph.getProperty(LayeredOptions.DIRECTION);
        elknodeQueue.addAll(elkgraph.getChildren());
        while (!elknodeQueue.isEmpty()) {
            boolean hasHierarchyHandlingEnabled;
            boolean isNodeToBeLaidOut;
            elknode = (ElkNode)elknodeQueue.poll();
            boolean bl = isNodeToBeLaidOut = elknode.getProperty(LayeredOptions.NO_LAYOUT) == false;
            if (!isNodeToBeLaidOut) continue;
            LGraph parentLGraph = lgraph;
            LNode parentLNode = (LNode)this.nodeAndPortMap.get(elknode.getParent());
            if (parentLNode != null) {
                parentLGraph = parentLNode.getProperty(InternalProperties.NESTED_LGRAPH);
            }
            LNode lnode = this.transformNode(elknode, parentLGraph);
            boolean hasChildren = !elknode.getChildren().isEmpty();
            boolean hasInsideSelfLoops = this.hasInsideSelfLoops(elknode);
            boolean bl2 = hasHierarchyHandlingEnabled = elknode.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
            if (!hasHierarchyHandlingEnabled || !hasChildren && !hasInsideSelfLoops) continue;
            LGraph nestedGraph = this.createLGraph(elknode);
            nestedGraph.setProperty(LayeredOptions.DIRECTION, (Object)parentGraphDirection);
            lnode.setProperty(InternalProperties.NESTED_LGRAPH, nestedGraph);
            nestedGraph.setProperty(InternalProperties.PARENT_LNODE, lnode);
            elknodeQueue.addAll(elknode.getChildren());
        }
        elknodeQueue.add(elkgraph);
        while (!elknodeQueue.isEmpty()) {
            elknode = (ElkNode)elknodeQueue.poll();
            boolean enableInsideSelfLoops = elknode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
            if (elknode.getProperty(LayeredOptions.NO_LAYOUT).booleanValue()) continue;
            for (ElkEdge elkedge : ElkGraphUtil.allOutgoingEdges(elknode)) {
                if (elkedge.getProperty(LayeredOptions.NO_LAYOUT).booleanValue()) continue;
                this.checkEdgeValidity(elkedge);
                boolean isInsideSelfLoop = enableInsideSelfLoops && elkedge.isSelfloop() && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                ElkNode parentKGraph = elknode.getParent();
                ElkNode edgeTargetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0));
                if (ElkGraphUtil.isDescendant(edgeTargetNode, elknode) || isInsideSelfLoop) {
                    parentKGraph = elknode;
                }
                LGraph parentLGraph = lgraph;
                LNode parentLNode = (LNode)this.nodeAndPortMap.get(parentKGraph);
                if (parentLNode != null) {
                    parentLGraph = parentLNode.getProperty(InternalProperties.NESTED_LGRAPH);
                }
                LEdge ledge = this.transformEdge(elkedge, parentKGraph, parentLGraph);
                LGraph coordinateSystemOrigin = this.findCoordinateSystemOrigin(elkedge, elkgraph, lgraph);
                if (coordinateSystemOrigin == null) continue;
                ledge.setProperty(InternalProperties.COORDINATE_SYSTEM_ORIGIN, coordinateSystemOrigin);
            }
            elknodeQueue.addAll(elknode.getChildren());
        }
    }

    private boolean hasInsideSelfLoops(ElkNode elknode) {
        if (elknode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE).booleanValue()) {
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges(elknode)) {
                if (!edge.isSelfloop() || !edge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private LGraph findCoordinateSystemOrigin(ElkEdge elkedge, ElkNode topLevelElkGraph, LGraph topLevelLGraph) {
        LGraph lgraph;
        ElkNode source = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getSources().get(0));
        ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0));
        if (source.getParent() == target.getParent()) {
            return null;
        }
        if (ElkGraphUtil.isDescendant(target, source)) {
            return null;
        }
        ElkNode origin = elkedge.getContainingNode();
        assert (source == origin || ElkGraphUtil.isDescendant(source, origin));
        assert (target == origin || ElkGraphUtil.isDescendant(target, origin));
        if (origin == topLevelElkGraph) {
            return topLevelLGraph;
        }
        LNode lnode = (LNode)this.nodeAndPortMap.get(origin);
        if (lnode != null && (lgraph = lnode.getProperty(InternalProperties.NESTED_LGRAPH)) != null) {
            return lgraph;
        }
        return null;
    }

    private LGraph createLGraph(ElkNode elkgraph) {
        LGraph lgraph = new LGraph();
        lgraph.copyProperties(elkgraph);
        if (lgraph.getProperty(LayeredOptions.DIRECTION) == Direction.UNDEFINED) {
            lgraph.setProperty(LayeredOptions.DIRECTION, (Object)LGraphUtil.getDirection(lgraph));
        }
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) == null) {
            ElkGraphElement root = (ElkGraphElement)EcoreUtil.getRootContainer(elkgraph);
            lgraph.setProperty(LabelManagementOptions.LABEL_MANAGER, root.getProperty(LabelManagementOptions.LABEL_MANAGER));
        }
        lgraph.setProperty(InternalProperties.ORIGIN, elkgraph);
        lgraph.setProperty(InternalProperties.GRAPH_PROPERTIES, EnumSet.noneOf(GraphProperties.class));
        ElkPadding nodeLabelpadding = NodeLabelAndSizeCalculator.computeInsideNodeLabelPadding(elkgraph.getParent() == null ? null : ElkGraphAdapters.adapt(elkgraph.getParent()), ElkGraphAdapters.adaptSingleNode(elkgraph));
        ElkPadding nodePadding = lgraph.getProperty(LayeredOptions.PADDING);
        LPadding lPadding = lgraph.getPadding();
        lPadding.add(nodePadding);
        lPadding.add(nodeLabelpadding);
        return lgraph;
    }

    private void checkExternalPorts(ElkNode elkgraph, Set<GraphProperties> graphProperties) {
        boolean enableSelfLoops = elkgraph.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
        PortLabelPlacement portLabelPlacement = elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT);
        boolean hasExternalPorts = false;
        boolean hasHyperedges = false;
        Iterator portIterator = elkgraph.getPorts().iterator();
        while (!(!portIterator.hasNext() || hasExternalPorts && hasHyperedges)) {
            ElkPort elkport = (ElkPort)portIterator.next();
            int externalPortEdges = 0;
            for (ElkEdge elkedge : ElkGraphUtil.allIncidentEdges(elkport)) {
                boolean connectsToChild;
                boolean isInsideSelfLoop;
                boolean bl = isInsideSelfLoop = enableSelfLoops && elkedge.isSelfloop() && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                boolean bl2 = elkedge.getSources().contains(elkport) ? elkgraph == ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0)).getParent() : (connectsToChild = elkgraph == ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getSources().get(0)).getParent());
                if ((isInsideSelfLoop || connectsToChild) && ++externalPortEdges > 1) break;
            }
            if (externalPortEdges > 0) {
                hasExternalPorts = true;
            } else if (portLabelPlacement == PortLabelPlacement.INSIDE && elkport.getLabels().size() > 0) {
                hasExternalPorts = true;
            }
            if (externalPortEdges <= 1) continue;
            hasHyperedges = true;
        }
        if (hasExternalPorts) {
            graphProperties.add(GraphProperties.EXTERNAL_PORTS);
        }
        if (hasHyperedges) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
    }

    private void transformExternalPort(ElkNode elkgraph, LGraph lgraph, ElkPort elkport) {
        KVector elkportPosition = new KVector(elkport.getX() + elkport.getWidth() / 2.0, elkport.getY() + elkport.getHeight() / 2.0);
        int netFlow = this.calculateNetFlow(elkport);
        PortSide portSide = elkport.getProperty(LayeredOptions.PORT_SIDE);
        PortConstraints portConstraints = elkgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        Direction layoutDirection = lgraph.getProperty(LayeredOptions.DIRECTION);
        if (portSide == PortSide.UNDEFINED) {
            portSide = ElkUtil.calcPortSide(elkport, layoutDirection);
            elkport.setProperty(LayeredOptions.PORT_SIDE, portSide);
        }
        if (!elkport.getAllProperties().containsKey(LayeredOptions.PORT_BORDER_OFFSET)) {
            double portOffset = elkport.getX() == 0.0 && elkport.getY() == 0.0 ? 0.0 : ElkUtil.calcPortOffset(elkport, portSide);
            elkport.setProperty(LayeredOptions.PORT_BORDER_OFFSET, portOffset);
        }
        KVector graphSize = new KVector(elkgraph.getWidth(), elkgraph.getHeight());
        LNode dummy = LGraphUtil.createExternalPortDummy(elkport, portConstraints, portSide, netFlow, graphSize, elkportPosition, new KVector(elkport.getWidth(), elkport.getHeight()), layoutDirection, lgraph);
        dummy.setProperty(InternalProperties.ORIGIN, elkport);
        LPort dummyPort = dummy.getPorts().get(0);
        dummy.setProperty(LayeredOptions.PORT_LABELS_PLACEMENT, (Object)PortLabelPlacement.OUTSIDE);
        boolean insidePortLabels = elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT) == PortLabelPlacement.INSIDE;
        for (ElkLabel elklabel : elkport.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            LLabel llabel = this.transformLabel(elklabel);
            dummyPort.getLabels().add(llabel);
            if (insidePortLabels) continue;
            switch (portSide) {
                case EAST: 
                case WEST: {
                    llabel.getSize().x = 0.0;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    llabel.getSize().y = 0.0;
                }
            }
        }
        dummy.setProperty(LayeredOptions.SPACING_LABEL_PORT, elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_PORT));
        dummy.setProperty(LayeredOptions.SPACING_LABEL_LABEL, elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_LABEL));
        lgraph.getLayerlessNodes().add(dummy);
        this.nodeAndPortMap.put(elkport, dummy);
    }

    private int calculateNetFlow(ElkPort elkport) {
        boolean isInsideSelfLoop;
        boolean isSelfLoop;
        ElkNode elkgraph = elkport.getParent();
        boolean insideSelfLoopsEnabled = elkgraph.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
        int outputPortVote = 0;
        int inputPortVote = 0;
        for (ElkEdge outgoingEdge : elkport.getOutgoingEdges()) {
            isSelfLoop = outgoingEdge.isSelfloop();
            isInsideSelfLoop = isSelfLoop && insideSelfLoopsEnabled && outgoingEdge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)outgoingEdge.getTargets().get(0));
            if (isSelfLoop && isInsideSelfLoop) {
                ++inputPortVote;
                continue;
            }
            if (isSelfLoop && !isInsideSelfLoop) {
                ++outputPortVote;
                continue;
            }
            if (targetNode.getParent() == elkgraph || targetNode == elkgraph) {
                ++inputPortVote;
                continue;
            }
            ++outputPortVote;
        }
        for (ElkEdge incomingEdge : elkport.getIncomingEdges()) {
            isSelfLoop = incomingEdge.isSelfloop();
            isInsideSelfLoop = isSelfLoop && insideSelfLoopsEnabled && incomingEdge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)incomingEdge.getSources().get(0));
            if (isSelfLoop && isInsideSelfLoop) {
                ++outputPortVote;
                continue;
            }
            if (isSelfLoop && !isInsideSelfLoop) {
                ++inputPortVote;
                continue;
            }
            if (sourceNode.getParent() == elkgraph || sourceNode == elkgraph) {
                ++outputPortVote;
                continue;
            }
            ++inputPortVote;
        }
        return outputPortVote - inputPortVote;
    }

    private LNode transformNode(ElkNode elknode, LGraph lgraph) {
        LNode lnode = new LNode(lgraph);
        lnode.copyProperties(elknode);
        lnode.setProperty(InternalProperties.ORIGIN, elknode);
        lnode.getSize().x = elknode.getWidth();
        lnode.getSize().y = elknode.getHeight();
        lnode.getPosition().x = elknode.getX();
        lnode.getPosition().y = elknode.getY();
        lgraph.getLayerlessNodes().add(lnode);
        this.nodeAndPortMap.put(elknode, lnode);
        if (!elknode.getChildren().isEmpty() || elknode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE).booleanValue()) {
            lnode.setProperty(InternalProperties.COMPOUND_NODE, (Object)true);
        }
        Set<GraphProperties> graphProperties = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        PortConstraints portConstraints = lnode.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.UNDEFINED) {
            lnode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        } else if (portConstraints != PortConstraints.FREE) {
            graphProperties.add(GraphProperties.NON_FREE_PORTS);
        }
        Direction direction = lgraph.getProperty(LayeredOptions.DIRECTION);
        for (ElkPort elkport : elknode.getPorts()) {
            if (elkport.getProperty(LayeredOptions.NO_LAYOUT).booleanValue()) continue;
            this.transformPort(elkport, lnode, graphProperties, direction, portConstraints);
        }
        for (ElkLabel elklabel : elknode.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            lnode.getLabels().add(this.transformLabel(elklabel));
        }
        if (lnode.getProperty(LayeredOptions.COMMENT_BOX).booleanValue()) {
            graphProperties.add(GraphProperties.COMMENTS);
        }
        if (lnode.getProperty(LayeredOptions.HYPERNODE).booleanValue()) {
            graphProperties.add(GraphProperties.HYPERNODES);
            graphProperties.add(GraphProperties.HYPEREDGES);
            lnode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        }
        return lnode;
    }

    private LPort transformPort(ElkPort elkport, LNode parentLNode, Set<GraphProperties> graphProperties, Direction layoutDirection, PortConstraints portConstraints) {
        LPort lport = new LPort();
        lport.copyProperties(elkport);
        lport.setSide(elkport.getProperty(LayeredOptions.PORT_SIDE));
        lport.setProperty(InternalProperties.ORIGIN, elkport);
        lport.setNode(parentLNode);
        KVector portSize = lport.getSize();
        portSize.x = elkport.getWidth();
        portSize.y = elkport.getHeight();
        KVector portPos = lport.getPosition();
        portPos.x = elkport.getX();
        portPos.y = elkport.getY();
        this.nodeAndPortMap.put(elkport, lport);
        boolean connectionsToDescendants = elkport.getOutgoingEdges().stream().flatMap(edge -> edge.getTargets().stream()).map(ElkGraphUtil::connectableShapeToNode).anyMatch(targetNode -> ElkGraphUtil.isDescendant(targetNode, elkport.getParent()));
        if (!connectionsToDescendants) {
            connectionsToDescendants = elkport.getIncomingEdges().stream().flatMap(edge -> edge.getSources().stream()).map(ElkGraphUtil::connectableShapeToNode).anyMatch(sourceNode -> ElkGraphUtil.isDescendant(sourceNode, elkport.getParent()));
        }
        if (!connectionsToDescendants) {
            connectionsToDescendants = elkport.getOutgoingEdges().stream().anyMatch(edge -> edge.isSelfloop() && edge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false);
        }
        lport.setProperty(InternalProperties.INSIDE_CONNECTIONS, (Object)connectionsToDescendants);
        LGraphUtil.initializePort(lport, portConstraints, layoutDirection, elkport.getProperty(LayeredOptions.PORT_ANCHOR));
        for (ElkLabel elklabel : elkport.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            lport.getLabels().add(this.transformLabel(elklabel));
        }
        if (elkport.getIncomingEdges().size() + elkport.getOutgoingEdges().size() > 1) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
        switch (layoutDirection) {
            case RIGHT: 
            case LEFT: {
                if (lport.getSide() != PortSide.NORTH && lport.getSide() != PortSide.SOUTH) break;
                graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                break;
            }
            case DOWN: 
            case UP: {
                if (lport.getSide() != PortSide.EAST && lport.getSide() != PortSide.WEST) break;
                graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
            }
        }
        return lport;
    }

    private LEdge transformEdge(ElkEdge elkedge, ElkNode elkparent, LGraph lgraph) {
        boolean bendPointsRequired;
        PortType portType;
        this.checkEdgeValidity(elkedge);
        ElkConnectableShape elkSourceShape = (ElkConnectableShape)elkedge.getSources().get(0);
        ElkConnectableShape elkTargetShape = (ElkConnectableShape)elkedge.getTargets().get(0);
        ElkNode elkSourceNode = ElkGraphUtil.connectableShapeToNode(elkSourceShape);
        ElkNode elkTargetNode = ElkGraphUtil.connectableShapeToNode(elkTargetShape);
        ElkEdgeSection edgeSection = elkedge.getSections().isEmpty() ? null : (ElkEdgeSection)elkedge.getSections().get(0);
        LNode sourceLNode = (LNode)this.nodeAndPortMap.get(elkSourceNode);
        LNode targetLNode = (LNode)this.nodeAndPortMap.get(elkTargetNode);
        LPort sourceLPort = null;
        LPort targetLPort = null;
        if (elkSourceShape instanceof ElkPort) {
            LGraphElement sourceElem = this.nodeAndPortMap.get(elkSourceShape);
            if (sourceElem instanceof LPort) {
                sourceLPort = (LPort)sourceElem;
            } else if (sourceElem instanceof LNode) {
                sourceLNode = (LNode)sourceElem;
                sourceLPort = sourceLNode.getPorts().get(0);
            }
        }
        if (elkTargetShape instanceof ElkPort) {
            LGraphElement targetElem = this.nodeAndPortMap.get(elkTargetShape);
            if (targetElem instanceof LPort) {
                targetLPort = (LPort)targetElem;
            } else if (targetElem instanceof LNode) {
                targetLNode = (LNode)targetElem;
                targetLPort = targetLNode.getPorts().get(0);
            }
        }
        if (sourceLNode == null || targetLNode == null) {
            return null;
        }
        LEdge ledge = new LEdge();
        ledge.copyProperties(elkedge);
        ledge.setProperty(InternalProperties.ORIGIN, elkedge);
        ledge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        Set<GraphProperties> graphProperties = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (sourceLNode == targetLNode) {
            graphProperties.add(GraphProperties.SELF_LOOPS);
        }
        if (sourceLPort == null) {
            portType = PortType.OUTPUT;
            KVector sourcePoint = null;
            if (edgeSection != null && sourceLNode.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
                sourcePoint = new KVector(edgeSection.getStartX(), edgeSection.getStartY());
                ElkUtil.toAbsolute(sourcePoint, elkedge.getContainingNode());
                ElkUtil.toRelative(sourcePoint, elkparent);
                if (ElkGraphUtil.isDescendant(elkTargetNode, elkSourceNode)) {
                    portType = PortType.INPUT;
                    sourcePoint.add(sourceLNode.getPosition());
                }
            }
            sourceLPort = LGraphUtil.createPort(sourceLNode, sourcePoint, portType, lgraph);
        }
        if (targetLPort == null) {
            portType = PortType.INPUT;
            Object targetPoint = null;
            if (edgeSection != null && targetLNode.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
                targetPoint = new KVector(edgeSection.getEndX(), edgeSection.getEndY());
                ElkUtil.toAbsolute((KVector)targetPoint, elkedge.getContainingNode());
                ElkUtil.toRelative((KVector)targetPoint, elkparent);
            }
            targetLPort = LGraphUtil.createPort(targetLNode, targetPoint, portType, targetLNode.getGraph());
        }
        ledge.setSource(sourceLPort);
        ledge.setTarget(targetLPort);
        for (ElkLabel elklabel : elkedge.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            LLabel llabel = this.transformLabel(elklabel);
            ledge.getLabels().add(llabel);
            switch (llabel.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT)) {
                case HEAD: 
                case TAIL: {
                    graphProperties.add(GraphProperties.END_LABELS);
                    break;
                }
                case UNDEFINED: 
                case CENTER: {
                    graphProperties.add(GraphProperties.CENTER_LABELS);
                    llabel.setProperty(LayeredOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
                }
            }
        }
        CrossingMinimizationStrategy crossMinStrat = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY);
        NodePlacementStrategy nodePlaceStrat = lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY);
        boolean bl = bendPointsRequired = crossMinStrat == CrossingMinimizationStrategy.INTERACTIVE || nodePlaceStrat == NodePlacementStrategy.INTERACTIVE;
        if (edgeSection != null && !edgeSection.getBendPoints().isEmpty() && bendPointsRequired) {
            KVectorChain originalBendpoints = ElkUtil.createVectorChain(edgeSection);
            KVectorChain importedBendpoints = new KVectorChain();
            for (KVector point : originalBendpoints) {
                importedBendpoints.add(new KVector(point));
            }
            ledge.setProperty(InternalProperties.ORIGINAL_BENDPOINTS, importedBendpoints);
        }
        return ledge;
    }

    private void checkEdgeValidity(ElkEdge edge) {
        if (edge.getSources().isEmpty()) {
            throw new UnsupportedGraphException("Edges must have a source.");
        }
        if (edge.getTargets().isEmpty()) {
            throw new UnsupportedGraphException("Edges must have a target.");
        }
        if (edge.isHyperedge()) {
            throw new UnsupportedGraphException("Hyperedges are not supported.");
        }
    }

    private LLabel transformLabel(ElkLabel elklabel) {
        LLabel newLabel = new LLabel(elklabel.getText());
        newLabel.copyProperties(elklabel);
        newLabel.setProperty(InternalProperties.ORIGIN, elklabel);
        newLabel.getSize().x = elklabel.getWidth();
        newLabel.getSize().y = elklabel.getHeight();
        newLabel.getPosition().x = elklabel.getX();
        newLabel.getPosition().y = elklabel.getY();
        return newLabel;
    }
}

