/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compaction.oned.algs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.alg.layered.compaction.oned.algs.IConstraintCalculationAlgorithm;
import org.eclipse.elk.alg.layered.compaction.recthull.Scanline;

public class ScanlineConstraintCalculator
implements IConstraintCalculationAlgorithm {
    private static final double EPSILON = 0.5;
    protected OneDimensionalCompactor compactor;
    private final Comparator<Timestamp> constraintsScanlineComparator = (p1, p2) -> {
        int cmp;
        double y1 = ((Timestamp)p1).node.hitbox.y;
        if (!((Timestamp)p1).low) {
            y1 += ((Timestamp)p1).node.hitbox.height;
        }
        double y2 = ((Timestamp)p2).node.hitbox.y;
        if (!((Timestamp)p2).low) {
            y2 += ((Timestamp)p2).node.hitbox.height;
        }
        if ((cmp = Double.compare(y1, y2)) == 0) {
            if (!((Timestamp)p1).low && ((Timestamp)p2).low) {
                return -1;
            }
            if (!((Timestamp)p2).low && ((Timestamp)p1).low) {
                return 1;
            }
        }
        return cmp;
    };
    private final ConstraintsScanlineHandler constraintsScanlineHandler = new ConstraintsScanlineHandler();

    @Override
    public void calculateConstraints(OneDimensionalCompactor theCompactor) {
        this.compactor = theCompactor;
        this.sweep((Predicate<CNode>)((Predicate)n -> true), (Function<CNode, Double>)((Function)n -> 0.0));
    }

    protected void sweep(Predicate<CNode> filterFun, Function<CNode, Double> spacingFun) {
        this.blowUpHitboxes(filterFun, spacingFun);
        ArrayList points = Lists.newArrayList();
        for (CNode n : this.compactor.cGraph.cNodes) {
            if (!filterFun.apply((Object)n)) continue;
            points.add(new Timestamp(n, true));
            points.add(new Timestamp(n, false));
        }
        this.constraintsScanlineHandler.reset();
        Scanline.execute(points, this.constraintsScanlineComparator, this.constraintsScanlineHandler);
        this.normalizeHitboxes(filterFun, spacingFun);
    }

    private void blowUpHitboxes(Predicate<CNode> filter2, Function<CNode, Double> spacingFun) {
        for (CNode n : this.compactor.cGraph.cNodes) {
            double spacing;
            if (!filter2.apply((Object)n) || !((spacing = ((Double)spacingFun.apply((Object)n)).doubleValue()) > 0.0)) continue;
            if (!(this.compactor.direction.isHorizontal() && n.spacingIgnore.up || this.compactor.direction.isVertical() && n.spacingIgnore.left)) {
                n.hitbox.y -= Math.max(0.0, spacing / 2.0 - 0.5);
            }
            if (this.compactor.direction.isHorizontal() && n.spacingIgnore.down || this.compactor.direction.isVertical() && n.spacingIgnore.right) continue;
            n.hitbox.height += Math.max(0.0, spacing - 1.0);
        }
    }

    private void normalizeHitboxes(Predicate<CNode> filter2, Function<CNode, Double> spacingFun) {
        for (CNode n : this.compactor.cGraph.cNodes) {
            double spacing;
            if (!filter2.apply((Object)n) || !((spacing = ((Double)spacingFun.apply((Object)n)).doubleValue()) > 0.0)) continue;
            if (!(this.compactor.direction.isHorizontal() && n.spacingIgnore.up || this.compactor.direction.isVertical() && n.spacingIgnore.left)) {
                n.hitbox.y += Math.max(0.0, spacing / 2.0 - 0.5);
            }
            if (this.compactor.direction.isHorizontal() && n.spacingIgnore.down || this.compactor.direction.isVertical() && n.spacingIgnore.right) continue;
            n.hitbox.height -= spacing - 1.0;
        }
    }

    private class ConstraintsScanlineHandler
    implements Scanline.EventHandler<Timestamp> {
        private TreeSet<CNode> intervals = Sets.newTreeSet((c1, c2) -> Double.compare(c1.hitbox.x + c1.hitbox.width / 2.0, c2.hitbox.x + c2.hitbox.width / 2.0));
        private CNode[] cand;

        private ConstraintsScanlineHandler() {
        }

        public void reset() {
            this.intervals.clear();
            this.cand = new CNode[ScanlineConstraintCalculator.this.compactor.cGraph.cNodes.size()];
            int index = 0;
            for (CNode n : ScanlineConstraintCalculator.this.compactor.cGraph.cNodes) {
                n.id = index++;
            }
        }

        @Override
        public void handle(Timestamp p) {
            if (p.low) {
                this.insert(p);
            } else {
                this.delete(p);
            }
        }

        private void insert(Timestamp p) {
            this.intervals.add(p.node);
            this.cand[((Timestamp)p).node.id] = this.intervals.lower(p.node);
            CNode right2 = this.intervals.higher(p.node);
            if (right2 != null) {
                this.cand[right2.id] = p.node;
            }
        }

        private void delete(Timestamp p) {
            CNode right2;
            CNode left = this.intervals.lower(p.node);
            if (left != null && left == this.cand[((Timestamp)p).node.id] && left.cGroup != null && left.cGroup != ((Timestamp)p).node.cGroup) {
                left.constraints.add(p.node);
            }
            if ((right2 = this.intervals.higher(p.node)) != null && this.cand[right2.id] == p.node && right2.cGroup != null && right2.cGroup != ((Timestamp)p).node.cGroup) {
                ((Timestamp)p).node.constraints.add(right2);
            }
            this.intervals.remove(p.node);
        }
    }

    private class Timestamp {
        private boolean low;
        private CNode node;

        public Timestamp(CNode node, boolean low) {
            this.node = node;
            this.low = low;
        }
    }
}

