/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p4nodes.LinearSegmentsNodePlacer;
import org.eclipse.elk.alg.layered.p5edges.OrthogonalRoutingGenerator;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.graph.properties.IProperty;

public final class JsonDebugUtil {
    private static final String FILE_EXTENSION = ".json";
    private static final String INDENT = "  ";

    private JsonDebugUtil() {
    }

    public static void writeDebugGraph(LGraph lgraph, int slotIndex, String name) {
        try {
            Writer writer = DebugUtil.createWriter(lgraph, slotIndex, name, FILE_EXTENSION);
            JsonDebugUtil.beginGraph(writer, lgraph);
            JsonDebugUtil.writeLgraph(lgraph, writer, 1);
            JsonDebugUtil.endGraph(writer);
            writer.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void writeDebugGraph(LGraph layeredGraph, List<LinearSegmentsNodePlacer.LinearSegment> segmentList, List<List<LinearSegmentsNodePlacer.LinearSegment>> outgoingList) {
        try {
            Writer writer = DebugUtil.createWriter(layeredGraph, FILE_EXTENSION);
            JsonDebugUtil.beginGraph(writer, layeredGraph);
            JsonDebugUtil.beginChildNodeList(writer, 1);
            String indent1 = Strings.repeat((String)INDENT, (int)2);
            String indent2 = Strings.repeat((String)INDENT, (int)3);
            int edgeId = 0;
            Iterator<LinearSegmentsNodePlacer.LinearSegment> segmentIterator = segmentList.iterator();
            Iterator<List<LinearSegmentsNodePlacer.LinearSegment>> successorsIterator = outgoingList.iterator();
            StringBuffer edges = new StringBuffer();
            while (segmentIterator.hasNext()) {
                LinearSegmentsNodePlacer.LinearSegment segment = segmentIterator.next();
                writer.write("\n" + indent1 + "{\n" + indent2 + "\"id\": \"n" + segment.hashCode() + "\",\n" + indent2 + "\"labels\": [ { \"text\": \"" + segment + "\" } ],\n" + indent2 + "\"width\": 50,\n" + indent2 + "\"height\": 25\n" + indent1 + "}");
                if (segmentIterator.hasNext()) {
                    writer.write(",");
                }
                for (LinearSegmentsNodePlacer.LinearSegment successor : successorsIterator.next()) {
                    edges.append("\n" + indent1 + "{\n" + indent2 + "\"id\": \"e" + edgeId++ + "\",\n" + indent2 + "\"source\": \"n" + segment.hashCode() + "\",\n" + indent2 + "\"target\": \"n" + successor.hashCode() + "\",\n" + indent1 + "},");
                }
            }
            JsonDebugUtil.endChildNodeList(writer, 1);
            if (edges.length() > 0) {
                edges.deleteCharAt(edges.length() - 1);
            }
            writer.write("  \"edges\": [" + edges + "\n" + indent1 + "]");
            JsonDebugUtil.endGraph(writer);
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void writeDebugGraph(LGraph layeredGraph, int layerIndex, List<OrthogonalRoutingGenerator.HyperNode> hypernodes, String debugPrefix, String label) {
        try {
            Writer writer = DebugUtil.createWriter(layeredGraph, layerIndex, debugPrefix, label, FILE_EXTENSION);
            JsonDebugUtil.beginGraph(writer, layeredGraph);
            JsonDebugUtil.beginChildNodeList(writer, 1);
            String indent1 = Strings.repeat((String)INDENT, (int)2);
            String indent2 = Strings.repeat((String)INDENT, (int)3);
            int edgeId = 0;
            Iterator<OrthogonalRoutingGenerator.HyperNode> hypernodeIterator = hypernodes.iterator();
            StringBuffer edges = new StringBuffer();
            while (hypernodeIterator.hasNext()) {
                OrthogonalRoutingGenerator.HyperNode hypernode = hypernodeIterator.next();
                writer.write("\n" + indent1 + "{\n" + indent2 + "\"id\": \"n" + System.identityHashCode(hypernode) + "\",\n" + indent2 + "\"labels\": [ { \"text\": \"" + hypernode.toString() + "\" } ],\n" + indent2 + "\"width\": 50,\n" + indent2 + "\"height\": 25\n" + indent1 + "}");
                if (hypernodeIterator.hasNext()) {
                    writer.write(",");
                }
                for (OrthogonalRoutingGenerator.Dependency dependency : hypernode.getOutgoing()) {
                    edges.append("\n" + indent1 + "{\n" + indent2 + "\"id\": \"e" + edgeId++ + "\",\n" + indent2 + "\"source\": \"n" + System.identityHashCode(hypernode) + "\",\n" + indent2 + "\"target\": \"n" + System.identityHashCode(dependency.getTarget()) + "\"\n" + indent1 + "},");
                }
            }
            JsonDebugUtil.endChildNodeList(writer, 1);
            if (edges.length() > 0) {
                edges.deleteCharAt(edges.length() - 1);
            }
            writer.write("  \"edges\": [" + edges + "\n" + INDENT + "]");
            JsonDebugUtil.endGraph(writer);
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static KVectorChain calculateGraphSize(LGraph lgraph) {
        KVector min = new KVector();
        KVector max = new KVector();
        for (LNode node : lgraph.getLayerlessNodes()) {
            JsonDebugUtil.calculateMinMaxPositions(min, max, node);
        }
        for (Layer layer : lgraph) {
            for (LNode node : layer) {
                JsonDebugUtil.calculateMinMaxPositions(min, max, node);
            }
        }
        max.x -= min.x;
        max.y -= min.y;
        return new KVectorChain(min, max);
    }

    private static void calculateMinMaxPositions(KVector min, KVector max, LNode node) {
        min.x = Math.min(min.x, node.getPosition().x - node.getMargin().left);
        max.x = Math.max(max.x, node.getPosition().x + node.getSize().x + node.getMargin().right);
        min.y = Math.min(min.y, node.getPosition().y - node.getMargin().top);
        max.y = Math.max(max.y, node.getPosition().y + node.getSize().y + node.getMargin().bottom);
        for (LPort port : node.getPorts()) {
            min.x = Math.min(min.x, node.getPosition().x + port.getPosition().x - port.getMargin().left);
            max.x = Math.max(max.x, node.getPosition().x + port.getPosition().x + port.getSize().x + port.getMargin().right);
            min.y = Math.min(min.y, node.getPosition().y + port.getPosition().y - port.getMargin().top);
            max.y = Math.max(max.y, node.getPosition().y + port.getPosition().y + port.getSize().y + port.getMargin().bottom);
        }
        for (LEdge edge : node.getOutgoingEdges()) {
            for (KVector bendpoint : edge.getBendPoints()) {
                min.x = Math.min(min.x, bendpoint.x);
                max.x = Math.max(max.x, bendpoint.x);
                min.y = Math.min(min.y, bendpoint.y);
                max.y = Math.max(max.y, bendpoint.y);
            }
        }
    }

    private static void beginGraph(Writer writer, LGraph lgraph) throws IOException {
        KVectorChain graphSize = JsonDebugUtil.calculateGraphSize(lgraph);
        writer.write("{\n  \"id\": \"root\",\n  \"x\": " + ((KVector)graphSize.getFirst()).x + ",\n" + INDENT + "\"y\": " + ((KVector)graphSize.getFirst()).y + ",\n" + INDENT + "\"width\": " + ((KVector)graphSize.getLast()).x + ",\n" + INDENT + "\"height\": " + ((KVector)graphSize.getLast()).y + ",\n");
        JsonDebugUtil.writeProperties(writer, lgraph.getAllProperties(), 1);
    }

    private static void writeLgraph(LGraph lgraph, Writer writer, int indentation) throws IOException {
        KVector offset2 = new KVector(lgraph.getOffset()).add(lgraph.getPadding().left, lgraph.getPadding().top);
        LinkedList edges = Lists.newLinkedList();
        JsonDebugUtil.beginChildNodeList(writer, indentation);
        edges.addAll(JsonDebugUtil.writeLayer(writer, -1, lgraph.getLayerlessNodes(), indentation + 1, offset2));
        int layerNumber = -1;
        Iterator<Layer> layersIterator = lgraph.iterator();
        if (!lgraph.getLayerlessNodes().isEmpty() && layersIterator.hasNext()) {
            writer.write(",");
        }
        while (layersIterator.hasNext()) {
            Layer layer = layersIterator.next();
            edges.addAll(JsonDebugUtil.writeLayer(writer, ++layerNumber, layer.getNodes(), indentation + 1, offset2));
            if (!layersIterator.hasNext()) continue;
            writer.write(",");
        }
        JsonDebugUtil.endChildNodeList(writer, indentation);
        JsonDebugUtil.writeEdges(writer, edges, indentation, offset2);
    }

    private static void beginChildNodeList(Writer writer, int indentation) throws IOException {
        writer.write(",\n" + Strings.repeat((String)INDENT, (int)indentation) + "\"children\": [");
    }

    private static void endChildNodeList(Writer writer, int indentation) throws IOException {
        writer.write("\n" + Strings.repeat((String)INDENT, (int)indentation) + "],\n");
    }

    private static void endGraph(Writer writer) throws IOException {
        writer.write("\n}\n");
    }

    private static List<LEdge> writeLayer(Writer writer, int layerNumber, List<LNode> nodes, int indentation, KVector offset2) throws IOException {
        if (nodes.isEmpty()) {
            return Lists.newLinkedList();
        }
        JsonDebugUtil.writeNodes(writer, nodes, indentation, layerNumber, offset2);
        LinkedList edges = Lists.newLinkedList();
        for (LNode node : nodes) {
            for (LPort port : node.getPorts()) {
                edges.addAll(port.getOutgoingEdges());
            }
        }
        return edges;
    }

    private static void writeNodes(Writer writer, List<LNode> nodes, int indentation, int layerNumber, KVector offset2) throws IOException {
        String indent0 = Strings.repeat((String)INDENT, (int)indentation);
        String indent1 = Strings.repeat((String)INDENT, (int)(indentation + 1));
        int nodeNumber = -1;
        Iterator<LNode> nodesIterator = nodes.iterator();
        while (nodesIterator.hasNext()) {
            LNode node = nodesIterator.next();
            KVector position = new KVector(node.getPosition()).add(offset2);
            writer.write("\n" + indent0 + "{\n" + indent1 + "\"id\": \"n" + node.hashCode() + "\",\n" + indent1 + "\"labels\": [ { \"text\": \"" + JsonDebugUtil.getNodeName(node, layerNumber, ++nodeNumber) + "\" } ],\n" + indent1 + "\"width\": " + node.getSize().x + ",\n" + indent1 + "\"height\": " + node.getSize().y + ",\n" + indent1 + "\"x\": " + position.x + ",\n" + indent1 + "\"y\": " + position.y + ",\n");
            JsonDebugUtil.writeProperties(writer, node.getAllProperties(), indentation + 1);
            writer.write(",\n");
            JsonDebugUtil.writePorts(writer, node.getPorts(), indentation + 1);
            LGraph nestedGraph = node.getProperty(InternalProperties.NESTED_LGRAPH);
            if (nestedGraph != null) {
                JsonDebugUtil.writeLgraph(nestedGraph, writer, indentation + 1);
            }
            writer.write("\n" + indent0 + "}");
            if (!nodesIterator.hasNext()) continue;
            writer.write(",");
        }
    }

    private static void writeEdges(Writer writer, List<LEdge> edges, int indentation, KVector offset2) throws IOException {
        String indent0 = Strings.repeat((String)INDENT, (int)indentation);
        String indent1 = Strings.repeat((String)INDENT, (int)(indentation + 1));
        String indent2 = Strings.repeat((String)INDENT, (int)(indentation + 2));
        writer.write(String.valueOf(indent0) + "\"edges\": [");
        Iterator<LEdge> edgesIterator = edges.iterator();
        while (edgesIterator.hasNext()) {
            LEdge edge = edgesIterator.next();
            KVector source = new KVector(edge.getSource().getAbsoluteAnchor()).add(offset2);
            KVector target = new KVector(edge.getTarget().getAbsoluteAnchor()).add(offset2);
            if (edge.getProperty(InternalProperties.TARGET_OFFSET) != null) {
                target.add(edge.getProperty(InternalProperties.TARGET_OFFSET));
            }
            writer.write("\n" + indent1 + "{\n" + indent2 + "\"id\": \"e" + edge.hashCode() + "\",\n" + indent2 + "\"source\": \"n" + edge.getSource().getNode().hashCode() + "\",\n" + indent2 + "\"target\": \"n" + edge.getTarget().getNode().hashCode() + "\",\n" + indent2 + "\"sourcePort\": \"p" + edge.getSource().hashCode() + "\",\n" + indent2 + "\"targetPort\": \"p" + edge.getTarget().hashCode() + "\",\n" + indent2 + "\"sourcePoint\": { \"x\": " + source.x + ", \"y\": " + source.y + " },\n" + indent2 + "\"targetPoint\": { \"x\": " + target.x + ", \"y\": " + target.y + " },\n");
            JsonDebugUtil.writeBendPoints(writer, edge.getBendPoints(), indentation + 2, offset2);
            writer.write(",\n");
            JsonDebugUtil.writeProperties(writer, edge.getAllProperties(), indentation + 2);
            writer.write("\n" + indent1 + "}");
            if (!edgesIterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n" + indent0 + "]");
    }

    private static void writeBendPoints(Writer writer, KVectorChain bendPoints, int indentation, KVector offset2) throws IOException {
        String indent0 = Strings.repeat((String)INDENT, (int)indentation);
        String indent1 = Strings.repeat((String)INDENT, (int)(indentation + 1));
        writer.write(String.valueOf(indent0) + "\"bendPoints\": [");
        Iterator pointsIterator = bendPoints.iterator();
        while (pointsIterator.hasNext()) {
            KVector point = new KVector((KVector)pointsIterator.next()).add(offset2);
            writer.write("\n" + indent1 + "{ \"x\": " + point.x + ", \"y\": " + point.y + "}");
            if (!pointsIterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n" + indent0 + "]");
    }

    private static void writePorts(Writer writer, List<LPort> ports, int indentation) throws IOException {
        String indent0 = Strings.repeat((String)INDENT, (int)indentation);
        String indent1 = Strings.repeat((String)INDENT, (int)(indentation + 1));
        String indent2 = Strings.repeat((String)INDENT, (int)(indentation + 2));
        writer.write(String.valueOf(indent0) + "\"ports\": [");
        Iterator<LPort> portsIterator = ports.iterator();
        while (portsIterator.hasNext()) {
            LPort port = portsIterator.next();
            writer.write("\n" + indent1 + "{\n" + indent2 + "\"id\": \"p" + port.hashCode() + "\",\n" + indent2 + "\"width\": " + port.getSize().x + ",\n" + indent2 + "\"height\": " + port.getSize().y + ",\n" + indent2 + "\"x\": " + port.getPosition().x + ",\n" + indent2 + "\"y\": " + port.getPosition().y + ",\n");
            JsonDebugUtil.writeProperties(writer, port.getAllProperties(), indentation + 2);
            writer.write("\n" + indent1 + "}");
            if (!portsIterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n" + indent0 + "]");
    }

    private static void writeProperties(Writer writer, Map<IProperty<?>, Object> properties, int indentation) throws IOException {
        String indent0 = Strings.repeat((String)INDENT, (int)indentation);
        String indent1 = Strings.repeat((String)INDENT, (int)(indentation + 1));
        writer.write(String.valueOf(indent0) + "\"properties\": {");
        Iterator<Map.Entry<IProperty<?>, Object>> propertiesIterator = properties.entrySet().iterator();
        while (propertiesIterator.hasNext()) {
            Map.Entry<IProperty<?>, Object> property = propertiesIterator.next();
            String id2 = property.getKey().getId();
            String val = JsonDebugUtil.getValueRepresentation(property.getKey(), property.getValue());
            writer.write("\n" + indent1 + "\"" + id2 + "\": \"" + val.replace("\"", "\\\"") + "\"");
            if (!propertiesIterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n" + indent0 + "}");
    }

    private static String getValueRepresentation(IProperty<?> property, Object value2) {
        if (property.getId().equals(InternalProperties.PROCESSORS.getId())) {
            Iterator processors = ((List)value2).iterator();
            StringBuffer result = new StringBuffer("[");
            while (processors.hasNext()) {
                ILayoutProcessor processor = (ILayoutProcessor)processors.next();
                result.append(processor.getClass().getSimpleName());
                if (!processors.hasNext()) continue;
                result.append(", ");
            }
            result.append("]");
            return result.toString();
        }
        return value2.toString().replace("\n", "\\n");
    }

    private static String getNodeName(LNode node, int layer, int index) {
        String name = "";
        if (node.getType() == LNode.NodeType.NORMAL) {
            if (node.getName() != null) {
                name = node.getName();
            }
            name = String.valueOf(name) + " (" + layer + "," + index + ")";
        } else {
            Object origin;
            name = node.getName() != null ? node.getName() : "n_" + node.id;
            if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT && (origin = node.getProperty(InternalProperties.ORIGIN)) instanceof LNode) {
                name = String.valueOf(name) + "(" + ((LNode)origin).toString() + ")";
            }
            name = String.valueOf(name) + " (" + layer + "," + index + ")";
            name = String.valueOf(name) + " [ DUMMY: " + node.getType().name() + " ]";
        }
        return name.replace("\"", "\\\"").replace("\n", "\\n");
    }
}

