/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.GreedySwitchType;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodePromotionStrategy;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.alg.layered.p5edges.EdgeRouterFactory;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.HierarchyHandling;

final class GraphConfigurator {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.NODE_MARGIN_CALCULATOR).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.LABEL_AND_NODE_SIZE_PROCESSOR).addBefore(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> LABEL_MANAGEMENT_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.CENTER_LABEL_MANAGEMENT_PROCESSOR).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.END_NODE_PORT_LABEL_MANAGEMENT_PROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HIERARCHICAL_ADDITIONS = LayoutProcessorConfiguration.create().addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.HIERARCHICAL_NODE_RESIZER);
    private final AlgorithmAssembler<LayeredPhases, LGraph> algorithmAssembler = AlgorithmAssembler.create(LayeredPhases.class);
    private static final double MIN_EDGE_SPACING = 2.0;

    GraphConfigurator() {
    }

    private void configureGraphProperties(LGraph lgraph) {
        Integer randomSeed;
        Direction direction;
        double edgeSpacing = lgraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        if (edgeSpacing < 2.0) {
            lgraph.setProperty(LayeredOptions.SPACING_EDGE_EDGE, (Object)2.0);
        }
        if ((direction = lgraph.getProperty(LayeredOptions.DIRECTION)) == Direction.UNDEFINED) {
            lgraph.setProperty(LayeredOptions.DIRECTION, (Object)LGraphUtil.getDirection(lgraph));
        }
        if ((randomSeed = lgraph.getProperty(LayeredOptions.RANDOM_SEED)) == 0) {
            lgraph.setProperty(InternalProperties.RANDOM, new Random());
        } else {
            lgraph.setProperty(InternalProperties.RANDOM, new Random(randomSeed.intValue()));
        }
        Boolean favorStraightness = lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES);
        if (favorStraightness == null) {
            lgraph.setProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES, (Object)(lgraph.getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL ? 1 : 0));
        }
        Spacings spacings = new Spacings(lgraph);
        lgraph.setProperty(InternalProperties.SPACINGS, spacings);
    }

    public void prepareGraphForLayout(LGraph lgraph) {
        this.configureGraphProperties(lgraph);
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase(LayeredPhases.P1_CYCLE_BREAKING, lgraph.getProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P2_LAYERING, lgraph.getProperty(LayeredOptions.LAYERING_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P3_NODE_ORDERING, lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P4_NODE_PLACEMENT, lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P5_EDGE_ROUTING, EdgeRouterFactory.factoryFor(lgraph.getProperty(LayeredOptions.EDGE_ROUTING)));
        this.algorithmAssembler.addProcessorConfiguration(this.getPhaseIndependentLayoutProcessorConfiguration(lgraph));
        lgraph.setProperty(InternalProperties.PROCESSORS, this.algorithmAssembler.build(lgraph));
    }

    private LayoutProcessorConfiguration<LayeredPhases, LGraph> getPhaseIndependentLayoutProcessorConfiguration(LGraph lgraph) {
        Set<GraphProperties> graphProperties = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        LayoutProcessorConfiguration<LayeredPhases, LGraph> configuration = LayoutProcessorConfiguration.createFrom(BASELINE_PROCESSING_CONFIGURATION);
        HierarchyHandling hierarchyHandling = lgraph.getProperty(LayeredOptions.HIERARCHY_HANDLING);
        if (hierarchyHandling == HierarchyHandling.INCLUDE_CHILDREN) {
            configuration.addAll(HIERARCHICAL_ADDITIONS);
        }
        if (lgraph.getProperty(LayeredOptions.FEEDBACK_EDGES).booleanValue()) {
            configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        } else {
            configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        }
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) != null) {
            configuration.addAll(LABEL_MANAGEMENT_ADDITIONS);
        }
        switch (lgraph.getProperty(LayeredOptions.DIRECTION)) {
            case LEFT: {
                configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.LEFT_DIR_PREPROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.LEFT_DIR_POSTPROCESSOR);
                break;
            }
            case DOWN: {
                configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.DOWN_DIR_PREPROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.DOWN_DIR_POSTPROCESSOR);
                break;
            }
            case UP: {
                configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.UP_DIR_PREPROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.UP_DIR_POSTPROCESSOR);
                break;
            }
        }
        if (graphProperties.contains((Object)GraphProperties.COMMENTS)) {
            configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.COMMENT_PREPROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.COMMENT_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_STRATEGY) != NodePromotionStrategy.NONE) {
            configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.NODE_PROMOTION);
        }
        if (graphProperties.contains((Object)GraphProperties.PARTITIONS)) {
            configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.PARTITION_PREPROCESSOR);
            configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.PARTITION_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_STRATEGY) != GraphCompactionStrategy.NONE && lgraph.getProperty(LayeredOptions.EDGE_ROUTING) != EdgeRouting.POLYLINE) {
            configuration.addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.HORIZONTAL_COMPACTOR);
        }
        if (lgraph.getProperty(LayeredOptions.HIGH_DEGREE_NODES_TREATMENT).booleanValue()) {
            configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.HIGH_DEGREE_NODE_LAYER_PROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_SEMI_INTERACTIVE).booleanValue()) {
            configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.SEMI_INTERACTIVE_CROSSMIN_PROCESSOR);
        }
        if (GraphConfigurator.activateGreedySwitchFor(lgraph)) {
            GreedySwitchType greedySwitchType = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE);
            IntermediateProcessorStrategy internalGreedyType = greedySwitchType == GreedySwitchType.ONE_SIDED ? IntermediateProcessorStrategy.ONE_SIDED_GREEDY_SWITCH : IntermediateProcessorStrategy.TWO_SIDED_GREEDY_SWITCH;
            configuration.addBefore(LayeredPhases.P4_NODE_PLACEMENT, internalGreedyType);
        }
        switch (lgraph.getProperty(LayeredOptions.WRAPPING_STRATEGY)) {
            case SINGLE_EDGE: {
                configuration.addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.SINGLE_EDGE_GRAPH_WRAPPER);
                break;
            }
            case MULTI_EDGE: {
                configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.BREAKING_POINT_INSERTER).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.BREAKING_POINT_PROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.BREAKING_POINT_REMOVER);
            }
        }
        return configuration;
    }

    public static boolean activateGreedySwitchFor(LGraph lgraph) {
        GreedySwitchType greedySwitchType = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE);
        boolean interactiveCrossMin = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_SEMI_INTERACTIVE) != false || lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY) == CrossingMinimizationStrategy.INTERACTIVE;
        int activationThreshold = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_ACTIVATION_THRESHOLD);
        int graphSize = lgraph.getLayerlessNodes().size();
        return !interactiveCrossMin && greedySwitchType != GreedySwitchType.OFF && (activationThreshold == 0 || activationThreshold > graphSize);
    }
}

