/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.lang.reflect.Field;
import java.util.Arrays;

public class Objects {
    private Objects() {
    }

    public static String toString(Object o) {
        Class<?> c = o.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append(c.getSimpleName()).append('[');
        int i = 0;
        for (Field f : c.getDeclaredFields()) {
            if ((f.getModifiers() & 0x88) != 0) continue;
            f.setAccessible(true);
            try {
                Object value2 = f.get(o);
                if (i++ > 0) {
                    sb.append(',');
                }
                sb.append(f.getName());
                sb.append('=');
                if (value2.getClass().isArray()) {
                    if (value2.getClass() == boolean[].class) {
                        sb.append(Arrays.toString((boolean[])value2));
                        continue;
                    }
                    if (value2.getClass() == byte[].class) {
                        sb.append(Arrays.toString((byte[])value2));
                        continue;
                    }
                    if (value2.getClass() == char[].class) {
                        sb.append(Arrays.toString((char[])value2));
                        continue;
                    }
                    if (value2.getClass() == double[].class) {
                        sb.append(Arrays.toString((double[])value2));
                        continue;
                    }
                    if (value2.getClass() == float[].class) {
                        sb.append(Arrays.toString((float[])value2));
                        continue;
                    }
                    if (value2.getClass() == int[].class) {
                        sb.append(Arrays.toString((int[])value2));
                        continue;
                    }
                    if (value2.getClass() == long[].class) {
                        sb.append(Arrays.toString((long[])value2));
                        continue;
                    }
                    if (value2.getClass() == short[].class) {
                        sb.append(Arrays.toString((short[])value2));
                        continue;
                    }
                    sb.append(Arrays.toString((Object[])value2));
                    continue;
                }
                if (value2.getClass() == Character.class) {
                    sb.append('\'').append(value2).append('\'');
                    continue;
                }
                if (value2.getClass() == String.class) {
                    sb.append('\"').append(value2).append('\"');
                    continue;
                }
                sb.append(value2);
            }
            catch (IllegalAccessException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

