/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.libcore.io.BridgeBufferIterator;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import libcore.io.BufferIterator;
import libcore.io.MemoryMappedFile;

public class MemoryMappedFile_Delegate {
    private static final DelegateManager<MemoryMappedFile_Delegate> sManager = new DelegateManager<MemoryMappedFile_Delegate>(MemoryMappedFile_Delegate.class);
    private static final Map<MemoryMappedFile, Long> sMemoryMappedFileMap = new HashMap<MemoryMappedFile, Long>();
    private final MappedByteBuffer mMappedByteBuffer;
    private final long mSize;
    private static final String TARGET_PATH = System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo";
    private static File sRootPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static MemoryMappedFile mmapRO(String path) throws ErrnoException {
        MemoryMappedFile memoryMappedFile;
        if (!path.startsWith(TARGET_PATH)) {
            throw new ErrnoException("Custom timezone data files are not supported.", 1);
        }
        if (sRootPath == null) {
            throw new ErrnoException("Bridge has not been initialized properly.", 1);
        }
        path = path.substring(TARGET_PATH.length());
        File f = new File(sRootPath, path);
        if (!f.exists()) {
            throw new ErrnoException("File not found: " + f.getPath(), 1);
        }
        RandomAccessFile file2 = new RandomAccessFile(f, "r");
        try {
            long size = file2.length();
            MemoryMappedFile_Delegate newDelegate = new MemoryMappedFile_Delegate(file2);
            long filePointer = file2.getFilePointer();
            MemoryMappedFile mmFile = new MemoryMappedFile(filePointer, size);
            long delegateIndex = sManager.addNewDelegate(newDelegate);
            sMemoryMappedFileMap.put(mmFile, delegateIndex);
            memoryMappedFile = mmFile;
        }
        catch (Throwable throwable) {
            try {
                file2.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ErrnoException("mmapRO", 1, e);
            }
        }
        file2.close();
        return memoryMappedFile;
    }

    @LayoutlibDelegate
    static void close(MemoryMappedFile thisFile) throws ErrnoException {
        Long index = sMemoryMappedFileMap.get(thisFile);
        if (index != null) {
            sMemoryMappedFileMap.remove(thisFile);
            sManager.removeJavaReferenceFor(index);
        }
    }

    @LayoutlibDelegate
    static BufferIterator bigEndianIterator(MemoryMappedFile file2) {
        MemoryMappedFile_Delegate delegate = MemoryMappedFile_Delegate.getDelegate(file2);
        return new BridgeBufferIterator(delegate.mSize, delegate.mMappedByteBuffer.duplicate());
    }

    public MemoryMappedFile_Delegate(RandomAccessFile file2) throws IOException {
        this.mSize = file2.length();
        this.mMappedByteBuffer = file2.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.mSize);
        assert (this.mMappedByteBuffer.order() == ByteOrder.BIG_ENDIAN);
    }

    public static void setDataDir(File path) {
        sRootPath = path;
    }

    private static MemoryMappedFile_Delegate getDelegate(MemoryMappedFile file2) {
        Long index = sMemoryMappedFileMap.get(file2);
        return index == null ? null : sManager.getDelegate(index);
    }
}

