/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.nio.ByteOrder;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class Memory {
    private Memory() {
    }

    public static void unsafeBulkGet(Object object, int n, int n2, byte[] byArray, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#unsafeBulkGet(Ljava/lang/Object;II[BIIZ)V", true, null);
    }

    public static void unsafeBulkPut(byte[] byArray, int n, int n2, Object object, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#unsafeBulkPut([BIILjava/lang/Object;IIZ)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static int peekInt(byte[] src, int offset2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset2++] & 0xFF) << 24 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 8 | (src[offset2] & 0xFF) << 0;
        }
        return (src[offset2++] & 0xFF) << 0 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 16 | (src[offset2] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset2++] & 0xFF) << 24 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 0;
            int l = (src[offset2++] & 0xFF) << 24 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 8 | (src[offset2] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset2++] & 0xFF) << 0 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 16 | (src[offset2++] & 0xFF) << 24;
        int h = (src[offset2++] & 0xFF) << 0 | (src[offset2++] & 0xFF) << 8 | (src[offset2++] & 0xFF) << 16 | (src[offset2] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static short peekShort(byte[] src, int offset2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset2] << 8 | src[offset2 + 1] & 0xFF);
        }
        return (short)(src[offset2 + 1] << 8 | src[offset2] & 0xFF);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void pokeInt(byte[] dst, int offset2, int value2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset2++] = (byte)(value2 >> 24 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 16 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 8 & 0xFF);
            dst[offset2] = (byte)(value2 >> 0 & 0xFF);
        } else {
            dst[offset2++] = (byte)(value2 >> 0 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 8 & 0xFF);
            dst[offset2++] = (byte)(value2 >> 16 & 0xFF);
            dst[offset2] = (byte)(value2 >> 24 & 0xFF);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void pokeLong(byte[] dst, int offset2, long value2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = (int)(value2 >> 32);
            dst[offset2++] = (byte)(i >> 24 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2++] = (byte)(i >> 0 & 0xFF);
            i = (int)value2;
            dst[offset2++] = (byte)(i >> 24 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2] = (byte)(i >> 0 & 0xFF);
        } else {
            int i = (int)value2;
            dst[offset2++] = (byte)(i >> 0 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2++] = (byte)(i >> 24 & 0xFF);
            i = (int)(value2 >> 32);
            dst[offset2++] = (byte)(i >> 0 & 0xFF);
            dst[offset2++] = (byte)(i >> 8 & 0xFF);
            dst[offset2++] = (byte)(i >> 16 & 0xFF);
            dst[offset2] = (byte)(i >> 24 & 0xFF);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void pokeShort(byte[] dst, int offset2, short value2, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset2++] = (byte)(value2 >> 8 & 0xFF);
            dst[offset2] = (byte)(value2 >> 0 & 0xFF);
        } else {
            dst[offset2++] = (byte)(value2 >> 0 & 0xFF);
            dst[offset2] = (byte)(value2 >> 8 & 0xFF);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void memmove(Object object, int n, Object object2, int n2, long l) {
        OverrideMethod.invokeV("libcore.io.Memory#memmove(Ljava/lang/Object;ILjava/lang/Object;IJ)V", true, null);
    }

    @UnsupportedAppUsage
    @FastNative
    public static byte peekByte(long l) {
        return (byte)OverrideMethod.invokeI("libcore.io.Memory#peekByte(J)B", true, null);
    }

    @UnsupportedAppUsage
    public static int peekInt(long address, boolean swap) {
        int result = Memory.peekIntNative(address);
        if (swap) {
            result = Integer.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static int peekIntNative(long l) {
        return OverrideMethod.invokeI("libcore.io.Memory#peekIntNative(J)I", true, null);
    }

    @UnsupportedAppUsage
    public static long peekLong(long address, boolean swap) {
        long result = Memory.peekLongNative(address);
        if (swap) {
            result = Long.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static long peekLongNative(long l) {
        return OverrideMethod.invokeL("libcore.io.Memory#peekLongNative(J)J", true, null);
    }

    public static short peekShort(long address, boolean swap) {
        short result = Memory.peekShortNative(address);
        if (swap) {
            result = Short.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static short peekShortNative(long l) {
        return (short)OverrideMethod.invokeI("libcore.io.Memory#peekShortNative(J)S", true, null);
    }

    @UnsupportedAppUsage
    public static void peekByteArray(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("libcore.io.Memory#peekByteArray(J[BII)V", true, null);
    }

    public static void peekCharArray(long l, char[] cArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekCharArray(J[CIIZ)V", true, null);
    }

    public static void peekDoubleArray(long l, double[] dArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekDoubleArray(J[DIIZ)V", true, null);
    }

    public static void peekFloatArray(long l, float[] fArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekFloatArray(J[FIIZ)V", true, null);
    }

    public static void peekIntArray(long l, int[] nArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekIntArray(J[IIIZ)V", true, null);
    }

    public static void peekLongArray(long l, long[] lArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekLongArray(J[JIIZ)V", true, null);
    }

    public static void peekShortArray(long l, short[] sArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#peekShortArray(J[SIIZ)V", true, null);
    }

    @UnsupportedAppUsage
    @FastNative
    public static void pokeByte(long l, byte by) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeByte(JB)V", true, null);
    }

    @UnsupportedAppUsage
    public static void pokeInt(long address, int value2, boolean swap) {
        if (swap) {
            value2 = Integer.reverseBytes(value2);
        }
        Memory.pokeIntNative(address, value2);
    }

    @FastNative
    private static void pokeIntNative(long l, int n) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeIntNative(JI)V", true, null);
    }

    @UnsupportedAppUsage
    public static void pokeLong(long address, long value2, boolean swap) {
        if (swap) {
            value2 = Long.reverseBytes(value2);
        }
        Memory.pokeLongNative(address, value2);
    }

    @FastNative
    private static void pokeLongNative(long l, long l2) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeLongNative(JJ)V", true, null);
    }

    public static void pokeShort(long address, short value2, boolean swap) {
        if (swap) {
            value2 = Short.reverseBytes(value2);
        }
        Memory.pokeShortNative(address, value2);
    }

    @FastNative
    private static void pokeShortNative(long l, short s) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeShortNative(JS)V", true, null);
    }

    @UnsupportedAppUsage
    public static void pokeByteArray(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeByteArray(J[BII)V", true, null);
    }

    public static void pokeCharArray(long l, char[] cArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeCharArray(J[CIIZ)V", true, null);
    }

    public static void pokeDoubleArray(long l, double[] dArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeDoubleArray(J[DIIZ)V", true, null);
    }

    public static void pokeFloatArray(long l, float[] fArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeFloatArray(J[FIIZ)V", true, null);
    }

    public static void pokeIntArray(long l, int[] nArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeIntArray(J[IIIZ)V", true, null);
    }

    public static void pokeLongArray(long l, long[] lArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeLongArray(J[JIIZ)V", true, null);
    }

    public static void pokeShortArray(long l, short[] sArray, int n, int n2, boolean bl) {
        OverrideMethod.invokeV("libcore.io.Memory#pokeShortArray(J[SIIZ)V", true, null);
    }
}

