/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.annotation.SystemApi;
import dalvik.system.PathClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import sun.misc.CompoundEnumeration;

public class DelegateLastClassLoader
extends PathClassLoader {
    private final boolean delegateResourceLoading;

    public DelegateLastClassLoader(String dexPath, ClassLoader parent) {
        this(dexPath, null, parent, true);
    }

    public DelegateLastClassLoader(String dexPath, String librarySearchPath, ClassLoader parent) {
        this(dexPath, librarySearchPath, parent, true);
    }

    public DelegateLastClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, boolean delegateResourceLoading) {
        super(dexPath, librarySearchPath, parent);
        this.delegateResourceLoading = delegateResourceLoading;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public DelegateLastClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] sharedLibraryLoaders) {
        super(dexPath, librarySearchPath, parent, sharedLibraryLoaders);
        this.delegateResourceLoading = true;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve2) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl != null) {
            return cl;
        }
        try {
            return Object.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassNotFoundException fromSuper = null;
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                fromSuper = ex;
                try {
                    return this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    throw fromSuper;
                }
            }
        }
    }

    @Override
    public URL getResource(String name) {
        URL resource = Object.class.getClassLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        if (this.delegateResourceLoading) {
            ClassLoader cl = this.getParent();
            return cl == null ? null : cl.getResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[]{Object.class.getClassLoader().getResources(name), this.findResources(name), this.getParent() == null || !this.delegateResourceLoading ? null : this.getParent().getResources(name)};
        return new CompoundEnumeration(resources);
    }
}

