/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewHierarchyAction {
    private final int actionId;
    private final @Nullable CharSequence actionLabel;

    protected ViewHierarchyAction(int actionId, @Nullable CharSequence actionLabel) {
        this.actionId = actionId;
        this.actionLabel = actionLabel;
    }

    ViewHierarchyAction(AccessibilityHierarchyProtos.ViewHierarchyActionProto proto) {
        this.actionId = proto.getActionId();
        this.actionLabel = proto.hasActionLabel() ? proto.getActionLabel() : null;
    }

    int getActionId() {
        return this.actionId;
    }

    @Nullable CharSequence getActionLabel() {
        return this.actionLabel;
    }

    AccessibilityHierarchyProtos.ViewHierarchyActionProto toProto() {
        AccessibilityHierarchyProtos.ViewHierarchyActionProto.Builder builder2 = AccessibilityHierarchyProtos.ViewHierarchyActionProto.newBuilder();
        builder2.setActionId(this.actionId);
        if (!TextUtils.isEmpty(this.actionLabel)) {
            builder2.setActionLabel(this.actionLabel.toString());
        }
        return (AccessibilityHierarchyProtos.ViewHierarchyActionProto)builder2.build();
    }
}

