/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public class DisplayInfo {
    private final @Nullable Metrics metricsWithoutDecoration;
    private final @Nullable Metrics realMetrics;

    DisplayInfo(AccessibilityHierarchyProtos.DisplayInfoProto fromProto) {
        this.metricsWithoutDecoration = new Metrics(fromProto.getMetricsWithoutDecoration());
        this.realMetrics = fromProto.hasRealMetrics() ? new Metrics(fromProto.getRealMetrics()) : null;
    }

    protected DisplayInfo() {
        this.metricsWithoutDecoration = null;
        this.realMetrics = null;
    }

    public Metrics getMetricsWithoutDecoration() {
        Preconditions.checkNotNull((Object)this.metricsWithoutDecoration);
        return this.metricsWithoutDecoration;
    }

    public @Nullable Metrics getRealMetrics() {
        return this.realMetrics;
    }

    AccessibilityHierarchyProtos.DisplayInfoProto toProto() {
        Preconditions.checkNotNull((Object)this.metricsWithoutDecoration);
        AccessibilityHierarchyProtos.DisplayInfoProto.Builder builder2 = AccessibilityHierarchyProtos.DisplayInfoProto.newBuilder();
        builder2.setMetricsWithoutDecoration(this.metricsWithoutDecoration.toProto());
        if (this.realMetrics != null) {
            builder2.setRealMetrics(this.realMetrics.toProto());
        }
        return (AccessibilityHierarchyProtos.DisplayInfoProto)builder2.build();
    }

    @Immutable
    public static class Metrics {
        protected final float density;
        protected final float scaledDensity;
        protected final float xDpi;
        protected final float yDpi;
        protected final int densityDpi;
        protected final int heightPixels;
        protected final int widthPixels;

        Metrics(float density, float scaledDensity, float xDpi, float yDpi, int densityDpi, int heightPixels, int widthPixels) {
            this.density = density;
            this.scaledDensity = scaledDensity;
            this.xDpi = xDpi;
            this.yDpi = yDpi;
            this.densityDpi = densityDpi;
            this.heightPixels = heightPixels;
            this.widthPixels = widthPixels;
        }

        Metrics(AccessibilityHierarchyProtos.DisplayInfoMetricsProto fromProto) {
            this.density = fromProto.getDensity();
            this.scaledDensity = fromProto.getScaledDensity();
            this.xDpi = fromProto.getXDpi();
            this.yDpi = fromProto.getYDpi();
            this.densityDpi = fromProto.getDensityDpi();
            this.heightPixels = fromProto.getHeightPixels();
            this.widthPixels = fromProto.getWidthPixels();
        }

        public float getDensity() {
            return this.density;
        }

        public float getScaledDensity() {
            return this.scaledDensity;
        }

        public float getxDpi() {
            return this.xDpi;
        }

        public float getyDpi() {
            return this.yDpi;
        }

        public int getDensityDpi() {
            return this.densityDpi;
        }

        public int getHeightPixels() {
            return this.heightPixels;
        }

        public int getWidthPixels() {
            return this.widthPixels;
        }

        AccessibilityHierarchyProtos.DisplayInfoMetricsProto toProto() {
            AccessibilityHierarchyProtos.DisplayInfoMetricsProto.Builder builder2 = AccessibilityHierarchyProtos.DisplayInfoMetricsProto.newBuilder();
            builder2.setDensity(this.density);
            builder2.setScaledDensity(this.scaledDensity);
            builder2.setXDpi(this.xDpi);
            builder2.setYDpi(this.yDpi);
            builder2.setDensityDpi(this.densityDpi);
            builder2.setHeightPixels(this.heightPixels);
            builder2.setWidthPixels(this.widthPixels);
            return (AccessibilityHierarchyProtos.DisplayInfoMetricsProto)builder2.build();
        }
    }
}

