/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.base.Splitter;
import com.google.errorprone.annotations.Immutable;
import java.util.Locale;

@Immutable
public class DeviceState {
    protected static final Splitter HYPHEN_SPLITTER = Splitter.on((char)'-');
    private final DisplayInfo defaultDisplayInfo;
    protected final int sdkVersion;
    protected final Locale locale;

    DeviceState(AccessibilityHierarchyProtos.DeviceStateProto fromProto) {
        this.sdkVersion = fromProto.getSdkVersion();
        this.defaultDisplayInfo = new DisplayInfo(fromProto.getDefaultDisplayInfo());
        String languageTag = fromProto.getLocale();
        this.locale = languageTag.isEmpty() ? Locale.ENGLISH : DeviceState.getLocaleFromLanguageTag(languageTag);
    }

    protected DeviceState(int sdkVersion, Locale locale) {
        this.sdkVersion = sdkVersion;
        this.locale = locale;
        this.defaultDisplayInfo = new DisplayInfo();
    }

    public DisplayInfo getDefaultDisplayInfo() {
        return this.defaultDisplayInfo;
    }

    public int getSdkVersion() {
        return this.sdkVersion;
    }

    public Locale getLocale() {
        return this.locale;
    }

    AccessibilityHierarchyProtos.DeviceStateProto toProto() {
        AccessibilityHierarchyProtos.DeviceStateProto.Builder builder2 = AccessibilityHierarchyProtos.DeviceStateProto.newBuilder();
        builder2.setSdkVersion(this.sdkVersion);
        builder2.setDefaultDisplayInfo(this.getDefaultDisplayInfo().toProto());
        builder2.setLocale(this.getLanguageTag());
        return (AccessibilityHierarchyProtos.DeviceStateProto)builder2.build();
    }

    private String getLanguageTag() {
        return this.locale.toLanguageTag();
    }

    private static Locale getLocaleFromLanguageTag(String languageTag) {
        return Locale.forLanguageTag(languageTag);
    }
}

