/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestionProducer;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.SetViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

class SpeakableTextPresentFixSuggestionProducer
implements FixSuggestionProducer<SetViewAttributeFixSuggestion> {
    private static final String VIEW_ATTRIBUTE_CONTENT_DESCRIPTION = "contentDescription";
    private static final String VIEW_ATTRIBUTE_HINT = "hint";
    private static final String VIEW_ATTRIBUTE_TEXT = "text";

    SpeakableTextPresentFixSuggestionProducer() {
    }

    @Override
    public @Nullable SetViewAttributeFixSuggestion produceFixSuggestion(AccessibilityHierarchyCheckResult checkResult, AccessibilityHierarchy hierarchy, @Nullable Parameters parameters) {
        ViewHierarchyElement viewHierarchyElement = checkResult.getElement();
        if (viewHierarchyElement == null) {
            return null;
        }
        if (checkResult.getResultId() == 4) {
            boolean shouldSetHint = viewHierarchyElement.checkInstanceOf("android.widget.EditText") || viewHierarchyElement.checkInstanceOf("android.widget.TextView") && Boolean.TRUE.equals(viewHierarchyElement.isEditable());
            CharSequence className2 = viewHierarchyElement.getClassName();
            if (shouldSetHint) {
                return new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_HINT, "");
            }
            if (className2 != null && Objects.equals(className2.toString(), "android.widget.TextView")) {
                return new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_TEXT, "");
            }
            return new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_CONTENT_DESCRIPTION, "");
        }
        return null;
    }
}

