/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.ocr;

import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextComponent {
    private final String value;
    private final Rect boundsInScreen;
    private final @Nullable String language;
    private final @Nullable Float confidence;
    private final ImmutableList<TextComponent> components;

    private TextComponent(String value2, Rect boundsInScreen, @Nullable String language, @Nullable Float confidence, ImmutableList<TextComponent> components) {
        this.value = value2;
        this.boundsInScreen = boundsInScreen;
        this.language = language;
        this.confidence = confidence;
        this.components = components;
    }

    public String getValue() {
        return this.value;
    }

    public Rect getBoundsInScreen() {
        return this.boundsInScreen;
    }

    public @Nullable String getLanguage() {
        return this.language;
    }

    public @Nullable Float getConfidence() {
        return this.confidence;
    }

    public List<TextComponent> getComponents() {
        return this.components;
    }

    public static Builder newBuilder(String value2, Rect boundsInScreen) {
        return new Builder(value2, boundsInScreen);
    }

    public static class Builder {
        private final Rect boundsInScreen;
        private final String value;
        private @Nullable String language;
        private @Nullable Float confidence;
        private ImmutableList<TextComponent> components = ImmutableList.of();

        private Builder(String value2, Rect boundsInScreen) {
            this.value = value2;
            this.boundsInScreen = boundsInScreen;
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder setConfidence(float confidence) {
            this.confidence = Float.valueOf(confidence);
            return this;
        }

        public Builder setTextComponents(ImmutableList<TextComponent> textComponents) {
            this.components = textComponents;
            return this;
        }

        public TextComponent build() {
            return new TextComponent(this.value, this.boundsInScreen, this.language, this.confidence, this.components);
        }
    }
}

