/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.integrations.espresso;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPresetAndroid;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultDescriptor;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.integrations.espresso.AccessibilityViewCheckException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;

public class AccessibilityValidator {
    private static final String TAG = "AccessibilityValidator";
    private AccessibilityCheckPreset preset = AccessibilityCheckPreset.LATEST;
    private boolean runChecksFromRootView = false;
    private @Nullable AccessibilityCheckResult.AccessibilityCheckResultType throwExceptionFor = AccessibilityCheckResult.AccessibilityCheckResultType.ERROR;
    private @Nullable AccessibilityCheckResult.AccessibilityCheckResultDescriptor deprecatedResultDescriptor = null;
    private @Nullable AccessibilityCheckResultDescriptor resultDescriptor = new AccessibilityCheckResultDescriptor();
    private @Nullable Matcher<? super AccessibilityViewCheckResult> suppressingMatcher = null;
    private final List<AccessibilityCheckListener> checkListeners = new ArrayList<AccessibilityCheckListener>();

    public void check(View view) {
        Preconditions.checkNotNull((Object)view);
        this.checkAndReturnResults(view);
    }

    public List<AccessibilityViewCheckResult> checkAndReturnResults(View view) {
        if (view != null) {
            View viewToCheck = this.runChecksFromRootView ? view.getRootView() : view;
            return this.runAccessibilityChecks(viewToCheck);
        }
        return ImmutableList.of();
    }

    public AccessibilityValidator setCheckPreset(AccessibilityCheckPreset preset) {
        this.preset = preset;
        return this;
    }

    public AccessibilityValidator setRunChecksFromRootView(boolean runChecksFromRootView) {
        this.runChecksFromRootView = runChecksFromRootView;
        return this;
    }

    public AccessibilityValidator setSuppressingResultMatcher(@Nullable Matcher<? super AccessibilityViewCheckResult> resultMatcher) {
        this.suppressingMatcher = resultMatcher;
        return this;
    }

    @Deprecated
    public AccessibilityValidator setThrowExceptionForErrors(boolean throwExceptionForErrors) {
        return this.setThrowExceptionFor(throwExceptionForErrors ? AccessibilityCheckResult.AccessibilityCheckResultType.ERROR : null);
    }

    public AccessibilityValidator setThrowExceptionFor(@Nullable AccessibilityCheckResult.AccessibilityCheckResultType throwFor) {
        Preconditions.checkArgument((throwFor == AccessibilityCheckResult.AccessibilityCheckResultType.ERROR || throwFor == AccessibilityCheckResult.AccessibilityCheckResultType.WARNING || throwFor == AccessibilityCheckResult.AccessibilityCheckResultType.INFO || throwFor == null ? 1 : 0) != 0, (String)"Argument was %s but expected ERROR, WARNING, INFO or null.", (Object)((Object)throwFor));
        this.throwExceptionFor = throwFor;
        return this;
    }

    @Deprecated
    public AccessibilityValidator setResultDescriptor(AccessibilityCheckResult.AccessibilityCheckResultDescriptor deprecatedResultDescriptor) {
        this.deprecatedResultDescriptor = (AccessibilityCheckResult.AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)deprecatedResultDescriptor);
        this.resultDescriptor = null;
        return this;
    }

    public AccessibilityValidator setResultDescriptor(AccessibilityCheckResultDescriptor resultDescriptor) {
        this.deprecatedResultDescriptor = null;
        this.resultDescriptor = (AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)resultDescriptor);
        return this;
    }

    public AccessibilityValidator addCheckListener(AccessibilityCheckListener listener2) {
        Preconditions.checkNotNull((Object)listener2);
        this.checkListeners.add(listener2);
        return this;
    }

    private ImmutableList<AccessibilityViewCheckResult> runAccessibilityChecks(View view) {
        ArrayList<AccessibilityViewHierarchyCheck> viewHierarchyChecks = new ArrayList<AccessibilityViewHierarchyCheck>((Collection<AccessibilityViewHierarchyCheck>)AccessibilityCheckPresetAndroid.getViewChecksForPreset(this.preset));
        Parameters parameters = new Parameters();
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>();
        for (AccessibilityViewHierarchyCheck check : viewHierarchyChecks) {
            results.addAll(check.runCheckOnViewHierarchy(view, parameters));
        }
        return this.processResults(view.getContext(), results);
    }

    @VisibleForTesting
    ImmutableList<AccessibilityViewCheckResult> processResults(Context context, List<AccessibilityViewCheckResult> results) {
        ImmutableList<AccessibilityViewCheckResult> processedResults = AccessibilityValidator.suppressMatchingResults(results, this.suppressingMatcher);
        for (AccessibilityCheckListener checkListener : this.checkListeners) {
            checkListener.onResults(context, (List<? extends AccessibilityViewCheckResult>)processedResults);
        }
        List<AccessibilityViewCheckResult> infos = AccessibilityCheckResultUtils.getResultsForType(processedResults, AccessibilityCheckResult.AccessibilityCheckResultType.INFO);
        List<AccessibilityViewCheckResult> warnings = AccessibilityCheckResultUtils.getResultsForType(processedResults, AccessibilityCheckResult.AccessibilityCheckResultType.WARNING);
        List<AccessibilityViewCheckResult> errors = AccessibilityCheckResultUtils.getResultsForType(processedResults, AccessibilityCheckResult.AccessibilityCheckResultType.ERROR);
        List<AccessibilityViewCheckResult> severeResults = this.getSevereResults(errors, warnings, infos);
        if (!severeResults.isEmpty()) {
            if (this.deprecatedResultDescriptor != null) {
                throw new AccessibilityViewCheckException(severeResults, (AccessibilityCheckResult.AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)this.deprecatedResultDescriptor));
            }
            throw new AccessibilityViewCheckException(severeResults, (AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)this.resultDescriptor));
        }
        for (AccessibilityViewCheckResult result : infos) {
            Log.i(TAG, this.describeResult(result));
        }
        for (AccessibilityViewCheckResult result : warnings) {
            Log.w(TAG, this.describeResult(result));
        }
        for (AccessibilityViewCheckResult result : errors) {
            Log.e(TAG, this.describeResult(result));
        }
        return processedResults;
    }

    private String describeResult(AccessibilityViewCheckResult result) {
        if (this.deprecatedResultDescriptor != null) {
            return ((AccessibilityCheckResult.AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)this.deprecatedResultDescriptor)).describeResult(result);
        }
        return ((AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)this.resultDescriptor)).describeResult(result);
    }

    @VisibleForTesting
    static ImmutableList<AccessibilityViewCheckResult> suppressMatchingResults(List<AccessibilityViewCheckResult> results, @Nullable Matcher<? super AccessibilityViewCheckResult> matcher) {
        if (matcher == null) {
            return ImmutableList.copyOf(results);
        }
        return FluentIterable.from(results).transform(result -> matcher.matches(result) ? result.getSuppressedResultCopy() : result).toList();
    }

    private List<AccessibilityViewCheckResult> getSevereResults(List<AccessibilityViewCheckResult> errors, List<AccessibilityViewCheckResult> warnings, List<AccessibilityViewCheckResult> infos) {
        if (this.throwExceptionFor != null) {
            switch (this.throwExceptionFor) {
                case ERROR: {
                    if (errors.isEmpty()) break;
                    return errors;
                }
                case WARNING: {
                    if (errors.isEmpty() && warnings.isEmpty()) break;
                    return new ImmutableList.Builder().addAll(errors).addAll(warnings).build();
                }
                case INFO: {
                    if (errors.isEmpty() && warnings.isEmpty() && infos.isEmpty()) break;
                    return new ImmutableList.Builder().addAll(errors).addAll(warnings).addAll(infos).build();
                }
            }
        }
        return ImmutableList.of();
    }

    public static interface AccessibilityCheckListener {
        public void onResults(Context var1, List<? extends AccessibilityViewCheckResult> var2);
    }
}

