/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ViewHierarchyElementUtils;
import com.google.android.apps.common.testing.accessibility.framework.ocr.OcrResult;
import com.google.android.apps.common.testing.accessibility.framework.ocr.TextComponent;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UnexposedTextCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_IMPORTANT_FOR_ACCESSIBILITY = 2;
    public static final int RESULT_ID_OCR_RESULT_NOT_AVAILABLE = 3;
    public static final int RESULT_ID_SHOULD_NOT_FOCUS = 4;
    public static final int RESULT_ID_WEB_CONTENT = 5;
    public static final int RESULT_ID_TEXT_DETECTED_IN_IMAGE_VIEW = 6;
    public static final int RESULT_ID_NO_MATCHING_OCR_TEXT = 7;
    public static final int RESULT_ID_UNEXPOSED_TEXT = 8;
    public static final String KEY_UNEXPOSED_TEXT = "KEY_UNEXPOSED_TEXT";
    public static final String KEY_TEXT_DETECTED_IN_IMAGE_VIEW = "KEY_TEXT_DETECTED_IN_IMAGE_VIEW";
    private static final float CONFIDENCE_FILTER_THRESHOLD = 0.5f;

    @Override
    protected @Nullable String getHelpTopic() {
        return null;
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.CONTENT_LABELING;
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return "Unexposed Text";
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = UnexposedTextCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 8: {
                return "Ensure this item's accessibility label includes its visible text.";
            }
            case 6: {
                return "OCR results were detected inside this ImageView.";
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = UnexposedTextCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 8: {
                String string2 = String.valueOf(((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getString(KEY_UNEXPOSED_TEXT));
                return string2.length() != 0 ? "Unexposed text detected: ".concat(string2) : new String("Unexposed text detected: ");
            }
            case 6: {
                String string3 = String.valueOf(((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getString(KEY_TEXT_DETECTED_IN_IMAGE_VIEW));
                return string3.length() != 0 ? "Text detected: ".concat(string3) : new String("Text detected: ");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        Map<ViewHierarchyElement, List<TextComponent>> elementToTextListMap = UnexposedTextCheck.preprocessOcrResults(hierarchy, fromRoot, parameters);
        List<? extends ViewHierarchyElement> viewsToEval = UnexposedTextCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            results.addAll(this.generateCheckResults(viewHierarchyElement, elementToTextListMap, parameters));
        }
        return results;
    }

    private static Map<ViewHierarchyElement, List<TextComponent>> preprocessOcrResults(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        HashMap<ViewHierarchyElement, List<TextComponent>> elementToTextListMap = new HashMap<ViewHierarchyElement, List<TextComponent>>();
        if (parameters == null || parameters.getOcrResult() == null) {
            return elementToTextListMap;
        }
        List<Rect> systemWindowBounds = UnexposedTextCheck.getSystemWindowBounds(hierarchy);
        List<? extends ViewHierarchyElement> allViews = hierarchy.getActiveWindow().getAllViews();
        ImmutableList<TextComponent> texts = ((OcrResult)Preconditions.checkNotNull((Object)parameters.getOcrResult())).getTexts();
        for (TextComponent textComponent : texts) {
            if (UnexposedTextCheck.isTextInsideSystemWindows(textComponent, systemWindowBounds) || fromRoot != null && !Rect.intersects(textComponent.getBoundsInScreen(), fromRoot.getBoundsInScreen())) continue;
            Map<TextComponent, ViewHierarchyElement> map2 = UnexposedTextCheck.buildBestMatchMap(textComponent, allViews);
            for (Map.Entry<TextComponent, ViewHierarchyElement> entry : map2.entrySet()) {
                TextComponent text = entry.getKey();
                ViewHierarchyElement bestMatchElement = entry.getValue();
                if (!bestMatchElement.checkInstanceOf("android.widget.ImageView") && !bestMatchElement.isImportantForAccessibility() && (bestMatchElement = UnexposedTextCheck.findBestMatchView(text, allViews, false)) == null) continue;
                ArrayList<TextComponent> textComponentList = (ArrayList<TextComponent>)elementToTextListMap.get(bestMatchElement);
                if (textComponentList == null) {
                    textComponentList = new ArrayList<TextComponent>();
                    elementToTextListMap.put(bestMatchElement, textComponentList);
                }
                textComponentList.add(text);
            }
        }
        return elementToTextListMap;
    }

    private List<AccessibilityHierarchyCheckResult> generateCheckResults(ViewHierarchyElement view, Map<ViewHierarchyElement, List<TextComponent>> elementToTextListMap, @Nullable Parameters parameters) {
        boolean isTextListEmpty;
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        if (parameters == null || parameters.getOcrResult() == null) {
            results.add(this.createNotRunCheckResult(view, 3));
            return results;
        }
        if (!Boolean.TRUE.equals(view.isVisibleToUser())) {
            results.add(this.createNotRunCheckResult(view, 1));
            return results;
        }
        List<TextComponent> textList = elementToTextListMap.get(view);
        boolean bl = isTextListEmpty = textList == null || textList.isEmpty();
        if (!isTextListEmpty && view.checkInstanceOf("android.widget.ImageView")) {
            for (TextComponent text : (List)Preconditions.checkNotNull(textList)) {
                HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
                resultMetadata.putString(KEY_TEXT_DETECTED_IN_IMAGE_VIEW, text.getValue());
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 6, resultMetadata));
            }
            return results;
        }
        if (!view.isImportantForAccessibility()) {
            results.add(this.createNotRunCheckResult(view, 2));
            return results;
        }
        if (view.checkInstanceOf("android.webkit.WebView") && view.getChildViewCount() == 0) {
            results.add(this.createNotRunCheckResult(view, 5));
            return results;
        }
        if (!ViewHierarchyElementUtils.shouldFocusView(view)) {
            results.add(this.createNotRunCheckResult(view, 4));
            return results;
        }
        SpannableString speakableText = ViewHierarchyElementUtils.getSpeakableTextForElement(view);
        if (isTextListEmpty) {
            results.add(this.createNotRunCheckResult(view, 7));
            return results;
        }
        for (TextComponent text : (List)Preconditions.checkNotNull(textList)) {
            if (UnexposedTextCheck.isTextMatching(text.getValue(), speakableText.toString())) continue;
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_UNEXPOSED_TEXT, text.getValue());
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 8, resultMetadata));
        }
        return results;
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
            case 5: {
                return StringManager.getString(locale, "result_message_web_content");
            }
            case 4: {
                return StringManager.getString(locale, "result_message_should_not_focus");
            }
            case 3: {
                return "OCR result is not available.";
            }
            case 7: {
                return "No OCR results were detected for this item.";
            }
        }
        return null;
    }

    private AccessibilityHierarchyCheckResult createNotRunCheckResult(ViewHierarchyElement element, int resultId) {
        return new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, element, resultId, null);
    }

    private static List<Rect> getSystemWindowBounds(AccessibilityHierarchy hierarchy) {
        ArrayList<Rect> systemWindowBounds = new ArrayList<Rect>();
        Collection<? extends WindowHierarchyElement> windows = hierarchy.getAllWindows();
        for (WindowHierarchyElement windowHierarchyElement : windows) {
            Integer windowType = windowHierarchyElement.getType();
            if (windowType == null || windowType != 3 && windowType != 2) continue;
            systemWindowBounds.add(windowHierarchyElement.getBoundsInScreen());
        }
        return systemWindowBounds;
    }

    private static boolean isTextInsideSystemWindows(TextComponent textComponent, List<Rect> systemWindowBounds) {
        for (Rect windowBoundsInScreen : systemWindowBounds) {
            if (!windowBoundsInScreen.contains(textComponent.getBoundsInScreen())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTextMatching(String text, String targetText) {
        if (TextUtils.isEmpty(targetText)) {
            return false;
        }
        if (targetText.contains(text)) {
            return true;
        }
        String asciiOcrText = Ascii.toLowerCase((String)text.replaceAll("[^a-zA-Z0-9]", ""));
        String asciiSpeakableText = Ascii.toLowerCase((String)targetText.replaceAll("[^a-zA-Z0-9]", ""));
        if (asciiSpeakableText.contains(asciiOcrText)) {
            return true;
        }
        return Math.abs(asciiOcrText.length() - asciiSpeakableText.length()) <= 1 && UnexposedTextCheck.editDistance(asciiOcrText, asciiSpeakableText) <= 1;
    }

    private static List<TextComponent> flattenTextComponent(TextComponent textComponent) {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        if (textComponent.getComponents().isEmpty()) {
            if (textComponent.getConfidence() == null || ((Float)Preconditions.checkNotNull((Object)textComponent.getConfidence())).floatValue() > 0.5f) {
                components.add(textComponent);
            }
        } else {
            for (TextComponent subText : textComponent.getComponents()) {
                components.addAll(UnexposedTextCheck.flattenTextComponent(subText));
            }
        }
        return components;
    }

    private static Map<TextComponent, ViewHierarchyElement> buildBestMatchMap(TextComponent textComponent, List<? extends ViewHierarchyElement> allViews) {
        HashMap<TextComponent, ViewHierarchyElement> map2 = new HashMap<TextComponent, ViewHierarchyElement>();
        List<TextComponent> wordList = UnexposedTextCheck.flattenTextComponent(textComponent);
        HashMap<TextComponent, Integer> wordStartIndexMap = new HashMap<TextComponent, Integer>();
        int startIndex = 0;
        for (TextComponent subText : wordList) {
            startIndex = textComponent.getValue().indexOf(subText.getValue(), startIndex);
            wordStartIndexMap.put(subText, startIndex);
            startIndex += subText.getValue().length();
        }
        ArrayList<TextComponent> consecutiveWordList = new ArrayList<TextComponent>();
        ViewHierarchyElement lastBestMatch = null;
        TextComponent lastSubText = null;
        for (TextComponent word : wordList) {
            ViewHierarchyElement bestSubTextMatchView = UnexposedTextCheck.findBestMatchView(word, allViews, false);
            if (bestSubTextMatchView == null) continue;
            boolean sameLine = true;
            if (lastSubText != null && (lastSubText.getBoundsInScreen().getTop() >= word.getBoundsInScreen().getBottom() || word.getBoundsInScreen().getTop() >= lastSubText.getBoundsInScreen().getBottom())) {
                sameLine = false;
            }
            if (sameLine && (bestSubTextMatchView == lastBestMatch || lastBestMatch == null)) {
                consecutiveWordList.add(word);
                lastBestMatch = bestSubTextMatchView;
                continue;
            }
            String substring = UnexposedTextCheck.getSubString(textComponent.getValue(), consecutiveWordList, wordStartIndexMap);
            map2.put(TextComponent.newBuilder(substring, UnexposedTextCheck.getSubStringBoundsInScreen(consecutiveWordList)).build(), (ViewHierarchyElement)Preconditions.checkNotNull((Object)lastBestMatch));
            consecutiveWordList = new ArrayList();
            consecutiveWordList.add(word);
            lastBestMatch = bestSubTextMatchView;
        }
        if (lastBestMatch != null && !consecutiveWordList.isEmpty()) {
            String substring = UnexposedTextCheck.getSubString(textComponent.getValue(), consecutiveWordList, wordStartIndexMap);
            map2.put(TextComponent.newBuilder(substring, UnexposedTextCheck.getSubStringBoundsInScreen(consecutiveWordList)).build(), lastBestMatch);
        }
        return map2;
    }

    private static String getSubString(String paragraph, List<TextComponent> consecutiveWordList, Map<TextComponent, Integer> wordStartIndexMap) {
        TextComponent lastTextComponent = (TextComponent)Iterables.getLast(consecutiveWordList);
        return paragraph.substring((Integer)Preconditions.checkNotNull((Object)wordStartIndexMap.get(consecutiveWordList.get(0))), (Integer)Preconditions.checkNotNull((Object)wordStartIndexMap.get(lastTextComponent)) + lastTextComponent.getValue().length());
    }

    private static Rect getSubStringBoundsInScreen(List<TextComponent> wordList) {
        if (wordList.isEmpty()) {
            return Rect.EMPTY;
        }
        Rect subRect = wordList.get(0).getBoundsInScreen();
        for (int i = 1; i < wordList.size(); ++i) {
            subRect = subRect.union(wordList.get(i).getBoundsInScreen());
        }
        return subRect;
    }

    private static @Nullable ViewHierarchyElement findBestMatchView(TextComponent textComponent, List<? extends ViewHierarchyElement> allViews, boolean includeNotImportantViews) {
        ViewHierarchyElement bestMatch = null;
        float highestIOU = 0.0f;
        for (ViewHierarchyElement viewHierarchyElement : allViews) {
            float iou;
            if (!includeNotImportantViews && !viewHierarchyElement.isImportantForAccessibility() || !((iou = UnexposedTextCheck.calculateIntersectionOverUnion(viewHierarchyElement.getBoundsInScreen(), textComponent.getBoundsInScreen())) > 0.0f) || !(iou >= highestIOU)) continue;
            bestMatch = viewHierarchyElement;
            highestIOU = iou;
        }
        return bestMatch;
    }

    private static float calculateIntersectionOverUnion(Rect r1, Rect r2) {
        if (!Rect.intersects(r1, r2)) {
            return 0.0f;
        }
        Rect union = r1.union(r2);
        Rect intersect = r1.intersect(r2);
        return (float)intersect.area() / (float)union.area();
    }

    private static int editDistance(String s1, String s2) {
        if (s1.length() < s2.length()) {
            String temp = s2;
            s2 = s1;
            s1 = temp;
        }
        int[] costs = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }
}

