/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DuplicateClickableBoundsCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_SAME_BOUNDS = 1;
    public static final int RESULT_ID_VIEW_BOUNDS = 2;
    public static final String KEY_CONFLICTS_BECAUSE_CLICKABLE = "KEY_CONFLICTS_BECAUSE_CLICKABLE";
    public static final String KEY_CONFLICTS_BECAUSE_LONG_CLICKABLE = "KEY_CONFLICTS_BECAUSE_LONG_CLICKABLE";
    public static final String KEY_CONFLICTING_VIEW_COUNT = "KEY_CONFLICTING_VIEW_COUNT";
    public static final String KEY_CONFLICTING_LOCATION_LEFT = "KEY_CONFLICTING_LOCATION_LEFT";
    public static final String KEY_CONFLICTING_LOCATION_TOP = "KEY_CONFLICTING_LOCATION_TOP";
    public static final String KEY_CONFLICTING_LOCATION_RIGHT = "KEY_CONFLICTING_LOCATION_RIGHT";
    public static final String KEY_CONFLICTING_LOCATION_BOTTOM = "KEY_CONFLICTING_LOCATION_BOTTOM";
    public static final byte ELEMENT_MASK_CLICKABLE = 1;
    public static final byte ELEMENT_MASK_LONG_CLICKABLE = 2;

    @Override
    protected String getHelpTopic() {
        return "6378943";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.IMPLEMENTATION;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        Map<ViewLocationActionHolder, List<ViewHierarchyElement>> locationActionToViewMap = this.getLocationActionToViewMap(hierarchy.getActiveWindow().getAllViews());
        List<? extends ViewHierarchyElement> viewsToEval = fromRoot != null ? fromRoot.getSelfAndAllDescendants() : null;
        block0: for (List<ViewHierarchyElement> elements : locationActionToViewMap.values()) {
            if (elements.size() < 2) continue;
            for (ViewHierarchyElement culprit : elements) {
                if (viewsToEval != null && !viewsToEval.contains(culprit)) continue;
                HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
                resultMetadata.putBoolean(KEY_CONFLICTS_BECAUSE_CLICKABLE, culprit.isClickable());
                resultMetadata.putBoolean(KEY_CONFLICTS_BECAUSE_LONG_CLICKABLE, culprit.isLongClickable());
                resultMetadata.putInt(KEY_CONFLICTING_VIEW_COUNT, elements.size() - 1);
                DuplicateClickableBoundsCheck.setBoundsInMetadata(culprit.getBoundsInScreen(), resultMetadata);
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, culprit, 1, resultMetadata));
                continue block0;
            }
        }
        return results;
    }

    @Override
    public String getMessageForResult(Locale locale, AccessibilityHierarchyCheckResult result) {
        ResultMetadata metadata;
        Rect bounds2;
        int resultId = result.getResultId();
        if ((resultId == 1 || resultId == 2) && (bounds2 = DuplicateClickableBoundsCheck.getBoundsFromMetadata(metadata = result.getMetadata())) == null && result.getElement() != null) {
            ViewHierarchyElement culprit = result.getElement();
            ResultMetadata updatedMetadata = metadata != null ? metadata.clone() : new HashMapResultMetadata();
            DuplicateClickableBoundsCheck.setBoundsInMetadata(culprit.getBoundsInScreen(), updatedMetadata);
            AccessibilityHierarchyCheckResult updatedResult = new AccessibilityHierarchyCheckResult(this.getClass(), result.getType(), culprit, resultId, updatedMetadata);
            return super.getMessageForResult(locale, updatedResult);
        }
        return super.getMessageForResult(locale, result);
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata);
        Rect bounds2 = (Rect)Preconditions.checkNotNull((Object)DuplicateClickableBoundsCheck.getBoundsFromMetadata(metadata));
        String actionString = DuplicateClickableBoundsCheck.getActionString(locale, metadata.getBoolean(KEY_CONFLICTS_BECAUSE_CLICKABLE, false), metadata.getBoolean(KEY_CONFLICTS_BECAUSE_LONG_CLICKABLE, false));
        switch (resultId) {
            case 1: {
                return String.format(locale, StringManager.getString(locale, "result_message_same_view_bounds"), actionString, bounds2.toShortString(), metadata.getInt(KEY_CONFLICTING_VIEW_COUNT));
            }
            case 2: {
                return String.format(locale, StringManager.getString(locale, "result_message_view_bounds"), actionString, bounds2.toShortString());
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata);
        String actionString = DuplicateClickableBoundsCheck.getShortActionString(locale, metadata.getBoolean(KEY_CONFLICTS_BECAUSE_CLICKABLE), metadata.getBoolean(KEY_CONFLICTS_BECAUSE_LONG_CLICKABLE));
        switch (resultId) {
            case 1: 
            case 2: {
                return String.format(locale, StringManager.getString(locale, "result_message_brief_same_view_bounds"), actionString);
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_duplicate_clickable_bounds");
    }

    private Map<ViewLocationActionHolder, List<ViewHierarchyElement>> getLocationActionToViewMap(Collection<? extends ViewHierarchyElement> allViews) {
        HashMap<ViewLocationActionHolder, List<ViewHierarchyElement>> locationActionToViewMap = new HashMap<ViewLocationActionHolder, List<ViewHierarchyElement>>();
        for (ViewHierarchyElement viewHierarchyElement : allViews) {
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) continue;
            boolean clickable = viewHierarchyElement.isClickable();
            boolean longClickable = viewHierarchyElement.isLongClickable();
            Rect bounds2 = viewHierarchyElement.getBoundsInScreen();
            if (!viewHierarchyElement.isImportantForAccessibility() || !clickable && !longClickable) continue;
            ViewLocationActionHolder viewLocationActionHolder = new ViewLocationActionHolder(bounds2, clickable, longClickable);
            if (!locationActionToViewMap.containsKey(viewLocationActionHolder)) {
                locationActionToViewMap.put(viewLocationActionHolder, new ArrayList());
            }
            ((List)locationActionToViewMap.get(viewLocationActionHolder)).add(viewHierarchyElement);
        }
        return locationActionToViewMap;
    }

    private static String getActionString(Locale locale, boolean clickable, boolean longClickable) {
        if (clickable && longClickable) {
            return StringManager.getString(locale, "clickable_and_long_clickable");
        }
        if (clickable) {
            return StringManager.getString(locale, "clickable");
        }
        if (longClickable) {
            return StringManager.getString(locale, "long_clickable");
        }
        return "";
    }

    private static String getShortActionString(Locale locale, boolean clickable, boolean longClickable) {
        if (clickable && longClickable) {
            return StringManager.getString(locale, "actionable");
        }
        return DuplicateClickableBoundsCheck.getActionString(locale, clickable, longClickable);
    }

    private static void setBoundsInMetadata(Rect rect, ResultMetadata metadata) {
        metadata.putInt(KEY_CONFLICTING_LOCATION_LEFT, rect.getLeft());
        metadata.putInt(KEY_CONFLICTING_LOCATION_TOP, rect.getTop());
        metadata.putInt(KEY_CONFLICTING_LOCATION_RIGHT, rect.getRight());
        metadata.putInt(KEY_CONFLICTING_LOCATION_BOTTOM, rect.getBottom());
    }

    private static @Nullable Rect getBoundsFromMetadata(@Nullable ResultMetadata metadata) {
        if (metadata != null && metadata.containsKey(KEY_CONFLICTING_LOCATION_LEFT) && metadata.containsKey(KEY_CONFLICTING_LOCATION_TOP) && metadata.containsKey(KEY_CONFLICTING_LOCATION_RIGHT) && metadata.containsKey(KEY_CONFLICTING_LOCATION_BOTTOM)) {
            return new Rect(metadata.getInt(KEY_CONFLICTING_LOCATION_LEFT), metadata.getInt(KEY_CONFLICTING_LOCATION_TOP), metadata.getInt(KEY_CONFLICTING_LOCATION_RIGHT), metadata.getInt(KEY_CONFLICTING_LOCATION_BOTTOM));
        }
        return null;
    }

    private static class ViewLocationActionHolder {
        private final Rect location;
        private final boolean clickable;
        private final boolean longClickable;

        public ViewLocationActionHolder(Rect location, boolean clickable, boolean longClickable) {
            this.location = location;
            this.clickable = clickable;
            this.longClickable = longClickable;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ViewLocationActionHolder)) {
                return false;
            }
            ViewLocationActionHolder other = (ViewLocationActionHolder)obj;
            if (!this.location.equals(other.location)) {
                return false;
            }
            return this.clickable && other.clickable || this.longClickable && other.longClickable;
        }
    }
}

