/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassNameCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_IMPORTANT_FOR_ACCESSIBILITY = 2;
    public static final int RESULT_ID_CLASS_NAME_UNKNOWN = 3;
    public static final int RESULT_ID_CLASS_NAME_IS_EMPTY = 4;
    public static final int RESULT_ID_CLASS_NAME_NOT_SUPPORTED = 5;
    public static final String KEY_ACCESSIBILITY_CLASS_NAME = "KEY_ACCESSIBILITY_CLASS_NAME";
    private static final ImmutableSet<String> VALID_UI_PACKAGE_NAME_PREFIXES = ImmutableSet.of((Object)"android.app", (Object)"android.appwidget", (Object)"android.inputmethodservice", (Object)"android.support", (Object)"android.view", (Object)"android.webkit", (Object[])new String[]{"android.widget", "androidx"});

    @Override
    protected @Nullable String getHelpTopic() {
        return "7661305";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.IMPLEMENTATION;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = ClassNameCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!viewHierarchyElement.isImportantForAccessibility()) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            CharSequence className2 = viewHierarchyElement.getAccessibilityClassName();
            if (className2 == null) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
                continue;
            }
            if (TextUtils.isEmpty(className2)) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, viewHierarchyElement, 4, null));
                continue;
            }
            boolean isValidUiClass = false;
            for (String packageName : VALID_UI_PACKAGE_NAME_PREFIXES) {
                if (!className2.toString().startsWith(packageName)) continue;
                isValidUiClass = true;
                break;
            }
            if (isValidUiClass) continue;
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_ACCESSIBILITY_CLASS_NAME, className2.toString());
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, viewHierarchyElement, 5, resultMetadata));
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_class_name_is_unknown");
            }
            case 4: {
                return StringManager.getString(locale, "result_message_class_name_is_empty");
            }
            case 5: {
                Preconditions.checkNotNull((Object)metadata);
                return String.format(StringManager.getString(locale, "result_message_class_name_not_supported_detail"), Preconditions.checkNotNull((Object)metadata.getString(KEY_ACCESSIBILITY_CLASS_NAME)));
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_class_name_is_unknown");
            }
            case 4: 
            case 5: {
                return StringManager.getString(locale, "result_message_class_name_not_supported_brief");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_class_name_not_supported");
    }
}

