/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableStringBuilder;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewHierarchyElementUtils {
    public static final String ABS_LIST_VIEW_CLASS_NAME = "android.widget.AbsListView";
    public static final String ADAPTER_VIEW_CLASS_NAME = "android.widget.AdapterView";
    public static final String SCROLL_VIEW_CLASS_NAME = "android.widget.ScrollView";
    public static final String HORIZONTAL_SCROLL_VIEW_CLASS_NAME = "android.widget.HorizontalScrollView";
    public static final String SPINNER_CLASS_NAME = "android.widget.Spinner";
    public static final String TEXT_VIEW_CLASS_NAME = "android.widget.TextView";
    public static final String EDIT_TEXT_CLASS_NAME = "android.widget.EditText";
    public static final String IMAGE_VIEW_CLASS_NAME = "android.widget.ImageView";
    public static final String WEB_VIEW_CLASS_NAME = "android.webkit.WebView";
    public static final String SWITCH_CLASS_NAME = "android.widget.Switch";
    static final ImmutableList<String> SCROLLABLE_CONTAINER_CLASS_NAME_LIST = ImmutableList.of((Object)"android.widget.AdapterView", (Object)"android.widget.ScrollView", (Object)"android.widget.HorizontalScrollView");

    private ViewHierarchyElementUtils() {
    }

    public static SpannableString getSpeakableTextForElement(ViewHierarchyElement element) {
        if (element.isImportantForAccessibility() && element.getLabeledBy() != null) {
            return ViewHierarchyElementUtils.getSpeakableTextFromElementSubtree(element.getLabeledBy());
        }
        return ViewHierarchyElementUtils.getSpeakableTextFromElementSubtree(element);
    }

    private static SpannableString getSpeakableTextFromElementSubtree(ViewHierarchyElement element) {
        SpannableStringBuilder returnStringBuilder = new SpannableStringBuilder();
        if (element.isImportantForAccessibility()) {
            SpannableString contentDescription = element.getContentDescription();
            if (!TextUtils.isEmpty(contentDescription)) {
                return returnStringBuilder.appendWithSeparator(contentDescription).build();
            }
            SpannableString text = element.getText();
            if (!TextUtils.isEmpty(text) && TextUtils.getTrimmedLength(text) > 0) {
                returnStringBuilder.appendWithSeparator(text);
            } else {
                SpannableString hint = element.getHintText();
                if (!TextUtils.isEmpty(hint) && TextUtils.getTrimmedLength(hint) > 0) {
                    returnStringBuilder.appendWithSeparator(hint);
                }
            }
            if (Boolean.TRUE.equals(element.isCheckable())) {
                if (Boolean.TRUE.equals(element.isChecked())) {
                    returnStringBuilder.appendWithSeparator("Checked");
                } else if (Boolean.FALSE.equals(element.isChecked())) {
                    returnStringBuilder.appendWithSeparator("Not checked");
                }
            }
            if (element.checkInstanceOf(ABS_LIST_VIEW_CLASS_NAME) && element.getChildViewCount() == 0) {
                returnStringBuilder.appendWithSeparator("List showing 0 items");
            }
        }
        for (int i = 0; i < element.getChildViewCount(); ++i) {
            SpannableString childDesc;
            ViewHierarchyElement child = element.getChildView(i);
            if (Boolean.FALSE.equals(child.isVisibleToUser()) || ViewHierarchyElementUtils.isActionableForAccessibility(child) || TextUtils.isEmpty(childDesc = ViewHierarchyElementUtils.getSpeakableTextFromElementSubtree(child))) continue;
            returnStringBuilder.appendWithSeparator(childDesc);
        }
        return returnStringBuilder.build();
    }

    public static boolean shouldFocusView(ViewHierarchyElement view) {
        if (!Boolean.TRUE.equals(view.isVisibleToUser())) {
            return false;
        }
        if (ViewHierarchyElementUtils.isAccessibilityFocusable(view)) {
            if (!ViewHierarchyElementUtils.hasAnyImportantDescendant(view)) {
                return true;
            }
            return ViewHierarchyElementUtils.isSpeakingView(view);
        }
        return ViewHierarchyElementUtils.hasText(view) && view.isImportantForAccessibility() && !ViewHierarchyElementUtils.hasFocusableAncestor(view);
    }

    private static boolean isActionableForAccessibility(ViewHierarchyElement element) {
        return element.isClickable() || element.isFocusable() || element.isLongClickable();
    }

    private static boolean hasFocusableAncestor(ViewHierarchyElement view) {
        ViewHierarchyElement parent = ViewHierarchyElementUtils.getImportantForAccessibilityAncestor(view);
        if (parent == null) {
            return false;
        }
        if (ViewHierarchyElementUtils.isAccessibilityFocusable(parent)) {
            return true;
        }
        return ViewHierarchyElementUtils.hasFocusableAncestor(parent);
    }

    private static boolean isAccessibilityFocusable(ViewHierarchyElement view) {
        if (!Boolean.TRUE.equals(view.isVisibleToUser())) {
            return false;
        }
        if (!view.isImportantForAccessibility()) {
            return false;
        }
        if (ViewHierarchyElementUtils.isActionableForAccessibility(view)) {
            return true;
        }
        return ViewHierarchyElementUtils.isChildOfScrollableContainer(view) && ViewHierarchyElementUtils.isSpeakingView(view);
    }

    private static boolean isChildOfScrollableContainer(ViewHierarchyElement view) {
        ViewHierarchyElement parent = ViewHierarchyElementUtils.getImportantForAccessibilityAncestor(view);
        if (parent == null) {
            return false;
        }
        if (Boolean.TRUE.equals(parent.isScrollable())) {
            return true;
        }
        if (parent.checkInstanceOf(SPINNER_CLASS_NAME)) {
            return false;
        }
        return parent.checkInstanceOfAny((List<String>)SCROLLABLE_CONTAINER_CLASS_NAME_LIST);
    }

    private static boolean isSpeakingView(ViewHierarchyElement view) {
        if (ViewHierarchyElementUtils.hasText(view)) {
            return true;
        }
        if (Boolean.TRUE.equals(view.isCheckable())) {
            return true;
        }
        return ViewHierarchyElementUtils.hasNonFocusableSpeakingChildren(view);
    }

    private static boolean hasNonFocusableSpeakingChildren(ViewHierarchyElement view) {
        for (int i = 0; i < view.getChildViewCount(); ++i) {
            ViewHierarchyElement child = view.getChildView(i);
            if (child == null || !Boolean.TRUE.equals(child.isVisibleToUser()) || ViewHierarchyElementUtils.isAccessibilityFocusable(child) || !child.isImportantForAccessibility() || !ViewHierarchyElementUtils.isSpeakingView(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasText(ViewHierarchyElement view) {
        return !TextUtils.isEmpty(view.getText()) || !TextUtils.isEmpty(view.getContentDescription()) || !TextUtils.isEmpty(view.getHintText());
    }

    private static @Nullable ViewHierarchyElement getImportantForAccessibilityAncestor(ViewHierarchyElement view) {
        ViewHierarchyElement parent;
        for (parent = view.getParentView(); parent != null && !view.isImportantForAccessibility(); parent = parent.getParentView()) {
        }
        return parent;
    }

    private static boolean hasAnyImportantDescendant(ViewHierarchyElement element) {
        for (int i = 0; i < element.getChildViewCount(); ++i) {
            ViewHierarchyElement child = element.getChildView(i);
            if (child.isImportantForAccessibility()) {
                return true;
            }
            if (child.getChildViewCount() <= 0 || !ViewHierarchyElementUtils.hasAnyImportantDescendant(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntersectedByOverlayWindow(ViewHierarchyElement viewHierarchyElement) {
        AccessibilityHierarchy hierarchy = viewHierarchyElement.getWindow().getAccessibilityHierarchy();
        Integer activeWindowLayer = hierarchy.getActiveWindow().getLayer();
        if (activeWindowLayer == null) {
            return false;
        }
        for (WindowHierarchyElement windowHierarchyElement : hierarchy.getAllWindows()) {
            if (windowHierarchyElement.getLayer() == null || (Integer)Preconditions.checkNotNull((Object)windowHierarchyElement.getLayer()) <= activeWindowLayer || !Rect.intersects(viewHierarchyElement.getBoundsInScreen(), windowHierarchyElement.getBoundsInScreen())) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntersectedByOverlayView(ViewHierarchyElement element) {
        if (element.getDrawingOrder() == null) {
            return false;
        }
        AccessibilityHierarchy hierarchy = element.getWindow().getAccessibilityHierarchy();
        ViewHierarchyElement rootView = hierarchy.getActiveWindow().getRootView();
        ViewHierarchyElement view = element;
        while (view != rootView) {
            ViewHierarchyElement parentView = (ViewHierarchyElement)Preconditions.checkNotNull((Object)view.getParentView());
            for (int i = 0; i < parentView.getChildViewCount(); ++i) {
                ViewHierarchyElement siblingView = parentView.getChildView(i);
                if ((Integer)Preconditions.checkNotNull((Object)siblingView.getDrawingOrder()) <= (Integer)Preconditions.checkNotNull((Object)view.getDrawingOrder()) || !Rect.intersects(element.getBoundsInScreen(), siblingView.getBoundsInScreen())) continue;
                return true;
            }
            view = parentView;
        }
        return false;
    }

    public static boolean isPotentiallyObscured(ViewHierarchyElement viewHierarchyElement) {
        return ViewHierarchyElementUtils.isIntersectedByOverlayWindow(viewHierarchyElement) || ViewHierarchyElementUtils.isIntersectedByOverlayView(viewHierarchyElement);
    }
}

