/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class ValidatorData {

    public static class CompoundFix
    implements Fix {
        public final List<Fix> mFixes;
        private final String mDescription;

        public CompoundFix(List<Fix> fixes2, String description) {
            this.mFixes = fixes2;
            this.mDescription = description;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }
    }

    public static class RemoveViewAttributeFix
    implements Fix {
        public final ViewAttribute mViewAttribute;
        private final String mDescription;

        public RemoveViewAttributeFix(ViewAttribute viewAttribute, String description) {
            this.mViewAttribute = viewAttribute;
            this.mDescription = description;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }
    }

    public static class SetViewAttributeFix
    implements Fix {
        public final ViewAttribute mViewAttribute;
        public final String mSuggestedValue;
        private final String mDescription;

        public SetViewAttributeFix(ViewAttribute viewAttribute, String suggestedValue, String description) {
            this.mViewAttribute = viewAttribute;
            this.mSuggestedValue = suggestedValue;
            this.mDescription = description;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }
    }

    public static interface Fix {
        public String getDescription();
    }

    public static class ViewAttribute {
        public final String mNamespaceUri;
        public final String mNamespace;
        public final String mAttributeName;

        public ViewAttribute(String namespaceUri, String namespace, String attributeName) {
            this.mNamespaceUri = namespaceUri;
            this.mNamespace = namespace;
            this.mAttributeName = attributeName;
        }
    }

    public static class Issue {
        public final String mCategory;
        public final Type mType;
        public final String mMsg;
        public final Level mLevel;
        public final Long mSrcId;
        public final Fix mFix;
        public final String mSourceClass;
        public final String mHelpfulUrl;

        private Issue(String category, Type type, String msg, Level level, Long srcId, Fix fix, String sourceClass, String helpfulUrl) {
            this.mCategory = category;
            this.mType = type;
            this.mMsg = msg;
            this.mLevel = level;
            this.mSrcId = srcId;
            this.mFix = fix;
            this.mSourceClass = sourceClass;
            this.mHelpfulUrl = helpfulUrl;
        }

        public static class IssueBuilder {
            private String mCategory;
            private Type mType = Type.ACCESSIBILITY;
            private String mMsg;
            private Level mLevel;
            private Long mSrcId;
            private Fix mFix;
            private String mSourceClass;
            private String mHelpfulUrl;

            public IssueBuilder setCategory(String category) {
                this.mCategory = category;
                return this;
            }

            public IssueBuilder setType(Type type) {
                this.mType = type;
                return this;
            }

            public IssueBuilder setMsg(String msg) {
                this.mMsg = msg;
                return this;
            }

            public IssueBuilder setLevel(Level level) {
                this.mLevel = level;
                return this;
            }

            public IssueBuilder setSrcId(Long srcId) {
                this.mSrcId = srcId;
                return this;
            }

            public IssueBuilder setFix(Fix fix) {
                this.mFix = fix;
                return this;
            }

            public IssueBuilder setSourceClass(String sourceClass) {
                this.mSourceClass = sourceClass;
                return this;
            }

            public IssueBuilder setHelpfulUrl(String url) {
                this.mHelpfulUrl = url;
                return this;
            }

            public Issue build() {
                assert (this.mCategory != null);
                assert (this.mType != null);
                assert (this.mMsg != null);
                assert (this.mLevel != null);
                assert (this.mSourceClass != null);
                return new Issue(this.mCategory, this.mType, this.mMsg, this.mLevel, this.mSrcId, this.mFix, this.mSourceClass, this.mHelpfulUrl);
            }
        }
    }

    public static class Policy {
        public final EnumSet<Type> mTypes;
        public final EnumSet<Level> mLevels;
        public final HashSet<AccessibilityHierarchyCheck> mChecks = new HashSet();

        public Policy(EnumSet<Type> types, EnumSet<Level> levels) {
            this.mTypes = types;
            this.mLevels = levels;
        }
    }

    public static enum Level {
        ERROR,
        WARNING,
        INFO,
        VERBOSE;

    }

    public static enum Type {
        ACCESSIBILITY,
        RENDER,
        INTERNAL_ERROR;

    }
}

