/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint;

import android.graphics.Rect;
import android.text.Layout;
import android.text.TextPaint;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderContext;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalysisKt;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyticsManager;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintBaseConfigIssues;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a:\u0010\u000f\u001a\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a:\u0010\u0014\u001a\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a0\u0010\u0015\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000eH\u0002\u00a8\u0006#"}, d2={"analyzeLocaleText", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "baseConfigIssues", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintBaseConfigIssues;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "output", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintIssueProvider;", "analyticsManager", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyticsManager;", "buildMap", "root", "Lcom/android/ide/common/rendering/api/ViewInfo;", "createEllipsizedIssue", "value", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintBaseConfigIssues$BaseConfigComponentState;", "locale", "", "createTextTooBigIssue", "findLocaleTextIssue", "getKey", "", "(Lcom/android/ide/common/rendering/api/ViewInfo;)Ljava/lang/Integer;", "htmlBuilder", "Lcom/android/utils/HtmlBuilder;", "msg", "isBaseConfig", "", "config", "Lcom/android/tools/idea/configurations/Configuration;", "isEllipsized", "view", "isTextTooBig", "intellij.android.designer"})
public final class VisualLintLocaleAnalysisKt {
    public static final void analyzeLocaleText(@NotNull RenderResult renderResult, @NotNull VisualLintBaseConfigIssues baseConfigIssues, @NotNull NlModel model2, @NotNull VisualLintIssueProvider output, @NotNull VisualLintAnalyticsManager analyticsManager) {
        Configuration config;
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)baseConfigIssues, (String)"baseConfigIssues");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)analyticsManager, (String)"analyticsManager");
        RenderContext renderContext = renderResult.getRenderContext();
        Object object = config = renderContext != null ? renderContext.getConfiguration() : null;
        if (VisualLintLocaleAnalysisKt.isBaseConfig(config)) {
            UnmodifiableIterator unmodifiableIterator = renderResult.getRootViews().iterator();
            while (unmodifiableIterator.hasNext()) {
                ViewInfo root;
                ViewInfo viewInfo = root = (ViewInfo)unmodifiableIterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)viewInfo, (String)"root");
                VisualLintLocaleAnalysisKt.buildMap(viewInfo, baseConfigIssues);
            }
        } else {
            UnmodifiableIterator unmodifiableIterator = renderResult.getRootViews().iterator();
            while (unmodifiableIterator.hasNext()) {
                ViewInfo root;
                ViewInfo viewInfo = root = (ViewInfo)unmodifiableIterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)viewInfo, (String)"root");
                VisualLintLocaleAnalysisKt.findLocaleTextIssue(viewInfo, baseConfigIssues, model2, output, analyticsManager);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildMap(ViewInfo root, VisualLintBaseConfigIssues baseConfigIssues) {
        block3: {
            Object object;
            void $this$getOrPut$iv;
            Object element$iv2;
            List list = root.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"root.children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ViewInfo it = (ViewInfo)element$iv2;
                boolean bl = false;
                ViewInfo viewInfo = it;
                Intrinsics.checkNotNullExpressionValue((Object)viewInfo, (String)"it");
                VisualLintLocaleAnalysisKt.buildMap(viewInfo, baseConfigIssues);
            }
            Integer n = VisualLintLocaleAnalysisKt.getKey(root);
            if (n == null) break block3;
            Integer n2 = n;
            int key = ((Number)n2).intValue();
            boolean bl = false;
            element$iv2 = baseConfigIssues.getComponentState();
            Integer key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                VisualLintBaseConfigIssues.BaseConfigComponentState answer$iv = new VisualLintBaseConfigIssues.BaseConfigComponentState(false, false, 3, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((VisualLintBaseConfigIssues.BaseConfigComponentState)object).setHasI18NEllipsis(VisualLintLocaleAnalysisKt.isEllipsized(root));
            VisualLintBaseConfigIssues.BaseConfigComponentState baseConfigComponentState = baseConfigIssues.getComponentState().get(key);
            Intrinsics.checkNotNull((Object)baseConfigComponentState);
            baseConfigComponentState.setHasI18NTextTooBig(VisualLintLocaleAnalysisKt.isTextTooBig(root));
        }
    }

    private static final Integer getKey(ViewInfo root) {
        TagSnapshot tagSnapshot;
        Object object = root.getCookie();
        if (!(object instanceof TagSnapshot)) {
            object = null;
        }
        return (tagSnapshot = (TagSnapshot)object) != null && (tagSnapshot = tagSnapshot.tag) != null ? Integer.valueOf(tagSnapshot.hashCode()) : null;
    }

    private static final boolean isBaseConfig(Configuration config) {
        Configuration configuration = config;
        return Intrinsics.areEqual((Object)(configuration != null && (configuration = configuration.getLocale()) != null ? configuration.toString() : null), (Object)"__");
    }

    private static final void findLocaleTextIssue(ViewInfo root, VisualLintBaseConfigIssues baseConfigIssues, NlModel model2, VisualLintIssueProvider output, VisualLintAnalyticsManager analyticsManager) {
        List list = root.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"root.children");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewInfo it = (ViewInfo)element$iv;
            boolean bl = false;
            ViewInfo viewInfo = it;
            Intrinsics.checkNotNullExpressionValue((Object)viewInfo, (String)"it");
            VisualLintLocaleAnalysisKt.findLocaleTextIssue(viewInfo, baseConfigIssues, model2, output, analyticsManager);
        }
        Integer n = VisualLintLocaleAnalysisKt.getKey(root);
        if (n == null) {
            return;
        }
        int key = n;
        VisualLintBaseConfigIssues.BaseConfigComponentState value2 = baseConfigIssues.getComponentState().get(key);
        Configuration configuration = model2.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"model.configuration");
        String string2 = configuration.getLocale().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"model.configuration.locale.toString()");
        String locale = string2;
        if (VisualLintLocaleAnalysisKt.isEllipsized(root)) {
            VisualLintLocaleAnalysisKt.createEllipsizedIssue(value2, root, model2, locale, output, analyticsManager);
        } else if (VisualLintLocaleAnalysisKt.isTextTooBig(root)) {
            VisualLintLocaleAnalysisKt.createTextTooBigIssue(value2, root, model2, locale, output, analyticsManager);
        }
    }

    private static final void createEllipsizedIssue(VisualLintBaseConfigIssues.BaseConfigComponentState value2, ViewInfo root, NlModel model2, String locale, VisualLintIssueProvider output, VisualLintAnalyticsManager analyticsManager) {
        if (value2 != null && !value2.getHasI18NEllipsis()) {
            VisualLintAnalysisKt.createIssue(root, model2, "The text is ellipsized in locale \"" + locale + "\".", VisualLintLocaleAnalysisKt.htmlBuilder(StringsKt.trimMargin$default((String)("The text is ellipsized in locale \\\"" + locale + "\\\" but not in default locale.\n                  This might not be the intended behaviour. Consider increasing the text view size."), null, (int)1, null)), VisualLintErrorType.LOCALE_TEXT, output, analyticsManager);
        }
    }

    private static final HtmlBuilder htmlBuilder(String msg) {
        HtmlBuilder htmlBuilder = new HtmlBuilder().openHtmlBody().addHtml(msg).closeHtmlBody();
        Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"HtmlBuilder().openHtmlBo\u2026Html(msg).closeHtmlBody()");
        return htmlBuilder;
    }

    private static final void createTextTooBigIssue(VisualLintBaseConfigIssues.BaseConfigComponentState value2, ViewInfo root, NlModel model2, String locale, VisualLintIssueProvider output, VisualLintAnalyticsManager analyticsManager) {
        if (value2 == null) {
            VisualLintAnalysisKt.createIssue(root, model2, "The text might be cut off.", VisualLintLocaleAnalysisKt.htmlBuilder("The text is too large in locale \"" + locale + "\" to fit inside the TextView."), VisualLintErrorType.LOCALE_TEXT, output, analyticsManager);
        } else if (!value2.getHasI18NTextTooBig()) {
            VisualLintAnalysisKt.createIssue(root, model2, "The text might be cut off.", VisualLintLocaleAnalysisKt.htmlBuilder(StringsKt.trimMargin$default((String)("The text is too large in locale \\\"" + locale + "\\\" to fit inside the TextView.\n           This behavior is different from default locale and might not be intended behavior."), null, (int)1, null)), VisualLintErrorType.LOCALE_TEXT, output, analyticsManager);
        }
    }

    private static final boolean isEllipsized(ViewInfo view) {
        boolean bl;
        block5: {
            Layout layout2;
            if (!(view.getViewObject() instanceof TextView)) {
                return false;
            }
            Object object = view.getViewObject();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
            }
            TextView textView = (TextView)object;
            Layout layout3 = layout2 = textView.getLayout();
            Intrinsics.checkNotNullExpressionValue((Object)layout3, (String)"layout");
            int lines = layout3.getLineCount();
            Iterable $this$any$iv = (Iterable)RangesKt.downTo((int)(lines - 1), (int)0);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(layout2.getEllipsisCount(it) > 0)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isTextTooBig(ViewInfo view) {
        int lineCount;
        if (!(view.getViewObject() instanceof TextView)) {
            return false;
        }
        Object object = view.getViewObject();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        TextView textView = (TextView)object;
        TextPaint paint = textView.getPaint();
        CharSequence text = textView.getText();
        int lineHeight = textView.getLineHeight();
        int requiredTextBoundsHeight = lineHeight * (lineCount = textView.getLineCount());
        if (requiredTextBoundsHeight > textView.getHeight()) {
            return true;
        }
        int requiredTextBoundsWidth = 0;
        int n = 0;
        int n2 = lineCount;
        while (n < n2) {
            void line;
            int start = textView.getLayout().getLineStart((int)line);
            int end = textView.getLayout().getLineEnd((int)line);
            Rect rect = new Rect();
            paint.getTextBounds(text, start, end, rect);
            requiredTextBoundsWidth = RangesKt.coerceAtLeast((int)requiredTextBoundsWidth, (int)rect.width());
            ++line;
        }
        return requiredTextBoundsWidth > textView.getWidth();
    }
}

