/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint;

import android.view.View;
import com.android.ide.common.rendering.api.Result;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.surface.NlScannerLayoutParser;
import com.android.tools.idea.uibuilder.surface.RenderResultMetricData;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAtfIssue;
import com.android.tools.idea.validator.LayoutValidator;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorHierarchy;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.idea.validator.ValidatorUtil;
import com.google.android.apps.common.testing.accessibility.framework.checks.DuplicateClickableBoundsCheck;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAtfAnalysis;", "Lcom/intellij/openapi/Disposable;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "(Lcom/android/tools/idea/common/model/NlModel;)V", "layoutParser", "Lcom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser;", "renderMetric", "Lcom/android/tools/idea/uibuilder/surface/RenderResultMetricData;", "getRenderMetric", "()Lcom/android/tools/idea/uibuilder/surface/RenderResultMetricData;", "setRenderMetric", "(Lcom/android/tools/idea/uibuilder/surface/RenderResultMetricData;)V", "dispose", "", "pause", "resume", "validateAndUpdateLint", "", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAtfIssue;", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "", "validatorResult", "Lcom/android/tools/idea/validator/ValidatorResult;", "intellij.android.designer"})
public final class VisualLintAtfAnalysis
implements Disposable {
    private final NlScannerLayoutParser layoutParser;
    @NotNull
    private RenderResultMetricData renderMetric;
    private final NlModel model;

    @NotNull
    public final RenderResultMetricData getRenderMetric() {
        return this.renderMetric;
    }

    public final void setRenderMetric(@NotNull RenderResultMetricData renderResultMetricData) {
        Intrinsics.checkNotNullParameter((Object)renderResultMetricData, (String)"<set-?>");
        this.renderMetric = renderResultMetricData;
    }

    public final void pause() {
        LayoutValidator.setPaused(true);
    }

    public final void resume() {
        LayoutValidator.setPaused(false);
    }

    @NotNull
    public final List<VisualLintAtfIssue> validateAndUpdateLint(@NotNull RenderResult renderResult) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Object validatorResult = renderResult.getValidatorResult();
        if (validatorResult instanceof ValidatorHierarchy) {
            ValidatorResult validated;
            if (!((ValidatorHierarchy)validatorResult).isHierarchyBuilt()) {
                return new ArrayList();
            }
            ValidatorData.Policy policy = new ValidatorData.Policy(EnumSet.of((Enum)ValidatorData.Type.ACCESSIBILITY, (Enum)ValidatorData.Type.RENDER), EnumSet.of((Enum)ValidatorData.Level.ERROR, (Enum)ValidatorData.Level.WARNING, (Enum)ValidatorData.Level.INFO, (Enum)ValidatorData.Level.VERBOSE));
            policy.mChecks.add(new DuplicateClickableBoundsCheck());
            ValidatorResult validatorResult2 = validated = ValidatorUtil.generateResults(policy, (ValidatorHierarchy)validatorResult);
            Intrinsics.checkNotNullExpressionValue((Object)validatorResult2, (String)"validated");
            return this.validateAndUpdateLint(renderResult, validatorResult2);
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<VisualLintAtfIssue> validateAndUpdateLint(RenderResult renderResult, ValidatorResult validatorResult) {
        this.layoutParser.clear();
        ArrayList<VisualLintAtfIssue> issues = new ArrayList<VisualLintAtfIssue>();
        try {
            NlComponent root;
            ImmutableList<NlComponent> immutableList = this.model.getComponents();
            Intrinsics.checkNotNullExpressionValue(immutableList, (String)"model.components");
            ImmutableList<NlComponent> components = immutableList;
            if (components.isEmpty()) {
                List list = issues;
                return list;
            }
            int issuesWithoutSources = 0;
            NlComponent nlComponent = root = (NlComponent)components.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"root");
            this.layoutParser.buildViewToComponentMap(nlComponent);
            List<ValidatorData.Issue> list = validatorResult.getIssues();
            Intrinsics.checkNotNullExpressionValue(list, (String)"validatorResult.issues");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ValidatorData.Issue it = (ValidatorData.Issue)element$iv;
                boolean bl = false;
                if (it.mLevel != ValidatorData.Level.ERROR && it.mLevel != ValidatorData.Level.WARNING || it.mType != ValidatorData.Type.ACCESSIBILITY) continue;
                ValidatorData.Issue issue = it;
                Intrinsics.checkNotNullExpressionValue((Object)issue, (String)"it");
                ImmutableBiMap<Long, View> immutableBiMap = validatorResult.getSrcMap();
                Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"validatorResult.srcMap");
                NlComponent component = this.layoutParser.findComponent(issue, (BiMap<Long, View>)((BiMap)immutableBiMap));
                if (component == null) {
                    int n = issuesWithoutSources;
                    issuesWithoutSources = n + 1;
                    continue;
                }
                issues.add(new VisualLintAtfIssue(it, component, this.model));
            }
        }
        finally {
            this.renderMetric.setRenderMs(renderResult.getStats().getRenderDurationMs());
            this.renderMetric.setScanMs(validatorResult.getMetric().mHierarchyCreationMs);
            this.renderMetric.setComponentCount(this.layoutParser.getComponentCount());
            Result result = renderResult.getRenderResult();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"renderResult.renderResult");
            this.renderMetric.setRenderResultSuccess(result.isSuccess());
            this.layoutParser.clear();
        }
        return issues;
    }

    public void dispose() {
        this.layoutParser.clear();
    }

    public VisualLintAtfAnalysis(@NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        this.layoutParser = new NlScannerLayoutParser();
        this.renderMetric = new RenderResultMetricData(0L, 0L, 0, false, 15, null);
        Disposer.register((Disposable)this.model, (Disposable)this);
        LayoutValidator.setObtainCharacterLocations(true);
    }
}

