/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.colorblindmode;

import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorConstantsKt;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorLut;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorUtilKt$WhenMappings;
import com.android.tools.idea.uibuilder.visual.colorblindmode.Mat3D;
import com.android.tools.idea.uibuilder.visual.colorblindmode.MathUtilKt;
import com.android.tools.idea.uibuilder.visual.colorblindmode.RGB;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"applyGamma", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/RGB;", "color", "gamma", "", "buildColorLut", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorLut;", "dim", "", "mode", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "removeGammaCLut", "", "buildGammaCLut", "function", "Ljava/util/function/Function;", "buildUniformColorLut", "convertSingleColor", "lms2lms", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/Mat3D;", "getMat3D", "removeGamma", "intellij.android.designer"})
public final class ColorUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ColorLut buildColorLut(int dim, @NotNull ColorBlindMode mode, @NotNull double[] removeGammaCLut) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)removeGammaCLut, (String)"removeGammaCLut");
        int[] ret = new int[dim * dim * dim];
        Mat3D lms2lms = ColorUtilKt.getMat3D(mode);
        int n = 0;
        int n2 = ret.length;
        while (n < n2) {
            int converted;
            void i;
            void ri = i % dim;
            void gi = i / dim % dim;
            void bi = i / (dim * dim);
            void red = ri * 255 / (dim - 1);
            void green = gi * 255 / (dim - 1);
            void blue = bi * 255 / (dim - 1);
            ret[i] = converted = ColorUtilKt.convertSingleColor(MathUtilKt.combine((int)red, (int)green, (int)blue), lms2lms, removeGammaCLut);
            ++i;
        }
        return new ColorLut(ret, dim);
    }

    private static final Mat3D getMat3D(ColorBlindMode mode) {
        Mat3D mat3D;
        switch (ColorUtilKt$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                mat3D = ColorConstantsKt.getIDENTITY_MATRIX();
                break;
            }
            case 2: {
                mat3D = ColorConstantsKt.buildLms2Lmsp$default(0.0, 1, null);
                break;
            }
            case 3: {
                mat3D = ColorConstantsKt.buildLms2Lmsp(0.25);
                break;
            }
            case 4: {
                mat3D = ColorConstantsKt.buildLms2Lmsd$default(0.0, 1, null);
                break;
            }
            case 5: {
                mat3D = ColorConstantsKt.buildLms2Lmsd(0.25);
                break;
            }
            case 6: {
                mat3D = ColorConstantsKt.buildLms2Lmst$default(0.0, 1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mat3D;
    }

    public static final int convertSingleColor(int color2, @NotNull Mat3D lms2lms, @NotNull double[] removeGammaCLut) {
        Intrinsics.checkNotNullParameter((Object)lms2lms, (String)"lms2lms");
        Intrinsics.checkNotNullParameter((Object)removeGammaCLut, (String)"removeGammaCLut");
        RGB color3 = new RGB(MathUtilKt.r(color2), MathUtilKt.g(color2), MathUtilKt.b(color2));
        color3 = ColorUtilKt.removeGamma(color3, removeGammaCLut);
        color3 = ColorConstantsKt.getRGB_TO_LMS().times(color3);
        color3 = lms2lms.times(color3);
        color3 = ColorConstantsKt.getLMS_TO_RGB().times(color3);
        return ColorUtilKt.applyGamma$default(color3, 0.0, 2, null).color();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] buildGammaCLut(@NotNull Function<Double, Double> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        double[] toReturn = new double[256];
        int n = 0;
        int n2 = 255;
        while (n <= n2) {
            void i;
            Double d = function.apply((double)i);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"function.apply(i.toDouble())");
            toReturn[i] = ((Number)d).doubleValue();
            ++i;
        }
        return toReturn;
    }

    @NotNull
    public static final RGB removeGamma(@NotNull RGB color2, @NotNull double[] removeGammaCLut) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        Intrinsics.checkNotNullParameter((Object)removeGammaCLut, (String)"removeGammaCLut");
        double r = removeGammaCLut[(int)color2.getR()];
        double g = removeGammaCLut[(int)color2.getG()];
        double b = removeGammaCLut[(int)color2.getB()];
        return new RGB(r, g, b);
    }

    @NotNull
    public static final RGB applyGamma(@NotNull RGB color2, double gamma) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        double d = color2.getR();
        double d2 = 1.0 / gamma;
        double rg = 255.0 * Math.pow(d, d2);
        d2 = color2.getG();
        double d3 = 1.0 / gamma;
        double gg = 255.0 * Math.pow(d2, d3);
        d3 = color2.getB();
        double d4 = 1.0 / gamma;
        double bg = 255.0 * Math.pow(d3, d4);
        return new RGB(rg, gg, bg);
    }

    public static /* synthetic */ RGB applyGamma$default(RGB rGB, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 2.2;
        }
        return ColorUtilKt.applyGamma(rGB, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ColorLut buildUniformColorLut(int dim) {
        int[] ret = new int[dim * dim * dim];
        int n = 0;
        int n2 = ret.length;
        while (n < n2) {
            int color2;
            void i;
            void ri = i % dim;
            void gi = i / dim % dim;
            void bi = i / (dim * dim);
            void red = ri * 255 / (dim - 1);
            void green = gi * 255 / (dim - 1);
            void blue = bi * 255 / (dim - 1);
            ret[i] = color2 = red << 16 | green << 8 | blue;
            ++i;
        }
        return new ColorLut(ret, dim);
    }
}

