/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.colorblindmode;

import com.android.tools.idea.uibuilder.visual.colorblindmode.MathUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorLut;", "", "lut", "", "dim", "", "([II)V", "getDim", "()I", "dimdim", "getLut", "()[I", "interpolate", "inputColor", "nextBlue", "index", "nextGreen", "nextRed", "toString", "", "intellij.android.designer"})
public final class ColorLut {
    private final int dimdim;
    @NotNull
    private final int[] lut;
    private final int dim;

    public final int nextRed(int index) {
        if ((index + 1) % this.dim == 0) {
            return index;
        }
        return index + 1;
    }

    public final int nextGreen(int index) {
        int modded = index % this.dimdim / this.dim;
        if (modded == this.dim - 1) {
            return index;
        }
        return index + this.dim;
    }

    public final int nextBlue(int index) {
        int lastPanel = this.lut.length - this.dimdim;
        if (index >= lastPanel) {
            return index;
        }
        return index + this.dimdim;
    }

    public final int interpolate(int inputColor) {
        int red = inputColor >> 16 & 0xFF;
        int green = inputColor >> 8 & 0xFF;
        int blue = inputColor & 0xFF;
        double rx = (double)(red * (this.dim - 1)) / 255.0;
        int rx0 = (int)Math.floor(rx);
        double gx = (double)(green * (this.dim - 1)) / 255.0;
        int gx0 = (int)Math.floor(gx);
        double bx = (double)(blue * (this.dim - 1)) / 255.0;
        int bx0 = (int)Math.floor(bx);
        int x0 = rx0 + gx0 * this.dim + bx0 * this.dimdim;
        int rx1 = (int)Math.ceil(rx);
        int gx1 = (int)Math.ceil(gx);
        int bx1 = (int)Math.ceil(bx);
        int ry0 = MathUtilKt.r(this.lut[x0]);
        int ry1 = MathUtilKt.r(this.lut[this.nextRed(x0)]);
        int gy0 = MathUtilKt.g(this.lut[x0]);
        int gy1 = MathUtilKt.g(this.lut[this.nextGreen(x0)]);
        int by0 = MathUtilKt.b(this.lut[x0]);
        int by1 = MathUtilKt.b(this.lut[this.nextBlue(x0)]);
        int ry = rx0 == rx1 ? ry0 : MathUtilKt.interpolate(rx, rx0, rx1, ry0, ry1);
        int gy = gx0 == gx1 ? gy0 : MathUtilKt.interpolate(gx, gx0, gx1, gy0, gy1);
        int by = bx0 == bx1 ? by0 : MathUtilKt.interpolate(bx, bx0, bx1, by0, by1);
        return ry << 16 | gy << 8 | by;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        int n = 0;
        int n2 = this.lut.length;
        while (n < n2) {
            void i;
            int color2 = this.lut[i];
            if ((i + true) % this.dim == false) {
                builder2.append(MathUtilKt.r(color2) + ", " + MathUtilKt.g(color2) + ", " + MathUtilKt.b(color2) + " \n");
            } else {
                builder2.append(MathUtilKt.r(color2) + ", " + MathUtilKt.g(color2) + ", " + MathUtilKt.b(color2) + " \t\t");
            }
            if ((i + true) % (this.dim * this.dim) == false) {
                builder2.append("=========================\n");
            }
            ++i;
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        return string2;
    }

    @NotNull
    public final int[] getLut() {
        return this.lut;
    }

    public final int getDim() {
        return this.dim;
    }

    public ColorLut(@NotNull int[] lut, int dim) {
        Intrinsics.checkNotNullParameter((Object)lut, (String)"lut");
        this.lut = lut;
        this.dim = dim;
        this.dimdim = this.dim * this.dim;
    }
}

