/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/uibuilder/visual/IssuePanelToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "surface", "Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;", "(Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;)V", "getSurface", "()Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.designer"})
public final class IssuePanelToggleAction
extends ToggleAction {
    @NotNull
    private final NlDesignSurface surface;

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = StudioFlags.NELE_SHOW_ISSUE_PANEL_IN_PROBLEMS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.NELE_SHOW_IS\u2026E_PANEL_IN_PROBLEMS.get()");
        if (((Boolean)object).booleanValue()) {
            Project project = this.surface.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"surface.project");
            IssuePanelService service = IssuePanelService.Companion.getInstance(project);
            if (service == null) {
                Logger.getInstance(IssuePanelToggleAction.class).warn("Cannot find Issue Panel Service");
                return false;
            }
            if (service.isLayoutAndQualifierPanelVisible()) {
                IssueModel issueModel = this.surface.getIssueModel();
                Intrinsics.checkNotNullExpressionValue((Object)issueModel, (String)"surface.issueModel");
                return service.isIssueModelAttached(issueModel);
            }
            return false;
        }
        IssuePanel issuePanel = this.surface.getIssuePanel();
        Intrinsics.checkNotNullExpressionValue((Object)issuePanel, (String)"surface.issuePanel");
        return !issuePanel.isMinimized();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = StudioFlags.NELE_SHOW_ISSUE_PANEL_IN_PROBLEMS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.NELE_SHOW_IS\u2026E_PANEL_IN_PROBLEMS.get()");
        if (((Boolean)object).booleanValue()) {
            Project project = this.surface.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"surface.project");
            IssuePanelService service = IssuePanelService.Companion.getInstance(project);
            if (service == null) {
                Logger.getInstance(IssuePanelToggleAction.class).warn("Cannot find Issue Panel Service");
                return;
            }
            if (state) {
                service.showCurrentFileAndQualifierTab();
                IssueModel issueModel = this.surface.getIssueModel();
                Intrinsics.checkNotNullExpressionValue((Object)issueModel, (String)"surface.issueModel");
                NlModel nlModel = this.surface.getModel();
                Intrinsics.checkNotNull((Object)nlModel);
                Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"surface.model!!");
                VirtualFile virtualFile = nlModel.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"surface.model!!.virtualFile");
                service.attachIssueModel(issueModel, virtualFile);
            } else {
                IssueModel issueModel = this.surface.getIssueModel();
                Intrinsics.checkNotNullExpressionValue((Object)issueModel, (String)"surface.issueModel");
                service.detachIssueModel(issueModel);
                service.hideIssuePanel();
            }
        } else {
            this.surface.setShowIssuePanel(state, false);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(this.surface.getIssueModel().hasIssues());
    }

    @NotNull
    public final NlDesignSurface getSurface() {
        return this.surface;
    }

    public IssuePanelToggleAction(@NotNull NlDesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        super("Toggle visibility of issue panel", "Toggle visibility of issue panel", StudioIcons.Common.WARNING);
        this.surface = surface2;
    }
}

