/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.type.DesignerEditorFileTypeKt;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.uibuilder.model.NlComponentRegistrar;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.android.tools.idea.uibuilder.visual.AddCustomConfigurationAction;
import com.android.tools.idea.uibuilder.visual.ConfigurationSetListener;
import com.android.tools.idea.uibuilder.visual.CustomConfigurationAttribute;
import com.android.tools.idea.uibuilder.visual.CustomConfigurationSet;
import com.android.tools.idea.uibuilder.visual.CustomConfigurationUtilsKt;
import com.android.tools.idea.uibuilder.visual.CustomModelDataContext;
import com.android.tools.idea.uibuilder.visual.CustomModelsProviderKt;
import com.android.tools.idea.uibuilder.visual.NamedConfiguration;
import com.android.tools.idea.uibuilder.visual.VisualizationModelsProvider;
import com.android.tools.idea.uibuilder.visual.VisualizationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/uibuilder/visual/CustomModelsProvider;", "Lcom/android/tools/idea/uibuilder/visual/VisualizationModelsProvider;", "customId", "", "customConfigSet", "Lcom/android/tools/idea/uibuilder/visual/CustomConfigurationSet;", "configurationSetListener", "Lcom/android/tools/idea/uibuilder/visual/ConfigurationSetListener;", "(Ljava/lang/String;Lcom/android/tools/idea/uibuilder/visual/CustomConfigurationSet;Lcom/android/tools/idea/uibuilder/visual/ConfigurationSetListener;)V", "configurationToConfigurationAttributesMap", "Ljava/util/WeakHashMap;", "Lcom/android/tools/idea/configurations/Configuration;", "Lcom/android/tools/idea/uibuilder/visual/CustomConfigurationAttribute;", "getCustomConfigSet", "()Lcom/android/tools/idea/uibuilder/visual/CustomConfigurationSet;", "getCustomId", "()Ljava/lang/String;", "addCustomConfigurationAttributes", "", "config", "createActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "file", "Lcom/intellij/psi/PsiFile;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "createNlModels", "", "Lcom/android/tools/idea/common/model/NlModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "removeCustomConfigurationAttributes", "model", "intellij.android.designer"})
public final class CustomModelsProvider
implements VisualizationModelsProvider {
    private final WeakHashMap<Configuration, CustomConfigurationAttribute> configurationToConfigurationAttributesMap;
    @NotNull
    private final String customId;
    @NotNull
    private final CustomConfigurationSet customConfigSet;
    private final ConfigurationSetListener configurationSetListener;

    public final void addCustomConfigurationAttributes(@NotNull CustomConfigurationAttribute config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.customConfigSet.addConfigAttribute(config);
        VisualizationUtil.INSTANCE.setCustomConfigurationSet(this.customId, this.customConfigSet);
        this.configurationSetListener.onCurrentConfigurationSetUpdated();
    }

    public final void removeCustomConfigurationAttributes(@NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        CustomConfigurationAttribute customConfigurationAttribute = this.configurationToConfigurationAttributesMap.get(model2.getConfiguration());
        if (customConfigurationAttribute == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)customConfigurationAttribute, (String)"configurationToConfigura\u2026.configuration] ?: return");
        CustomConfigurationAttribute config = customConfigurationAttribute;
        this.customConfigSet.removeConfigAttribute(config);
        VisualizationUtil.INSTANCE.setCustomConfigurationSet(this.customId, this.customConfigSet);
        this.configurationSetListener.onCurrentConfigurationSetUpdated();
    }

    @Override
    @NotNull
    public ActionGroup createActions(@NotNull PsiFile file2, @NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        AddCustomConfigurationAction addAction = new AddCustomConfigurationAction(file2, facet, this);
        return (ActionGroup)new DefaultActionGroup(new AnAction[]{addAction});
    }

    @Override
    @NotNull
    public List<NlModel> createNlModels(@NotNull Disposable parentDisposable, @NotNull PsiFile file2, @NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        if (Intrinsics.areEqual((Object)DesignerEditorFileTypeKt.typeOf(file2), (Object)LayoutFileType.INSTANCE) ^ true) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile currentFile = virtualFile;
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance((AndroidFacet)facet);
        Intrinsics.checkNotNullExpressionValue((Object)configurationManager, (String)"ConfigurationManager.getOrCreateInstance(facet)");
        ConfigurationManager configurationManager2 = configurationManager;
        Configuration configuration = configurationManager2.getConfiguration(currentFile);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configurationManager.getConfiguration(currentFile)");
        Configuration currentFileConfig = configuration;
        List models2 = new ArrayList();
        models2.add(NlModel.builder(facet, currentFile, currentFileConfig).withParentDisposable(parentDisposable).withModelDisplayName("Default (Current File)").withComponentRegistrar(NlComponentRegistrar.INSTANCE).build());
        for (CustomConfigurationAttribute attributes : this.customConfigSet.getCustomConfigAttributes()) {
            NamedConfiguration customConfig;
            if (CustomModelsProviderKt.access$toNamedConfiguration(attributes, currentFileConfig) == null) {
                continue;
            }
            Configuration config = customConfig.getConfig();
            State state = config.getDeviceState();
            VirtualFile virtualFile2 = ConfigurationMatcher.getBetterMatch((Configuration)currentFileConfig, (Device)config.getDevice(), (String)(state != null ? state.getName() : null), (Locale)config.getLocale(), (IAndroidTarget)config.getTarget());
            if (virtualFile2 == null) {
                virtualFile2 = currentFile;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ConfigurationMatcher.get\u2026ig.target) ?: currentFile");
            VirtualFile betterFile = virtualFile2;
            NlModel model2 = NlModel.builder(facet, betterFile, config).withParentDisposable(parentDisposable).withModelDisplayName(customConfig.getName()).withModelTooltip(CustomConfigurationUtilsKt.toHtmlTooltip(config)).withComponentRegistrar(NlComponentRegistrar.INSTANCE).withDataContext(CustomModelDataContext.INSTANCE).build();
            models2.add(model2);
            Disposer.register((Disposable)model2, (Disposable)((Disposable)config));
            ((Map)this.configurationToConfigurationAttributesMap).put(config, attributes);
        }
        return models2;
    }

    @NotNull
    public final String getCustomId() {
        return this.customId;
    }

    @NotNull
    public final CustomConfigurationSet getCustomConfigSet() {
        return this.customConfigSet;
    }

    public CustomModelsProvider(@NotNull String customId, @NotNull CustomConfigurationSet customConfigSet, @NotNull ConfigurationSetListener configurationSetListener) {
        Intrinsics.checkNotNullParameter((Object)customId, (String)"customId");
        Intrinsics.checkNotNullParameter((Object)customConfigSet, (String)"customConfigSet");
        Intrinsics.checkNotNullParameter((Object)configurationSetListener, (String)"configurationSetListener");
        this.customId = customId;
        this.customConfigSet = customConfigSet;
        this.configurationSetListener = configurationSetListener;
        this.configurationToConfigurationAttributesMap = new WeakHashMap();
    }
}

