/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionInputEvent;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MouseMovedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0017\u001a\u00020\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/uibuilder/surface/PanInteraction;", "Lcom/android/tools/idea/common/surface/Interaction;", "pannable", "Lcom/android/tools/adtui/Pannable;", "(Lcom/android/tools/adtui/Pannable;)V", "isGrabbing", "", "pannableOriginalPosition", "Ljava/awt/Point;", "startPoint", "begin", "", "event", "Lcom/android/tools/idea/common/surface/InteractionEvent;", "cancel", "commit", "getCursor", "Ljava/awt/Cursor;", "setupOriginalPoint", "T", "Ljava/awt/event/MouseEvent;", "Lcom/android/tools/idea/common/surface/InteractionInputEvent;", "update", "updateMouseScrollEvent", "intellij.android.designer"})
public final class PanInteraction
extends Interaction {
    private boolean isGrabbing;
    private Point pannableOriginalPosition;
    private final Point startPoint;
    private final Pannable pannable;

    @Override
    public void begin(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.begin(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
        if (event instanceof MousePressedEvent) {
            this.setupOriginalPoint((InteractionInputEvent)event);
            this.isGrabbing = (event.getInfo().getModifiersEx() & 0xC00) > 0;
        }
    }

    private final <T extends MouseEvent> void setupOriginalPoint(InteractionInputEvent<? extends T> event) {
        MouseEvent mouseEvent = (MouseEvent)event.getEventObject();
        this.pannableOriginalPosition = this.pannable.getScrollPosition().getLocation();
        this.startPoint.setLocation(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        block1: {
            InteractionEvent interactionEvent;
            block3: {
                block2: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        interactionEvent = event;
                        if (!(interactionEvent instanceof MousePressedEvent)) break block0;
                        if ((event.getInfo().getModifiersEx() & 0xC00) <= 0) break block1;
                        this.setupOriginalPoint((InteractionInputEvent)event);
                        this.isGrabbing = true;
                        break block1;
                    }
                    if (!(interactionEvent instanceof MouseMovedEvent)) break block2;
                    this.updateMouseScrollEvent((InteractionInputEvent)event);
                    break block1;
                }
                if (!(interactionEvent instanceof MouseDraggedEvent)) break block3;
                this.updateMouseScrollEvent((InteractionInputEvent)event);
                break block1;
            }
            if (!(interactionEvent instanceof MouseReleasedEvent)) break block1;
            this.updateMouseScrollEvent((InteractionInputEvent)event);
        }
    }

    private final <T extends MouseEvent> void updateMouseScrollEvent(InteractionInputEvent<? extends T> event) {
        MouseEvent mouseEvent = (MouseEvent)event.getEventObject();
        if ((mouseEvent.getModifiersEx() & 0xC00) > 0) {
            Point point;
            this.isGrabbing = true;
            Point point2 = this.pannableOriginalPosition;
            if (point2 == null) {
                return;
            }
            Point it = point = point2;
            boolean bl = false;
            Point newPosition = new Point(it);
            int screenX = mouseEvent.getXOnScreen();
            int screenY = mouseEvent.getYOnScreen();
            newPosition.translate(this.startPoint.x - screenX, this.startPoint.y - screenY);
            this.pannable.setScrollPosition(newPosition);
        } else {
            this.isGrabbing = false;
        }
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.end(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.cancel(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return AdtUiCursorsProvider.Companion.getInstance().getCursor(this.isGrabbing ? AdtUiCursorType.GRABBING : AdtUiCursorType.GRAB);
    }

    public PanInteraction(@NotNull Pannable pannable) {
        Intrinsics.checkNotNullParameter((Object)pannable, (String)"pannable");
        this.pannable = pannable;
        this.pannableOriginalPosition = new Point();
        this.startPoint = new Point();
    }
}

