/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DrawLassoUtil;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarqueeInteraction
extends Interaction {
    private MarqueeLayer myOverlay;
    private final SceneView mySceneView;

    public MarqueeInteraction(@NotNull SceneView surface2) {
        if (surface2 == null) {
            MarqueeInteraction.$$$reportNull$$$0(0);
        }
        this.mySceneView = surface2;
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        if (event == null) {
            MarqueeInteraction.$$$reportNull$$$0(1);
        }
        assert (event instanceof MouseDraggedEvent) : "The instance of event should be MouseDraggedEvent but it is " + event.getClass() + "; The SceneView is " + this.mySceneView + ", start (x, y) = " + this.myStartX + ", " + this.myStartY + ", start mask is " + this.myStartMask;
        MouseEvent mouseEvent = (MouseEvent)((MouseDraggedEvent)event).getEventObject();
        this.begin(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        if (event == null) {
            MarqueeInteraction.$$$reportNull$$$0(2);
        }
        if (event instanceof MouseDraggedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MouseDraggedEvent)event).getEventObject();
            this.update(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.myOverlay == null) {
            return;
        }
        int xp = Math.min(x, this.myStartX);
        int yp = Math.min(y, this.myStartY);
        int w = Math.abs(x - this.myStartX);
        int h = Math.abs(y - this.myStartY);
        int ax = Coordinates.getAndroidXDip(this.mySceneView, xp);
        int ay = Coordinates.getAndroidYDip(this.mySceneView, yp);
        int aw = Coordinates.getAndroidDimensionDip(this.mySceneView, w);
        int ah = Coordinates.getAndroidDimensionDip(this.mySceneView, h);
        this.myOverlay.updateValues(xp, yp, w, h, x, y, aw, ah);
        List<SceneComponent> within = this.mySceneView.getScene().findWithin(ax, ay, aw, ah);
        List result = ContainerUtil.map(within, SceneComponent::getNlComponent);
        this.mySceneView.getSelectionModel().setSelection(result);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        if (event == null) {
            MarqueeInteraction.$$$reportNull$$$0(3);
        }
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        if (event == null) {
            MarqueeInteraction.$$$reportNull$$$0(4);
        }
        this.cancel(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    public void cancel(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.mySceneView.getSelectionModel().clear();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return null;
    }

    @Override
    @NotNull
    public List<Layer> createOverlays() {
        ColorSet colorSet = this.mySceneView.getColorSet();
        this.myOverlay = new MarqueeLayer(colorSet);
        List<Layer> list = Collections.singletonList(this.myOverlay);
        if (list == null) {
            MarqueeInteraction.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/MarqueeInteraction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/MarqueeInteraction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverlays";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "begin";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MarqueeLayer
    extends Layer {
        @NotNull
        ColorSet myColorSet;
        private int x;
        private int y;
        private int w;
        private int h;
        private int mouseX;
        private int mouseY;
        private int androidWidth;
        private int androidHeight;

        private MarqueeLayer(@NotNull ColorSet colorSet) {
            if (colorSet == null) {
                MarqueeLayer.$$$reportNull$$$0(0);
            }
            this.myColorSet = colorSet;
        }

        private void updateValues(int x, int y, int w, int h, int mouseX, int mouseY, int androidWidth, int androidHeight) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.androidWidth = androidWidth;
            this.androidHeight = androidHeight;
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                MarqueeLayer.$$$reportNull$$$0(1);
            }
            DrawLassoUtil.drawLasso(gc, this.myColorSet, this.x, this.y, this.w, this.h, this.mouseX, this.mouseY, this.androidWidth, this.androidHeight, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/MarqueeInteraction$MarqueeLayer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

