/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.uibuilder.surface.DeviceSizeList;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\"\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0019\u001a\u00020\u000bR,\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/uibuilder/surface/DeviceSizeList;", "", "()V", "myList", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/uibuilder/surface/DeviceSizeList$DeviceSize;", "Lkotlin/collections/ArrayList;", "getMyList$annotations", "getMyList", "()Ljava/util/ArrayList;", "add", "", "device", "Lcom/android/sdklib/devices/Device;", "px", "", "py", "binarySearch", "x", "y", "snapThreshold", "isInRange", "", "threshold", "snapToDevice", "sort", "DeviceSize", "intellij.android.designer"})
public final class DeviceSizeList {
    @NotNull
    private final ArrayList<DeviceSize> myList = new ArrayList();

    @VisibleForTesting
    public static /* synthetic */ void getMyList$annotations() {
    }

    @NotNull
    public final ArrayList<DeviceSize> getMyList() {
        return this.myList;
    }

    public final void add(@NotNull Device device, int px, int py) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.myList.add(DeviceSize.Companion.create(device, px, py));
    }

    public final void sort() {
        CollectionsKt.sort((List)this.myList);
    }

    @Nullable
    public final DeviceSize snapToDevice(int px, int py, int snapThreshold) {
        boolean reverse = px > py;
        int x = reverse ? py : px;
        int y = reverse ? px : py;
        DeviceSize deviceSize = this.binarySearch(x, y, snapThreshold);
        if (deviceSize == null) {
            return null;
        }
        DeviceSize toReturn = deviceSize;
        if (reverse) {
            return toReturn.rotate();
        }
        return toReturn;
    }

    private final DeviceSize binarySearch(int x, int y, int snapThreshold) {
        int start = 0;
        int end = this.myList.size() - 1;
        while (start <= end) {
            DeviceSize p;
            int mid = (start + end) / 2;
            Intrinsics.checkNotNullExpressionValue((Object)this.myList.get(mid), (String)"myList[mid]");
            if (this.isInRange(snapThreshold, x, y, p.getX(), p.getY())) {
                return p;
            }
            if (p.getX() < x) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return null;
    }

    private final boolean isInRange(int threshold, int x, int y, int px, int py) {
        return Math.abs(x - px) < threshold && Math.abs(y - py) < threshold;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0006\u0010\u0007\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/uibuilder/surface/DeviceSizeList$DeviceSize;", "", "device", "Lcom/android/sdklib/devices/Device;", "x", "", "y", "rotate", "", "(Lcom/android/sdklib/devices/Device;IIZ)V", "getDevice", "()Lcom/android/sdklib/devices/Device;", "getRotate", "()Z", "setRotate", "(Z)V", "getX", "()I", "getY", "compareTo", "other", "equals", "", "Companion", "intellij.android.designer"})
    public static final class DeviceSize
    implements Comparable<DeviceSize> {
        @NotNull
        private final Device device;
        private final int x;
        private final int y;
        private boolean rotate;
        private static final Comparator<DeviceSize> COMPARATOR;
        @NotNull
        public static final Companion Companion;

        @Override
        public int compareTo(@NotNull DeviceSize other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return COMPARATOR.compare(this, other);
        }

        @NotNull
        public final DeviceSize rotate() {
            return new DeviceSize(this.device, this.y, this.x, true);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof DeviceSize)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.device, (Object)((DeviceSize)other).device) && this.x == ((DeviceSize)other).x && this.y == ((DeviceSize)other).y && this.rotate == ((DeviceSize)other).rotate;
        }

        @NotNull
        public final Device getDevice() {
            return this.device;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final boolean getRotate() {
            return this.rotate;
        }

        public final void setRotate(boolean bl) {
            this.rotate = bl;
        }

        private DeviceSize(Device device, int x, int y, boolean rotate) {
            this.device = device;
            this.x = x;
            this.y = y;
            this.rotate = rotate;
        }

        /* synthetic */ DeviceSize(Device device, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                bl = false;
            }
            this(device, n, n2, bl);
        }

        static {
            Companion = new Companion(null);
            COMPARATOR = Comparator.comparingInt(Companion.COMPARATOR.1.INSTANCE).thenComparingInt(Companion.COMPARATOR.2.INSTANCE);
        }

        public /* synthetic */ DeviceSize(Device device, int x, int y, boolean rotate, DefaultConstructorMarker $constructor_marker) {
            this(device, x, y, rotate);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/uibuilder/surface/DeviceSizeList$DeviceSize$Companion;", "", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lcom/android/tools/idea/uibuilder/surface/DeviceSizeList$DeviceSize;", "kotlin.jvm.PlatformType", "create", "device", "Lcom/android/sdklib/devices/Device;", "x", "", "y", "intellij.android.designer"})
        public static final class Companion {
            @NotNull
            public final DeviceSize create(@NotNull Device device, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                if (x <= y) {
                    return new DeviceSize(device, x, y, false, 8, null);
                }
                return new DeviceSize(device, y, x, true, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

