/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.surface.DiagnosticsLayerKt;
import com.intellij.openapi.module.Module;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.uipreview.ModuleClassLoaderHatchery;
import org.jetbrains.android.uipreview.ModuleClassLoaderManagerKt;
import org.jetbrains.android.uipreview.ReadyState;
import org.jetbrains.android.uipreview.Stats;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/uibuilder/surface/ClassLoadingDebugLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "paint", "", "gc", "Ljava/awt/Graphics2D;", "intellij.android.designer"})
public final class ClassLoadingDebugLayer
extends Layer {
    @NotNull
    private final Module module;

    @Override
    public void paint(@NotNull Graphics2D gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        Graphics graphics = gc.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Color color2 = Color.BLUE;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"Color.BLUE");
        GraphicsUtilKt.setColorAndAlpha((Graphics2D)g, (Color)color2);
        g.setFont((Font)DiagnosticsLayerKt.getFONT());
        Rectangle clipBounds = g.getClipBounds();
        int startY = clipBounds.y + 20;
        int startX = clipBounds.x + 20;
        ModuleClassLoaderHatchery hatchery = (ModuleClassLoaderHatchery)this.module.getUserData(ModuleClassLoaderManagerKt.getHATCHERY());
        if (hatchery != null) {
            startY += DiagnosticsLayerKt.drawMultilineString(gc, "Preloading progress:", startX, startY);
            List stats = hatchery.getStats();
            if (stats.isEmpty()) {
                DiagnosticsLayerKt.drawMultilineString(gc, "No clutches", startX, startY);
            } else {
                int horShift = 0;
                Iterable $this$forEach$iv = stats;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Stats it = (Stats)element$iv;
                    boolean bl = false;
                    int vertShift = DiagnosticsLayerKt.drawMultilineString(gc, it.getLabel(), startX + horShift, startY);
                    Iterable $this$forEach$iv2 = it.getStates();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        ReadyState stat = (ReadyState)element$iv2;
                        boolean bl2 = false;
                        Color color3 = Color.GREEN;
                        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"Color.GREEN");
                        GraphicsUtilKt.setColorAndAlpha((Graphics2D)g, (Color)color3);
                        g.drawRect(startX + horShift, startY + vertShift, 100, 20);
                        g.fillRect(startX + horShift, startY + vertShift, 100 * stat.getProgress() / stat.getToDo(), 20);
                        vertShift += 40;
                    }
                    horShift += 150;
                }
            }
        } else {
            DiagnosticsLayerKt.drawMultilineString(gc, "No hatchery available", startX, startY);
        }
        g.dispose();
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public ClassLoadingDebugLayer(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
    }
}

