/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.uibuilder.structure.ButtonPresentation;
import com.android.tools.idea.uibuilder.structure.NlVisibilityModel;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010)H\u0014J\u0018\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00060"}, d2={"Lcom/android/tools/idea/uibuilder/structure/NlVisibilityButton;", "Ljavax/swing/JButton;", "()V", "clickedIcon", "Ljavax/swing/Icon;", "getClickedIcon", "()Ljavax/swing/Icon;", "setClickedIcon", "(Ljavax/swing/Icon;)V", "hoveredIcon", "getHoveredIcon", "setHoveredIcon", "insets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "isClicked", "", "()Z", "setClicked", "(Z)V", "isHovered", "setHovered", "normalIcon", "getNormalIcon", "setNormalIcon", "updateBgWhenHovered", "getUpdateBgWhenHovered", "setUpdateBgWhenHovered", "visibility", "Lcom/android/tools/idea/uibuilder/structure/NlVisibilityModel$Visibility;", "getVisibility", "()Lcom/android/tools/idea/uibuilder/structure/NlVisibilityModel$Visibility;", "setVisibility", "(Lcom/android/tools/idea/uibuilder/structure/NlVisibilityModel$Visibility;)V", "paintBackground", "", "g", "Ljava/awt/Graphics2D;", "bgColor", "Ljava/awt/Color;", "paintComponent", "Ljava/awt/Graphics;", "paintIconOnCenter", "icon", "update", "presentation", "Lcom/android/tools/idea/uibuilder/structure/ButtonPresentation;", "Companion", "intellij.android.designer"})
public final class NlVisibilityButton
extends JButton {
    private final JBInsets insets;
    @Nullable
    private NlVisibilityModel.Visibility visibility;
    private boolean isClicked;
    private boolean isHovered;
    @NotNull
    private Icon normalIcon;
    @NotNull
    private Icon hoveredIcon;
    @NotNull
    private Icon clickedIcon;
    private boolean updateBgWhenHovered;
    private static final int PADDING_X = 1;
    private static final int PADDING_Y = 4;
    public static final int WIDTH = 25;
    public static final int HEIGHT = 20;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final NlVisibilityModel.Visibility getVisibility() {
        return this.visibility;
    }

    public final void setVisibility(@Nullable NlVisibilityModel.Visibility visibility) {
        this.visibility = visibility;
    }

    public final boolean isClicked() {
        return this.isClicked;
    }

    public final void setClicked(boolean bl) {
        this.isClicked = bl;
    }

    public final boolean isHovered() {
        return this.isHovered;
    }

    public final void setHovered(boolean bl) {
        this.isHovered = bl;
    }

    @NotNull
    public final Icon getNormalIcon() {
        return this.normalIcon;
    }

    public final void setNormalIcon(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"<set-?>");
        this.normalIcon = icon2;
    }

    @NotNull
    public final Icon getHoveredIcon() {
        return this.hoveredIcon;
    }

    public final void setHoveredIcon(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"<set-?>");
        this.hoveredIcon = icon2;
    }

    @NotNull
    public final Icon getClickedIcon() {
        return this.clickedIcon;
    }

    public final void setClickedIcon(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"<set-?>");
        this.clickedIcon = icon2;
    }

    public final boolean getUpdateBgWhenHovered() {
        return this.updateBgWhenHovered;
    }

    public final void setUpdateBgWhenHovered(boolean bl) {
        this.updateBgWhenHovered = bl;
    }

    public final void update(@NotNull ButtonPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        this.visibility = presentation.getVisibility();
        this.isClicked = presentation.isClicked();
        this.isHovered = presentation.isHovered();
        this.normalIcon = presentation.getIcon();
        this.hoveredIcon = presentation.getHoverIcon();
        this.clickedIcon = presentation.getClickIcon();
        this.updateBgWhenHovered = presentation.getUpdateBgWhenHovered();
        this.setToolTipText(presentation.getHint());
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        Graphics graphics = g;
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        if (this.isClicked) {
            Color color2 = JBUI.CurrentTheme.ActionButton.pressedBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"JBUI.CurrentTheme.ActionButton.pressedBackground()");
            this.paintBackground(g2, color2);
            this.paintIconOnCenter(g2, this.clickedIcon);
        } else if (this.isHovered) {
            if (this.updateBgWhenHovered) {
                Color color3 = JBUI.CurrentTheme.ActionButton.hoverBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"JBUI.CurrentTheme.ActionButton.hoverBackground()");
                this.paintBackground(g2, color3);
            }
            this.paintIconOnCenter(g2, this.hoveredIcon);
        } else {
            this.paintIconOnCenter(g2, this.normalIcon);
        }
    }

    private final void paintIconOnCenter(Graphics2D g, Icon icon2) {
        int x = this.getWidth() / 2 - icon2.getIconWidth() / 2;
        int y = this.getHeight() / 2 - icon2.getIconHeight() / 2;
        icon2.paintIcon(this, g, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintBackground(Graphics2D g, Color bgColor) {
        Rectangle rect = new Rectangle(this.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)((Insets)this.insets));
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.setColor(bgColor);
            JBValue jBValue = DarculaUIUtil.BUTTON_ARC;
            Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"DarculaUIUtil.BUTTON_ARC");
            float arc = jBValue.getFloat();
            g2.fill(new RoundRectangle2D.Float(rect.x, rect.y, rect.width, rect.height, arc, arc));
        }
        finally {
            g2.dispose();
        }
    }

    public NlVisibilityButton() {
        JBInsets jBInsets = JBInsets.create((int)1, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"JBInsets.create(1, 2)");
        this.insets = jBInsets;
        Icon icon2 = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EmptyIcon.ICON_16");
        this.normalIcon = icon2;
        Icon icon3 = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"EmptyIcon.ICON_16");
        this.hoveredIcon = icon3;
        Icon icon4 = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"EmptyIcon.ICON_16");
        this.clickedIcon = icon4;
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.setPreferredSize(new Dimension(25, 20));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/uibuilder/structure/NlVisibilityButton$Companion;", "", "()V", "HEIGHT", "", "PADDING_X", "PADDING_Y", "WIDTH", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

