/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEventHandler;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NlTreeUtil {
    @Nullable
    public static DelegatedTreeEventHandler getSelectionTreeHandler(@NotNull NlComponentTree tree) {
        Object parentComponent;
        TreePath parentPath;
        TreePath[] paths;
        if (tree == null) {
            NlTreeUtil.$$$reportNull$$$0(0);
        }
        if ((paths = tree.getSelectionModel().getSelectionPaths()).length == 0 || (parentPath = paths[0].getParentPath()) == null || !((parentComponent = parentPath.getLastPathComponent()) instanceof NlComponent)) {
            return null;
        }
        for (int i = 1; i < paths.length; ++i) {
            if (paths[i].getParentPath() == parentPath) continue;
            return null;
        }
        ViewGroupHandler handler = NlComponentHelperKt.getViewGroupHandler((NlComponent)parentComponent);
        if (handler != null && handler instanceof DelegatedTreeEventHandler) {
            return (DelegatedTreeEventHandler)((Object)handler);
        }
        return null;
    }

    @Nullable
    public static TreePath getUniqueParent(@NotNull TreePath[] paths) {
        TreePath parentPath;
        if (paths == null) {
            NlTreeUtil.$$$reportNull$$$0(1);
        }
        if (paths.length == 0 || (parentPath = paths[0].getParentPath()) == null) {
            return null;
        }
        for (int i = 1; i < paths.length; ++i) {
            if (paths[i].getParentPath() == parentPath) continue;
            return null;
        }
        return parentPath;
    }

    static boolean delegateEvent(@NotNull DelegatedTreeEvent.Type type, @NotNull NlComponentTree tree, @NotNull NlComponent receiver, int row) {
        TreePath uniqueParent;
        TreePath[] paths;
        if (type == null) {
            NlTreeUtil.$$$reportNull$$$0(2);
        }
        if (tree == null) {
            NlTreeUtil.$$$reportNull$$$0(3);
        }
        if (receiver == null) {
            NlTreeUtil.$$$reportNull$$$0(4);
        }
        if ((paths = tree.getSelectionPaths()) != null && (uniqueParent = NlTreeUtil.getUniqueParent(paths)) != null) {
            DelegatedTreeEventHandler handler;
            TreePath pathForRow;
            List<Object> draggedObject = NlTreeUtil.collectComponentsFromPaths(paths);
            Object nextObject = null;
            if (row >= 0 && (pathForRow = tree.getPathForRow(row + 1)) != null && pathForRow.getParentPath() == uniqueParent) {
                nextObject = pathForRow.getLastPathComponent();
            }
            if ((handler = NlTreeUtil.getSelectionTreeHandler(tree)) != null) {
                return handler.handleTreeEvent(new DelegatedTreeEvent(tree, type, draggedObject, nextObject), receiver);
            }
        }
        return false;
    }

    @NotNull
    private static List<Object> collectComponentsFromPaths(@NotNull TreePath[] paths) {
        if (paths == null) {
            NlTreeUtil.$$$reportNull$$$0(5);
        }
        List<Object> list = Arrays.stream(paths).map(TreePath::getLastPathComponent).collect(Collectors.toList());
        if (list == null) {
            NlTreeUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static Collection<NlComponent> keepOnlyAncestors(@NotNull Collection<NlComponent> dragged) {
        if (dragged == null) {
            NlTreeUtil.$$$reportNull$$$0(7);
        }
        Set selection = Sets.newIdentityHashSet();
        selection.addAll(dragged);
        Stack<NlComponent> toTraverse = new Stack<NlComponent>();
        for (NlComponent selectedElement : dragged) {
            List<NlComponent> children = selectedElement.getChildren();
            toTraverse.addAll(children);
            while (!toTraverse.isEmpty()) {
                NlComponent child = (NlComponent)toTraverse.pop();
                toTraverse.addAll(child.getChildren());
                if (!selection.contains(child)) continue;
                selection.remove(child);
            }
        }
        return selection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlTreeUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlTreeUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectComponentsFromPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionTreeHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueParent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "delegateEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectComponentsFromPaths";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "keepOnlyAncestors";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

