/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.StructurePaneComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.structure.NlTreeBadgeHandler;
import com.android.tools.idea.uibuilder.structure.NlTreeCellRenderer$WhenMappings;
import com.android.tools.idea.uibuilder.structure.NlVisibilityModelKt;
import com.android.tools.lint.detector.api.Lint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u001a\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J@\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010)\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/uibuilder/structure/NlTreeCellRenderer;", "Ljavax/swing/JPanel;", "Ljavax/swing/tree/TreeCellRenderer;", "myBadgeHandler", "Lcom/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler;", "(Lcom/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler;)V", "nlComponentFont", "Ljava/awt/Font;", "kotlin.jvm.PlatformType", "otherFont", "primaryLabel", "Ljavax/swing/JLabel;", "primaryLabelMetrics", "Ljava/awt/FontMetrics;", "secondaryLabel", "secondaryLabelMetrics", "computeAvailableSpace", "", "row", "icon", "Ljavax/swing/Icon;", "cellWidth", "createTooltipText", "", "tagName", "primaryLabelText", "secondaryLabelText", "getHiddenText", "getLeftOffset", "tree", "Ljavax/swing/JTree;", "path", "Ljavax/swing/tree/TreePath;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "value", "", "selected", "", "expanded", "leaf", "hasFocus", "intellij.android.designer"})
public final class NlTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private final JLabel primaryLabel;
    private final JLabel secondaryLabel;
    private final FontMetrics primaryLabelMetrics;
    private final FontMetrics secondaryLabelMetrics;
    private final Font nlComponentFont;
    private final Font otherFont;
    private final NlTreeBadgeHandler myBadgeHandler;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String string2;
        Object object;
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.primaryLabel.setText(null);
        this.primaryLabel.setIcon(null);
        this.secondaryLabel.setText(null);
        boolean treeFocused = tree.hasFocus();
        this.primaryLabel.setForeground(UIUtil.getListForeground((boolean)selected, (boolean)treeFocused));
        this.secondaryLabel.setForeground(selected && treeFocused ? this.primaryLabel.getForeground() : UIUtil.getLabelDisabledForeground());
        if (value2 instanceof String) {
            this.primaryLabel.setText((String)value2);
            this.primaryLabel.setFont(this.otherFont);
            return this;
        }
        if (!(value2 instanceof NlComponent)) {
            return this;
        }
        switch (NlTreeCellRenderer$WhenMappings.$EnumSwitchMapping$0[NlVisibilityModelKt.getVisibilityFromParents((NlComponent)value2).ordinal()]) {
            case 1: {
                this.primaryLabel.setFont(this.nlComponentFont);
                break;
            }
            case 2: {
                this.primaryLabel.setFont(this.nlComponentFont);
                break;
            }
            case 3: {
                this.primaryLabel.setFont(this.nlComponentFont);
                this.primaryLabel.setForeground(UIUtil.makeTransparent((Color)this.primaryLabel.getForeground(), (Color)this.primaryLabel.getBackground(), (double)0.5));
                break;
            }
            case 4: {
                Font font = this.nlComponentFont;
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"nlComponentFont");
                Map<TextAttribute, ?> map2 = font.getAttributes();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"nlComponentFont.attributes");
                this.primaryLabel.setFont(this.nlComponentFont.deriveFont(MapsKt.plus(map2, (Pair)TuplesKt.to((Object)TextAttribute.STRIKETHROUGH, (Object)TextAttribute.STRIKETHROUGH_ON))));
                this.primaryLabel.setForeground(UIUtil.makeTransparent((Color)this.primaryLabel.getForeground(), (Color)this.primaryLabel.getBackground(), (double)0.5));
            }
        }
        TreePath path = tree.getPathForRow(row);
        int leftOffset = this.getLeftOffset(tree, path);
        NlModel nlModel = ((NlComponent)value2).getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"value.model");
        AndroidFacet androidFacet = nlModel.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"value.model.facet");
        AndroidFacet facet = androidFacet;
        ViewHandler handler = !facet.isDisposed() ? ViewHandlerManager.get(facet).getHandler((NlComponent)value2) : null;
        JLabel jLabel = this.primaryLabel;
        Object object2 = handler;
        if (object2 != null && (object2 = ((StructurePaneComponentHandler)object2).getIcon((NlComponent)value2)) != null) {
            Icon icon3;
            void it;
            Object object3;
            Object object4 = object3 = object2;
            JLabel jLabel2 = jLabel;
            boolean bl = false;
            if (selected && treeFocused) {
                void v6 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                icon3 = ColoredIconGenerator.generateWhiteIcon((Icon)v6);
            } else {
                void v8 = it;
                icon3 = v8;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
            }
            void var21_18 = icon3;
            jLabel = jLabel2;
            icon2 = var21_18;
        } else {
            icon2 = null;
        }
        jLabel.setIcon(icon2);
        String id2 = Lint.stripIdPrefix((String)((NlComponent)value2).getId());
        CharSequence bl = id2;
        if (bl.length() > 0) {
            object = id2;
        } else {
            Object object5 = handler;
            if (object5 == null || (object5 = ((StructurePaneComponentHandler)object5).getTitle((NlComponent)value2)) == null) {
                object5 = ((NlComponent)value2).getTagName();
            }
            object = object5;
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"handler?.getTitle(value) ?: value.tagName");
        }
        String primaryLabelText = object;
        Object object6 = handler;
        if (object6 == null || (object6 = ((StructurePaneComponentHandler)object6).getTitleAttributes((NlComponent)value2)) == null) {
            object6 = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"handler?.getTitleAttributes(value) ?: \"\"");
        Object secondaryLabelText = object6;
        int treeContainerWidth = tree.getWidth();
        int cellWidth = treeContainerWidth - leftOffset;
        this.primaryLabel.setText(primaryLabelText);
        this.secondaryLabel.setText((String)secondaryLabelText);
        if (!((NlComponentTree)((Object)tree)).shouldDisplayFittedText(row)) {
            return this;
        }
        int availableSpace = this.computeAvailableSpace(row, this.primaryLabel.getIcon(), cellWidth);
        int previousLength = primaryLabelText.length();
        FontMetrics fontMetrics = this.primaryLabelMetrics;
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"primaryLabelMetrics");
        primaryLabelText = AdtUiUtils.shrinkToFit((String)primaryLabelText, (FontMetrics)fontMetrics, (float)availableSpace);
        if (primaryLabelText.length() == previousLength) {
            FontMetrics fontMetrics2 = this.secondaryLabelMetrics;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"secondaryLabelMetrics");
            string2 = AdtUiUtils.shrinkToFit((String)secondaryLabelText, (FontMetrics)fontMetrics2, (float)(availableSpace -= this.primaryLabelMetrics.stringWidth(primaryLabelText)));
        } else {
            string2 = "";
        }
        secondaryLabelText = string2;
        String string3 = ((NlComponent)value2).getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value.tagName");
        this.setToolTipText(this.createTooltipText(string3, primaryLabelText, (String)secondaryLabelText));
        this.primaryLabel.setText(primaryLabelText);
        this.secondaryLabel.setText((String)secondaryLabelText);
        return this;
    }

    private final String createTooltipText(String tagName, String primaryLabelText, String secondaryLabelText) {
        return StringsKt.trimIndent((String)("\n    <html>\n        " + StringsKt.substringAfterLast((String)tagName, (char)'.', (String)tagName) + "<br/>\n        " + this.getHiddenText(primaryLabelText, secondaryLabelText) + "\n    </html>\n    "));
    }

    private final String getHiddenText(String primaryLabelText, String secondaryLabelText) {
        Object tooltip;
        Object object;
        if (Intrinsics.areEqual((Object)this.primaryLabel.getText(), (Object)primaryLabelText) ^ true) {
            String string2 = this.primaryLabel.getText();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"primaryLabel.text");
        } else {
            object = tooltip = "";
        }
        if (Intrinsics.areEqual((Object)this.secondaryLabel.getText(), (Object)secondaryLabelText) ^ true) {
            tooltip = (String)tooltip + " " + this.secondaryLabel.getText();
        }
        return tooltip;
    }

    private final int getLeftOffset(JTree tree, TreePath path) {
        TreeUI treeUI = tree.getUI();
        if (treeUI == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.plaf.basic.BasicTreeUI");
        }
        BasicTreeUI ui = (BasicTreeUI)treeUI;
        TreePath treePath = path;
        int depth = treePath != null ? treePath.getPathCount() : 1;
        return (ui.getLeftChildIndent() + ui.getRightChildIndent()) * depth;
    }

    private final int computeAvailableSpace(int row, Icon icon2, int cellWidth) {
        Icon icon3 = icon2;
        return cellWidth - this.primaryLabel.getIconTextGap() - this.myBadgeHandler.getTotalBadgeWidth(row) - (icon3 != null ? icon3.getIconWidth() : 0);
    }

    /*
     * WARNING - void declaration
     */
    public NlTreeCellRenderer(@NotNull NlTreeBadgeHandler myBadgeHandler) {
        void $this$apply;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)myBadgeHandler, (String)"myBadgeHandler");
        super(new FlowLayout(0, 0, JBUI.scale((int)2)));
        this.myBadgeHandler = myBadgeHandler;
        this.primaryLabel = new JLabel();
        JLabel jLabel2 = jLabel = new JLabel();
        NlTreeCellRenderer nlTreeCellRenderer = this;
        boolean bl = false;
        $this$apply.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        $this$apply.setForeground(UIUtil.getInactiveTextColor());
        $this$apply.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        Unit unit = Unit.INSTANCE;
        nlTreeCellRenderer.secondaryLabel = jLabel;
        this.primaryLabelMetrics = this.primaryLabel.getFontMetrics(this.primaryLabel.getFont());
        this.secondaryLabelMetrics = this.secondaryLabel.getFontMetrics(this.secondaryLabel.getFont());
        this.nlComponentFont = this.primaryLabel.getFont();
        this.otherFont = this.primaryLabel.getFont().deriveFont(2);
        this.setAlignmentY(0.5f);
        this.add(this.primaryLabel);
        this.add(this.secondaryLabel);
    }
}

