/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.utils.SparseIntArray;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.LightweightHint;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTreeBadgeHandler {
    private static final int BADGE_MARGIN = 5;
    private static final int BADGE_ICON = 0;
    private static final int LOCK_ICON = 1;
    private static final String TOGGLE_LOCK_MESSAGE = "Toggle Tool Locking";
    private final BadgeMouseMotionListener myBadgeMouseMotionListener = new BadgeMouseMotionListener();
    @Nullable
    private LightweightHint myTooltipHint;
    @Nullable
    private TreePath myHoveredPath;
    private int myHoveredIcon = 0;
    private NlComponent myHoveredComponent;
    @Nullable
    private NlModel myNlModel;
    private int myBadgeX;
    private int myLockIconX;
    @Nullable
    private IssuePanel myIssuePanel;
    @Nullable
    private IssueModel myIssueModel;
    private final SparseIntArray myBadgeWidthForRows = new SparseIntArray();

    public void setNlModel(@Nullable NlModel nlModel) {
        this.myNlModel = nlModel;
    }

    public void setIssuePanel(@Nullable IssuePanel issuePanel) {
        this.myIssuePanel = issuePanel;
    }

    public void setIssueModel(@Nullable IssueModel issueModel) {
        this.myIssueModel = issueModel;
    }

    public void paintBadges(@NotNull Graphics2D g, @NotNull NlComponentTree tree) {
        if (g == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(1);
        }
        this.myBadgeX = Integer.MAX_VALUE;
        this.myBadgeWidthForRows.clear();
        if (this.myNlModel == null) {
            return;
        }
        for (int i = 0; i < tree.getRowCount(); ++i) {
            TreePath path = tree.getPathForRow(i);
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) continue;
            NlComponent component = (NlComponent)last;
            Rectangle pathBounds = tree.getPathBounds(path);
            Issue issue = null;
            if (this.myIssueModel != null) {
                issue = this.myIssueModel.getHighestSeverityIssue(component);
            }
            if (pathBounds == null) continue;
            int y = pathBounds.y + pathBounds.height / 2;
            Icon firstIcon = null;
            if (issue == null || (firstIcon = IssueModel.getIssueIcon(issue.getSeverity(), tree.isRowSelected(i) && tree.hasFocus())) == null) continue;
            int x = tree.getWidth() - firstIcon.getIconWidth() - 5;
            int iy = y - firstIcon.getIconHeight() / 2;
            firstIcon.paintIcon((Component)((Object)tree), g, x, iy);
            this.myBadgeWidthForRows.put(i, firstIcon.getIconWidth());
            this.myBadgeX = Math.min(x, this.myBadgeX);
        }
    }

    @Nullable
    private String getIssueMessage(@NotNull TreePath path) {
        Object last;
        if (path == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(2);
        }
        if (!((last = path.getLastPathComponent()) instanceof NlComponent)) {
            return null;
        }
        NlComponent component = (NlComponent)last;
        Issue max = null;
        if (this.myIssueModel != null) {
            max = this.myIssueModel.getHighestSeverityIssue(component);
        }
        if (max != null) {
            return "<html>" + max.getSummary() + "<br>Click the badge for detail.</html>";
        }
        return null;
    }

    @NotNull
    public MouseAdapter getBadgeMouseAdapter() {
        BadgeMouseMotionListener badgeMouseMotionListener = this.myBadgeMouseMotionListener;
        if (badgeMouseMotionListener == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(3);
        }
        return badgeMouseMotionListener;
    }

    public int getTotalBadgeWidth(int row) {
        return this.myBadgeWidthForRows.get(row, 0) + 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBadgeMouseAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintBadges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIssueMessage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class BadgeMouseMotionListener
    extends MouseAdapter {
        private BadgeMouseMotionListener() {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
                NlTreeBadgeHandler.this.myTooltipHint = null;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = null;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            if (event == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(0);
            }
            JTree tree = (JTree)event.getSource();
            this.handleShowBadge(event, tree);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            this.handleMouseClicked(event, (JTree)event.getSource());
        }

        private void handleMouseClicked(MouseEvent event, JTree tree) {
            Rectangle bounds2;
            int limit = NlTreeBadgeHandler.this.myBadgeX;
            if (event.getX() < limit || NlTreeBadgeHandler.this.myIssuePanel == null) {
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds2 = tree.getPathBounds(path)) == null || event.getY() < bounds2.y || event.getY() > bounds2.y + bounds2.height) {
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlComponent component = (NlComponent)last;
            if (event.getX() > NlTreeBadgeHandler.this.myBadgeX) {
                if (((Boolean)StudioFlags.NELE_SHOW_ISSUE_PANEL_IN_PROBLEMS.get()).booleanValue()) {
                    IssuePanelService service = IssuePanelService.getInstance(component.getModel().getProject());
                    if (service == null) {
                        Logger.getInstance(NlTreeBadgeHandler.class).warn("Cannot find issue panel service");
                        return;
                    }
                    service.showCurrentFileAndQualifierTab();
                    service.attachIssueModel(NlTreeBadgeHandler.this.myIssueModel, NlTreeBadgeHandler.this.myNlModel.getVirtualFile());
                }
                NlTreeBadgeHandler.this.myIssuePanel.showIssueForComponent(component, true);
            }
        }

        private void toggleLocking(@NotNull NlComponent component) {
            if (component == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(1);
            }
            boolean isLocked = SceneManager.isComponentLocked(component);
            if (component.getParent() == null) {
                return;
            }
            NlWriteCommandActionUtil.run(component, "", () -> component.setAttribute("http://schemas.android.com/tools", "locked", isLocked ? null : "true"));
        }

        private void handleShowBadge(@NotNull MouseEvent event, @NotNull JTree tree) {
            Rectangle bounds2;
            if (event == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(2);
            }
            if (tree == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(3);
            }
            if (event.getX() < NlTreeBadgeHandler.this.myBadgeX) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds2 = tree.getPathBounds(path)) == null || event.getY() < bounds2.y || event.getY() > bounds2.y + bounds2.height) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = (NlComponent)last;
            boolean badgeIcon = true;
            if (NlTreeBadgeHandler.this.myHoveredPath == path) {
                if (badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 0) {
                    return;
                }
                if (!badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 1) {
                    return;
                }
            }
            NlTreeBadgeHandler.this.myHoveredPath = path;
            String message = null;
            if (badgeIcon) {
                message = NlTreeBadgeHandler.this.getIssueMessage(NlTreeBadgeHandler.this.myHoveredPath);
                NlTreeBadgeHandler.this.myHoveredIcon = 0;
            }
            if (message != null) {
                tree.setToolTipText(message);
            }
        }

        private void hideTooltip() {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler$BadgeMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toggleLocking";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleShowBadge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

