/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NlComponentTreeModel
implements TreeModel {
    private final NlComponent myRoot;

    NlComponentTreeModel() {
        this.myRoot = null;
    }

    NlComponentTreeModel(@NotNull NlModel model2) {
        if (model2 == null) {
            NlComponentTreeModel.$$$reportNull$$$0(0);
        }
        ImmutableList<NlComponent> components = model2.getComponents();
        this.myRoot = components.isEmpty() ? null : (NlComponent)components.get(0);
    }

    @Override
    @Nullable
    public Object getRoot() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public Object getChild(@NotNull Object parent, int i) {
        int count;
        if (parent == null) {
            NlComponentTreeModel.$$$reportNull$$$0(1);
        }
        if (!(parent instanceof NlComponent)) {
            throw new IllegalArgumentException(String.format(Locale.US, "Parent can only be an NlComponent but is %s.", parent.toString()));
        }
        NlComponent component = (NlComponent)parent;
        ViewGroupHandler handler = NlComponentHelperKt.getViewGroupHandler(component);
        int n = count = handler == null ? ((NlComponent)parent).getChildCount() : handler.getComponentTreeChildCount(component);
        if (i < 0 || i >= count) {
            Logger.getInstance(NlComponentTreeModel.class).error(String.format(Locale.US, "Index out of bounds for NlComponent.getChild. Index %d,  Parent: %s", i, ((NlComponent)parent).getTagName()));
            return "";
        }
        Object object = handler == null ? component.getChild(i) : handler.getComponentTreeChild(component, i);
        return object != null ? object : "";
    }

    @Override
    public int getChildCount(@NotNull Object parent) {
        if (parent == null) {
            NlComponentTreeModel.$$$reportNull$$$0(2);
        }
        if (parent instanceof NlComponent) {
            NlComponent component = (NlComponent)parent;
            ViewGroupHandler handler = NlComponentHelperKt.getViewGroupHandler(component);
            if (handler != null) {
                return handler.getComponentTreeChildCount(component);
            }
            return component.getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(@NotNull Object node) {
        if (node == null) {
            NlComponentTreeModel.$$$reportNull$$$0(3);
        }
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(@Nullable TreePath path, @Nullable Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexOfChild(@NotNull Object parent, @NotNull Object child) {
        if (parent == null) {
            NlComponentTreeModel.$$$reportNull$$$0(4);
        }
        if (child == null) {
            NlComponentTreeModel.$$$reportNull$$$0(5);
        }
        return ((NlComponent)parent).getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(@Nullable TreeModelListener listener2) {
    }

    @Override
    public void removeTreeModelListener(@Nullable TreeModelListener listener2) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlComponentTreeModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildCount";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLeaf";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexOfChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

