/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.Scout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ScoutChainsArrange {
    private List<NlComponent> myChain = new ArrayList<NlComponent>();
    private boolean myVertical = false;
    private String attr_a_to_a = this.myVertical ? "layout_constraintTop_toTopOf" : "layout_constraintStart_toStartOf";
    private String attr_a_to_b = this.myVertical ? "layout_constraintTop_toBottomOf" : "layout_constraintStart_toEndOf";
    private String attr_b_to_a = this.myVertical ? "layout_constraintBottom_toTopOf" : "layout_constraintEnd_toStartOf";
    private String attr_b_to_b = this.myVertical ? "layout_constraintBottom_toBottomOf" : "layout_constraintEnd_toEndOf";
    private String myHeadType;
    private String myTailType;
    private String myHeadID;
    private String myTailID;

    private void setVertical(boolean vertical) {
        this.myVertical = vertical;
        this.attr_a_to_a = this.myVertical ? "layout_constraintTop_toTopOf" : "layout_constraintStart_toStartOf";
        this.attr_a_to_b = this.myVertical ? "layout_constraintTop_toBottomOf" : "layout_constraintStart_toEndOf";
        this.attr_b_to_a = this.myVertical ? "layout_constraintBottom_toTopOf" : "layout_constraintEnd_toStartOf";
        this.attr_b_to_b = this.myVertical ? "layout_constraintBottom_toBottomOf" : "layout_constraintEnd_toEndOf";
    }

    private ScoutChainsArrange(NlComponent component, boolean vertical) {
        this.setVertical(vertical);
        this.setup(component);
    }

    private void setup(NlComponent component) {
        NlComponent c = this.getTopInChain(component);
        this.myChain.add(c);
        while (c != null) {
            String belowString = ScoutChainsArrange.getAttr(c, this.attr_b_to_a);
            if (belowString == null) {
                this.myTailType = this.attr_b_to_b;
                this.myTailID = ScoutChainsArrange.getAttr(c, this.attr_b_to_b);
                break;
            }
            NlComponent next_c = ScoutChainsArrange.get(c, this.attr_b_to_a);
            if (c != ScoutChainsArrange.get(next_c, this.attr_a_to_b)) {
                this.myTailType = this.attr_b_to_a;
                this.myTailID = belowString;
                break;
            }
            c = next_c;
            this.myChain.add(c);
        }
    }

    private NlComponent getTopInChain(NlComponent component) {
        NlComponent c = component;
        while (true) {
            String aboveString;
            if ((aboveString = ScoutChainsArrange.getAttr(c, this.attr_a_to_b)) == null) {
                this.myHeadID = ScoutChainsArrange.getAttr(c, this.attr_a_to_a);
                this.myHeadType = this.attr_a_to_a;
                return c;
            }
            NlComponent above = ScoutChainsArrange.getComponent(c, aboveString);
            if (c != ScoutChainsArrange.get(above, this.attr_b_to_a)) {
                this.myHeadType = this.attr_a_to_b;
                this.myHeadID = aboveString;
                return c;
            }
            c = above;
        }
    }

    private HashSet<AttributesTransaction> moveUp(NlComponent component) {
        int k = this.myChain.indexOf(component);
        if (k == 0) {
            return null;
        }
        HashSet<AttributesTransaction> transactions = this.removeComponent(component);
        transactions.addAll(this.insert(component, k - 1));
        return transactions;
    }

    private HashSet<AttributesTransaction> moveDown(NlComponent component) {
        int k = this.myChain.indexOf(component);
        if (k == this.myChain.size() - 1) {
            return null;
        }
        HashSet<AttributesTransaction> transactions = this.removeComponent(component);
        transactions.addAll(this.insert(component, k + 1));
        return transactions;
    }

    private HashSet<AttributesTransaction> insert(NlComponent component, int i) {
        HashSet<AttributesTransaction> transactions = new HashSet<AttributesTransaction>();
        if (i == 0) {
            String previousConnectString;
            NlComponent after = this.myChain.get(i);
            String previousIdString = ScoutChainsArrange.getAttr(after, previousConnectString = this.attr_a_to_b);
            if (previousIdString == null) {
                previousConnectString = this.attr_a_to_a;
                previousIdString = ScoutChainsArrange.getAttr(after, previousConnectString);
            }
            transactions.add(ScoutChainsArrange.connect(component, previousConnectString, previousIdString));
            transactions.add(ScoutChainsArrange.connect(component, this.attr_b_to_a, after));
            transactions.add(ScoutChainsArrange.connect(after, this.attr_a_to_b, component));
            if (this.attr_a_to_b != previousConnectString) {
                transactions.add(ScoutChainsArrange.disconnect(after, previousConnectString));
            }
        } else if (i == this.myChain.size()) {
            String nextConnectString;
            NlComponent before = this.myChain.get(i - 1);
            String nextIdString = ScoutChainsArrange.getAttr(before, nextConnectString = this.attr_b_to_a);
            if (nextIdString == null) {
                nextConnectString = this.attr_b_to_b;
                nextIdString = ScoutChainsArrange.getAttr(before, nextConnectString);
            }
            transactions.add(ScoutChainsArrange.connect(component, nextConnectString, nextIdString));
            transactions.add(ScoutChainsArrange.connect(before, this.attr_b_to_a, component));
            transactions.add(ScoutChainsArrange.connect(component, this.attr_a_to_b, before));
            if (this.attr_b_to_a != nextConnectString) {
                transactions.add(ScoutChainsArrange.disconnect(before, nextConnectString));
            }
        } else {
            String nextConnectString;
            NlComponent before = this.myChain.get(i - 1);
            String nextIdString = ScoutChainsArrange.getAttr(before, nextConnectString = this.attr_b_to_a);
            if (nextIdString == null) {
                nextConnectString = this.attr_b_to_b;
                nextIdString = ScoutChainsArrange.getAttr(before, nextConnectString);
            }
            transactions.add(ScoutChainsArrange.connect(component, nextConnectString, nextIdString));
            transactions.add(ScoutChainsArrange.connect(before, this.attr_b_to_a, component));
            NlComponent after = this.myChain.get(i);
            String previousConnectString = this.attr_a_to_b;
            String previousIdString = ScoutChainsArrange.getAttr(after, previousConnectString);
            if (previousIdString == null) {
                previousConnectString = this.attr_a_to_a;
                previousIdString = ScoutChainsArrange.getAttr(after, previousConnectString);
            }
            transactions.add(ScoutChainsArrange.connect(component, previousConnectString, previousIdString));
            transactions.add(ScoutChainsArrange.connect(after, this.attr_a_to_b, component));
        }
        return transactions;
    }

    private HashSet<AttributesTransaction> removeComponent(NlComponent component) {
        String nextConnectString;
        String nextIdString;
        HashSet<AttributesTransaction> transactions = new HashSet<AttributesTransaction>();
        int k = this.myChain.indexOf(component);
        String previousConnectString = this.attr_a_to_b;
        String previousIdString = ScoutChainsArrange.getAttr(component, previousConnectString);
        if (previousIdString == null) {
            previousConnectString = this.attr_a_to_a;
            previousIdString = ScoutChainsArrange.getAttr(component, previousConnectString);
        }
        if ((nextIdString = ScoutChainsArrange.getAttr(component, nextConnectString = this.attr_b_to_a)) == null) {
            nextConnectString = this.attr_b_to_b;
            nextIdString = ScoutChainsArrange.getAttr(component, nextConnectString);
        }
        if (k > 0) {
            NlComponent before = this.myChain.get(k - 1);
            transactions.add(ScoutChainsArrange.connect(before, nextConnectString, nextIdString));
            transactions.add(ScoutChainsArrange.disconnect(before, this.myVertical, nextConnectString == this.attr_b_to_b ? this.attr_b_to_a : this.attr_b_to_b));
        }
        if (k + 1 < this.myChain.size()) {
            NlComponent after = this.myChain.get(k + 1);
            transactions.add(ScoutChainsArrange.connect(after, previousConnectString, previousIdString));
            transactions.add(ScoutChainsArrange.disconnect(after, this.myVertical, previousConnectString == this.attr_a_to_a ? this.attr_a_to_b : this.attr_a_to_a));
        }
        transactions.add(ScoutChainsArrange.disconnect(component, this.myVertical, this.attr_a_to_a, this.attr_a_to_b, this.attr_b_to_a, this.attr_b_to_b));
        this.myChain.remove(component);
        return transactions;
    }

    public static void change(Scout.Arrange type, List<NlComponent> widgets) {
        if (widgets.isEmpty()) {
            return;
        }
        switch (type) {
            case ChainVerticalRemove: {
                ScoutChainsArrange.chainRemove(widgets, true);
                break;
            }
            case ChainHorizontalRemove: {
                ScoutChainsArrange.chainRemove(widgets, false);
                break;
            }
            case ChainVerticalMoveUp: {
                ScoutChainsArrange.chainMoveUp(widgets, true);
                break;
            }
            case ChainVerticalMoveDown: {
                ScoutChainsArrange.chainMoveDown(widgets, true);
                break;
            }
            case ChainHorizontalMoveLeft: {
                ScoutChainsArrange.chainMoveUp(widgets, false);
                break;
            }
            case ChainHorizontalMoveRight: {
                ScoutChainsArrange.chainMoveDown(widgets, false);
                break;
            }
            case ChainInsertHorizontal: {
                ScoutChainsArrange.insertInChain(widgets.get(0), false);
                break;
            }
            case ChainInsertVertical: {
                ScoutChainsArrange.insertInChain(widgets.get(0), true);
                break;
            }
        }
    }

    private static void insertInChain(NlComponent component, boolean vertical) {
        NlComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        List<NlComponent> children = parent.getChildren();
        int distSqr = Integer.MAX_VALUE;
        if (ScoutChainsArrange.isInChain(component, vertical)) {
            return;
        }
        NlComponent minChild = null;
        int centerX = ScoutChainsArrange.anchorPosX(component, Direction.TOP);
        int centerY = ScoutChainsArrange.anchorPosY(component, Direction.LEFT);
        for (NlComponent child : children) {
            if (!ScoutChainsArrange.isInChain(child, vertical)) continue;
            int d = ScoutChainsArrange.distance(child, centerX, centerY, vertical);
            if (distSqr > d) {
                distSqr = d;
                minChild = child;
            }
            distSqr = Math.min(distSqr, d);
        }
        boolean after = false;
        if (vertical) {
            if (centerY > ScoutChainsArrange.anchorPosY(minChild, Direction.LEFT)) {
                after = true;
            }
        } else if (centerX > ScoutChainsArrange.anchorPosX(minChild, Direction.LEFT)) {
            after = true;
        }
        if (minChild != null) {
            HashSet<AttributesTransaction> transactions = new HashSet<AttributesTransaction>();
            ScoutChainsArrange a = new ScoutChainsArrange(minChild, vertical);
            int pos = 0;
            for (int i = 0; i < a.myChain.size(); ++i) {
                if (a.myChain.get(i) != minChild) continue;
                pos = after ? i + 1 : i;
            }
            transactions.addAll(a.insert(component, pos));
            ScoutChainsArrange.commitAll(transactions, "Chain Move");
        }
    }

    public static boolean isInChain(List<NlComponent> list, boolean vertical) {
        if (vertical) {
            for (NlComponent component : list) {
                if (!ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, component) && !ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes, component)) continue;
                return true;
            }
        } else {
            for (NlComponent component : list) {
                if (!ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes, component) && !ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourEndAttributes, ConstraintComponentUtilities.ourStartAttributes, component)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInChain(NlComponent component, boolean vertical) {
        if (vertical) {
            return ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes, component);
        }
        return ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourEndAttributes, ConstraintComponentUtilities.ourStartAttributes, component);
    }

    private static boolean isTopInChain(NlComponent component, boolean vertical) {
        String attr_a_to_b = vertical ? "layout_constraintTop_toBottomOf" : "layout_constraintStart_toEndOf";
        String attr_b_to_a = vertical ? "layout_constraintBottom_toTopOf" : "layout_constraintEnd_toStartOf";
        String aboveString = ScoutChainsArrange.getAttr(component, attr_a_to_b);
        if (aboveString == null) {
            return true;
        }
        NlComponent above = ScoutChainsArrange.getComponent(component, aboveString);
        return component != ScoutChainsArrange.get(above, attr_b_to_a);
    }

    private static boolean isBottomInChain(NlComponent component, boolean vertical) {
        String attr_a_to_b = vertical ? "layout_constraintTop_toBottomOf" : "layout_constraintStart_toEndOf";
        String attr_b_to_a = vertical ? "layout_constraintBottom_toTopOf" : "layout_constraintEnd_toStartOf";
        String belowString = ScoutChainsArrange.getAttr(component, attr_b_to_a);
        if (belowString == null) {
            return true;
        }
        NlComponent above = ScoutChainsArrange.getComponent(component, belowString);
        return component != ScoutChainsArrange.get(above, attr_a_to_b);
    }

    public static boolean chainCheck(List<NlComponent> widgets, Scout.ChainTest test) {
        NlComponent component = widgets.get(0);
        switch (test) {
            case InVerticalChain: {
                return ScoutChainsArrange.isInChain(widgets, true);
            }
            case InHorizontalChain: {
                return ScoutChainsArrange.isInChain(widgets, false);
            }
            case IsTopOfChain: {
                if (ScoutChainsArrange.isInChain(component, true)) {
                    return ScoutChainsArrange.isTopInChain(component, true);
                }
                if (ScoutChainsArrange.isInChain(component, false)) {
                    return ScoutChainsArrange.isTopInChain(component, false);
                }
                return false;
            }
            case IsBottomOfChain: {
                if (ScoutChainsArrange.isInChain(component, true)) {
                    return ScoutChainsArrange.isBottomInChain(component, true);
                }
                if (ScoutChainsArrange.isInChain(component, false)) {
                    return ScoutChainsArrange.isBottomInChain(component, false);
                }
                return false;
            }
            case IsNearVerticalChain: {
                return ScoutChainsArrange.distanceToChain(widgets.get(0), true) < 2000;
            }
            case IsNearHorizontalChain: {
                return ScoutChainsArrange.distanceToChain(widgets.get(0), false) < 2000;
            }
        }
        return true;
    }

    private static int anchorPosX(NlComponent component, Direction dir) {
        switch (dir) {
            case TOP: 
            case BOTTOM: {
                return ConstraintComponentUtilities.getDpX(component) + ConstraintComponentUtilities.getDpWidth(component) / 2;
            }
            case LEFT: {
                return ConstraintComponentUtilities.getDpX(component);
            }
            case RIGHT: {
                return ConstraintComponentUtilities.getDpX(component) + ConstraintComponentUtilities.getDpWidth(component);
            }
        }
        return 0;
    }

    private static int anchorPosY(NlComponent component, Direction dir) {
        switch (dir) {
            case TOP: {
                return ConstraintComponentUtilities.getDpY(component);
            }
            case BOTTOM: {
                return ConstraintComponentUtilities.getDpY(component) + ConstraintComponentUtilities.getDpHeight(component);
            }
            case LEFT: 
            case RIGHT: {
                return ConstraintComponentUtilities.getDpY(component) + ConstraintComponentUtilities.getDpHeight(component) / 2;
            }
        }
        return 0;
    }

    public static int distance(NlComponent c, int x, int y, boolean vertical) {
        int dist;
        if (vertical) {
            int x1 = ScoutChainsArrange.anchorPosX(c, Direction.TOP);
            int y1 = ScoutChainsArrange.anchorPosY(c, Direction.TOP);
            dist = (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y);
            x1 = ScoutChainsArrange.anchorPosX(c, Direction.BOTTOM);
            y1 = ScoutChainsArrange.anchorPosY(c, Direction.BOTTOM);
            dist = Math.min(dist, (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y));
        } else {
            int x1 = ScoutChainsArrange.anchorPosX(c, Direction.LEFT);
            int y1 = ScoutChainsArrange.anchorPosY(c, Direction.LEFT);
            dist = (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y);
            x1 = ScoutChainsArrange.anchorPosX(c, Direction.RIGHT);
            y1 = ScoutChainsArrange.anchorPosY(c, Direction.RIGHT);
            dist = Math.min(dist, (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y));
        }
        return dist;
    }

    private static int distanceToChain(NlComponent component, boolean vertical) {
        NlComponent parent = component.getParent();
        if (parent == null) {
            return Integer.MAX_VALUE;
        }
        List<NlComponent> children = parent.getChildren();
        int distSqr = Integer.MAX_VALUE;
        if (ScoutChainsArrange.isInChain(component, vertical)) {
            return distSqr;
        }
        int centerX = ScoutChainsArrange.anchorPosX(component, Direction.TOP);
        int centerY = ScoutChainsArrange.anchorPosY(component, Direction.LEFT);
        for (NlComponent child : children) {
            if (!ScoutChainsArrange.isInChain(child, vertical)) continue;
            int d = ScoutChainsArrange.distance(child, centerX, centerY, vertical);
            distSqr = Math.min(distSqr, d);
        }
        return distSqr;
    }

    private static void chainMoveDown(List<NlComponent> components, boolean vertical) {
        HashSet<AttributesTransaction> transactions = new HashSet<AttributesTransaction>();
        for (NlComponent component : components) {
            ScoutChainsArrange a = new ScoutChainsArrange(component, vertical);
            transactions.addAll(a.moveDown(component));
        }
        if (transactions.isEmpty()) {
            return;
        }
        ScoutChainsArrange.commitAll(transactions, "Chain Move");
    }

    private static void chainMoveUp(List<NlComponent> components, boolean vertical) {
        HashSet<AttributesTransaction> transactions = new HashSet<AttributesTransaction>();
        for (NlComponent component : components) {
            ScoutChainsArrange a = new ScoutChainsArrange(component, vertical);
            transactions.addAll(a.moveUp(component));
        }
        if (transactions.isEmpty()) {
            return;
        }
        ScoutChainsArrange.commitAll(transactions, "Chain Move");
    }

    private static void chainRemove(List<NlComponent> components, boolean vertical) {
        HashSet<AttributesTransaction> transactions = new HashSet<AttributesTransaction>();
        for (NlComponent component : components) {
            ScoutChainsArrange a = new ScoutChainsArrange(component, vertical);
            transactions.addAll(a.removeComponent(component));
        }
        ScoutChainsArrange.commitAll(transactions, "Chain Move");
    }

    private static void commitAll(@NotNull Collection<AttributesTransaction> transactions, @NotNull String name) {
        if (transactions == null) {
            ScoutChainsArrange.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ScoutChainsArrange.$$$reportNull$$$0(1);
        }
        List<NlComponent> components = transactions.stream().map(AttributesTransaction::getComponent).collect(Collectors.toList());
        NlWriteCommandActionUtil.run(components, name, () -> transactions.forEach(AttributesTransaction::commit));
    }

    private static AttributesTransaction connect(NlComponent component, String dir, String to) {
        AttributesTransaction trans = component.startAttributeTransaction();
        trans.setAttribute("http://schemas.android.com/apk/res-auto", dir, to);
        trans.apply();
        return trans;
    }

    private static AttributesTransaction disconnect(NlComponent component, String dir) {
        AttributesTransaction trans = component.startAttributeTransaction();
        trans.removeAttribute("http://schemas.android.com/apk/res-auto", dir);
        trans.apply();
        return trans;
    }

    private static AttributesTransaction connect(NlComponent component, String dir, NlComponent to) {
        AttributesTransaction trans = component.startAttributeTransaction();
        trans.setAttribute("http://schemas.android.com/apk/res-auto", dir, "@+id/" + to.getId());
        trans.apply();
        return trans;
    }

    private static AttributesTransaction disconnect(NlComponent component, boolean vertical, String ... dir) {
        AttributesTransaction transaction = component.startAttributeTransaction();
        for (String aDir : dir) {
            transaction.removeAttribute("http://schemas.android.com/apk/res-auto", aDir);
        }
        if (vertical) {
            int offsetY = Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getY(component) - (component.isRoot() ? 0 : NlComponentHelperKt.getY(component.getParent())));
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
        } else {
            int offsetX = Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getX(component) - (component.isRoot() ? 0 : NlComponentHelperKt.getX(component.getParent())));
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        }
        transaction.apply();
        return transaction;
    }

    private static String getAttr(NlComponent component, String dir) {
        return component.getLiveAttribute("http://schemas.android.com/apk/res-auto", dir);
    }

    private static NlComponent getComponent(NlComponent component, String idString) {
        NlComponent parent;
        if (idString == null) {
            return null;
        }
        if (idString.equalsIgnoreCase("parent")) {
            return component.getParent();
        }
        String id2 = NlComponent.extractId(idString);
        if (id2 == null) {
            System.out.println("id == null for " + idString);
        }
        if ((parent = component.getParent()) == null) {
            return null;
        }
        if (id2.equals(parent.getId())) {
            return parent;
        }
        List<NlComponent> list = parent.getChildren();
        return ConstraintComponentUtilities.getComponent(list, id2);
    }

    private static NlComponent get(NlComponent component, String attr2) {
        String attribute = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", attr2);
        if (attribute == null) {
            return null;
        }
        if (attribute.equalsIgnoreCase("parent")) {
            return component.getParent();
        }
        String id2 = NlComponent.extractId(attribute);
        NlComponent parent = component.getParent();
        if (parent == null) {
            return null;
        }
        if (id2.equals(parent.getId())) {
            return parent;
        }
        List<NlComponent> list = parent.getChildren();
        return ConstraintComponentUtilities.getComponent(list, id2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "transactions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/scout/ScoutChainsArrange";
        objectArray[2] = "commitAll";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

