/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scout.ConstraintSet;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutChainsArrange;
import com.android.tools.idea.uibuilder.scout.ScoutConnectArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scout {
    public static final int DEFAULT_MARGIN = 0;
    private static final String[] ourAttrsToDelete = new String[]{"padding", "paddingLeft", "paddingRight", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom", "orientation"};
    private static int sMargin = 0;
    @Nullable
    private static String sMarginResource = null;

    public static int getMargin() {
        return sMargin;
    }

    public static void setMargin(int margin) {
        sMargin = margin;
    }

    public static void setMarginResource(String marginResource) {
        sMarginResource = marginResource;
    }

    @Nullable
    public static String getMarginResource() {
        return sMarginResource;
    }

    public static void arrangeWidgets(Arrange type, List<NlComponent> widgets, boolean applyConstraint) {
        switch (type) {
            case ChainVerticalRemove: 
            case ChainHorizontalRemove: 
            case ChainVerticalMoveUp: 
            case ChainVerticalMoveDown: 
            case ChainHorizontalMoveLeft: 
            case ChainHorizontalMoveRight: 
            case ChainInsertHorizontal: 
            case ChainInsertVertical: {
                ScoutChainsArrange.change(type, widgets);
                return;
            }
        }
        ScoutArrange.align(type, widgets, applyConstraint);
    }

    public static void arrangeWidgetsAndCommit(Arrange type, List<NlComponent> widgets, boolean applyConstraints) {
        Scout.arrangeWidgets(type, widgets, applyConstraints);
        Scout.commit(widgets, "Arrange Widgets");
    }

    public static void connect(List<NlComponent> widgets, Connect action2, boolean reverse, boolean margin) {
        ScoutConnectArrange.connect(widgets, action2, reverse, margin);
        Scout.commit(widgets, "connect Widgets");
    }

    public static boolean connectCheck(List<NlComponent> widgets, Connect test, boolean reverse) {
        return ScoutConnectArrange.connectCheck(widgets, test, reverse);
    }

    public static boolean chainCheck(List<NlComponent> widgets, ChainTest test) {
        return ScoutChainsArrange.chainCheck(widgets, test);
    }

    public static boolean containsOverlap(NlComponent root) {
        if (root == null) {
            return false;
        }
        if (root.getChildCount() == 0) {
            return false;
        }
        List<NlComponent> list = root.getChildren();
        int count = 0;
        Rectangle[] rec = new Rectangle[list.size()];
        for (NlComponent component : list) {
            rec[count] = new Rectangle();
            rec[count].x = ConstraintComponentUtilities.getDpX(component);
            rec[count].y = ConstraintComponentUtilities.getDpY(component);
            rec[count].width = ConstraintComponentUtilities.getDpWidth(component);
            rec[count].height = ConstraintComponentUtilities.getDpHeight(component);
            ++count;
        }
        for (int i = 0; i < rec.length; ++i) {
            Rectangle rectangle1 = rec[i];
            for (int j = i + 1; j < rec.length; ++j) {
                Rectangle rectangle2 = rec[j];
                if (!rectangle1.intersects(rectangle2)) continue;
                Rectangle r = rectangle1.intersection(rectangle2);
                if (r.width <= 2 || r.height <= 2) continue;
                return true;
            }
        }
        return false;
    }

    public static void inferConstraintsFromConvert(NlComponent root) {
        Scout.inferConstraints(root, true, true);
    }

    public static void inferConstraints(NlComponent root) {
        Scout.inferConstraints(root, true, false);
    }

    private static void inferConstraints(NlComponent root, boolean rejectOverlaps, boolean fromConvert) {
        if (root == null) {
            return;
        }
        for (NlComponent child : root.getChildren()) {
            child.ensureId();
        }
        if (!ConstraintComponentUtilities.isConstraintLayout(root)) {
            return;
        }
        if (rejectOverlaps && Scout.containsOverlap(root)) {
            System.err.println("containsOverlap!");
            return;
        }
        for (NlComponent constraintWidget : root.getChildren()) {
            if (!ConstraintComponentUtilities.isConstraintLayout(constraintWidget) || constraintWidget.getChildren().isEmpty()) continue;
            Scout.inferConstraints(constraintWidget);
        }
        ArrayList<NlComponent> list = new ArrayList<NlComponent>(root.getChildren());
        list.add(0, root);
        if (list.size() == 1) {
            return;
        }
        NlComponent[] widgets = list.toArray(new NlComponent[list.size()]);
        ScoutWidget[] scoutWidgets = ScoutWidget.create(widgets, fromConvert);
        ScoutWidget.computeConstraints(scoutWidgets);
        if (fromConvert) {
            Scout.postInferCleanupFromConvert(scoutWidgets);
        }
    }

    private static void postInferCleanupFromConvert(ScoutWidget[] widgets) {
        int i;
        for (i = 0; i < ourAttrsToDelete.length; ++i) {
            widgets[0].mNlComponent.setAttribute("http://schemas.android.com/apk/res/android", ourAttrsToDelete[i], null);
        }
        for (i = 1; i < widgets.length; ++i) {
            ScoutWidget widget = widgets[i];
            if (!(!widget.isCandidateResizable(0) || widget.isConnected(Direction.TOP) && widget.isConnected(Direction.BOTTOM))) {
                widget.setVerticalDimensionBehaviour(ScoutWidget.DimensionBehaviour.FIXED);
            }
            if (!widget.isCandidateResizable(1) || widget.isConnected(Direction.LEFT) && widget.isConnected(Direction.RIGHT)) continue;
            widget.setHorizontalDimensionBehaviour(ScoutWidget.DimensionBehaviour.FIXED);
        }
    }

    public static void inferConstraintsAndCommit(List<NlComponent> components) {
        for (NlComponent component : components) {
            if (component.getParent() != null) continue;
            Scout.inferConstraintsAndCommit(component);
            return;
        }
    }

    public static void inferConstraintsAndCommit(NlComponent component) {
        Scout.inferConstraints(component, false, false);
        ArrayList<NlComponent> list = new ArrayList<NlComponent>(component.getChildren());
        list.add(0, component);
        Scout.commit(list, "Infering constraints");
        Scout.evalResult(component);
    }

    public static void evalResult(NlComponent component) {
        ArrayList<NlComponent> list = new ArrayList<NlComponent>(component.getChildren());
        list.add(0, component);
        NlComponent[] widgets = list.toArray(new NlComponent[list.size()]);
        ScoutWidget[] scoutWidgets = ScoutWidget.create(widgets, false);
        ConstraintSet constraintSet = new ConstraintSet(scoutWidgets);
        if (constraintSet.validate()) {
            constraintSet.calculateError();
            System.out.println("Error in set (v1): " + Double.toString(constraintSet.error()));
        }
    }

    private static void commit(@NotNull List<NlComponent> list, String label) {
        if (list == null) {
            Scout.$$$reportNull$$$0(0);
        }
        if (list.isEmpty()) {
            return;
        }
        NlWriteCommandActionUtil.run(list, label, () -> list.forEach(component -> component.startAttributeTransaction().commit()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scout/Scout", "commit"));
    }

    public static enum ChainTest {
        InVerticalChain,
        InHorizontalChain,
        IsTopOfChain,
        IsBottomOfChain,
        IsNearVerticalChain,
        IsNearHorizontalChain;

    }

    public static enum Connect {
        ConnectTopToTop,
        ConnectTopToBottom,
        ConnectBottomToTop,
        ConnectBottomToBottom,
        ConnectStartToStart,
        ConnectStartToEnd,
        ConnectEndToStart,
        ConnectEndToEnd,
        ConnectBaseLineToBaseLine,
        ConnectToParentTop,
        ConnectToParentBottom,
        ConnectToParentStart,
        ConnectToParentEnd;


        public AnchorTarget.Type getDstAnchorType(boolean isRtl) {
            switch (this) {
                case ConnectTopToTop: 
                case ConnectBottomToTop: 
                case ConnectToParentTop: {
                    return AnchorTarget.Type.TOP;
                }
                case ConnectTopToBottom: 
                case ConnectBottomToBottom: 
                case ConnectToParentBottom: {
                    return AnchorTarget.Type.BOTTOM;
                }
                case ConnectStartToStart: 
                case ConnectEndToStart: 
                case ConnectToParentStart: {
                    return isRtl ? AnchorTarget.Type.RIGHT : AnchorTarget.Type.LEFT;
                }
                case ConnectStartToEnd: 
                case ConnectEndToEnd: 
                case ConnectToParentEnd: {
                    return isRtl ? AnchorTarget.Type.LEFT : AnchorTarget.Type.RIGHT;
                }
                case ConnectBaseLineToBaseLine: {
                    return AnchorTarget.Type.BASELINE;
                }
            }
            return null;
        }
    }

    public static enum Arrange {
        AlignVerticallyTop,
        AlignVerticallyMiddle,
        AlignVerticallyBottom,
        AlignHorizontallyLeft,
        AlignHorizontallyCenter,
        AlignHorizontallyRight,
        DistributeVertically,
        DistributeHorizontally,
        VerticalPack,
        HorizontalPack,
        ExpandVertically,
        AlignBaseline,
        ExpandHorizontally,
        CenterHorizontallyInParent,
        CenterVerticallyInParent,
        CenterVertically,
        CenterHorizontally,
        CreateHorizontalChain,
        CreateVerticalChain,
        ConnectTop,
        ConnectBottom,
        ConnectStart,
        ConnectEnd,
        ChainVerticalRemove,
        ChainHorizontalRemove,
        ChainVerticalMoveUp,
        ChainVerticalMoveDown,
        ChainHorizontalMoveLeft,
        ChainHorizontalMoveRight,
        ChainInsertHorizontal,
        ChainInsertVertical;

    }
}

