/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.common.scene.draw.DrawTextRegion;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class UnknownViewDecorator
extends SceneDecorator {
    private static final String DEFAULT_DIM = "14sp";

    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            UnknownViewDecorator.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            UnknownViewDecorator.$$$reportNull$$$0(1);
        }
        if (sceneComponent == null) {
            UnknownViewDecorator.$$$reportNull$$$0(2);
        }
        if (component.getChildCount() > 0) {
            return;
        }
        super.addContent(list, time, sceneContext, (SceneComponent)component);
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time, rect);
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        NlComponent nlComponent = component.getNlComponent();
        String text = nlComponent.getId();
        if (text == null) {
            text = nlComponent.getTagName();
            text = text.substring(text.lastIndexOf(46) + 1);
        }
        int size = DrawTextRegion.getFont(nlComponent, DEFAULT_DIM);
        list.add(new DrawUnknownDecorator(l, t, w, h, size, (float)sceneContext.getScale(), text));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/scene/decorator/UnknownViewDecorator";
        objectArray[2] = "addContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DrawUnknownDecorator
    extends DrawRegion {
        protected static final float SCALE_ADJUST = 0.88f;
        private String mText;
        private Font mFont;
        private float mSceneScale;
        private int mFontSize;

        DrawUnknownDecorator(int x, int y, int width, int height, int fontSize, float sceneScale, String text) {
            super(x, y, width, height);
            this.mText = text;
            this.mSceneScale = sceneScale;
            this.mFontSize = fontSize;
            this.mFont = new Font("Helvetica", 0, fontSize).deriveFont(AffineTransform.getScaleInstance(sceneScale * 0.88f, sceneScale * 0.88f));
        }

        @NotNull
        public static DrawUnknownDecorator createFromString(@NotNull String s) {
            if (s == null) {
                DrawUnknownDecorator.$$$reportNull$$$0(0);
            }
            String[] sp = s.split(",");
            int c = 0;
            int x = Integer.parseInt(sp[c++]);
            int y = Integer.parseInt(sp[c++]);
            int width = Integer.parseInt(sp[c++]);
            int height = Integer.parseInt(sp[c++]);
            int fontSize = Integer.parseInt(sp[c++]);
            float sceneScale = Float.parseFloat(sp[c++]);
            String text = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
            return new DrawUnknownDecorator(x, y, width, height, fontSize, sceneScale, text);
        }

        @Override
        public String serialize() {
            return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.mFontSize + "," + this.mSceneScale + ",\"" + this.mText + "\"";
        }

        @Override
        public int getLevel() {
            return 20;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            ColorSet colorSet = sceneContext.getColorSet();
            if (!colorSet.drawBackground()) {
                return;
            }
            g.setColor(sceneContext.getColorSet().getFrames());
            int stringWidth = g.getFontMetrics(this.mFont).stringWidth(this.mText);
            float scaleToFit = (float)this.width / ((float)stringWidth * 3.0f / 2.0f);
            scaleToFit = Math.min(scaleToFit, 1.0f);
            Font originalFont = g.getFont();
            g.setFont(this.mFont.deriveFont((float)this.mFont.getSize() * scaleToFit));
            FontMetrics fontMetrics = g.getFontMetrics();
            Rectangle2D textBounds = fontMetrics.getStringBounds(this.mText, g);
            g.drawString(this.mText, this.x + (int)(((double)this.width - textBounds.getWidth()) / 2.0), this.y + (int)((double)this.height - ((double)this.height - textBounds.getHeight()) / 2.0));
            g.setFont(originalFont);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/uibuilder/scene/decorator/UnknownViewDecorator$DrawUnknownDecorator", "createFromString"));
        }
    }
}

