/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.ViewInfoTagSnapshotNode;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModelHierarchyUpdater {
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;

    public static void updateHierarchy(@NotNull RenderResult result, @NotNull NlModel model2) {
        if (result == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(1);
        }
        NlModelHierarchyUpdater.updateHierarchy(NlModelHierarchyUpdater.getRootViews(result, model2.getType()), model2);
    }

    public static void updateHierarchy(@NotNull List<ViewInfo> views, @NotNull NlModel model2) {
        XmlTag root;
        if (views == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(2);
        }
        if (model2 == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(3);
        }
        if ((root = NlModelHierarchyUpdater.getRootTag(model2)) != null) {
            NlModelHierarchyUpdater.updateHierarchy(root, views, model2);
        }
    }

    public static void updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> views, @NotNull NlModel model2) {
        if (rootTag == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(4);
        }
        if (views == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(5);
        }
        if (model2 == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(6);
        }
        model2.syncWithPsi(rootTag, ContainerUtil.map(views, ViewInfoTagSnapshotNode::new));
        NlModelHierarchyUpdater.updateBounds(views, model2);
    }

    @NotNull
    public static List<ViewInfo> getRootViews(@NotNull RenderResult result, @NotNull DesignerEditorFileType type) {
        if (result == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(7);
        }
        if (type == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(8);
        }
        ImmutableList immutableList = type == MenuFileType.INSTANCE ? result.getSystemRootViews() : result.getRootViews();
        if (immutableList == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    @Nullable
    private static XmlTag getRootTag(@NotNull NlModel model2) {
        if (model2 == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(10);
        }
        if (Disposer.isDisposed((Disposable)model2)) {
            return null;
        }
        return AndroidPsiUtils.getRootTagSafely((XmlFile)model2.getFile());
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        if (rootViews == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(11);
        }
        if (model2 == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(12);
        }
        model2.flattenComponents().forEach(NlModelHierarchyUpdater::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getTagDeprecated, Function.identity()));
        for (ViewInfo view : rootViews) {
            NlModelHierarchyUpdater.updateBounds(view, 0, 0, snapshotToComponent, tagToComponent);
        }
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!rootViews.isEmpty() && !components.isEmpty()) {
            NlModelHierarchyUpdater.fixBounds((NlComponent)components.get(0));
        }
    }

    private static void updateBounds(@NotNull ViewInfo view, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent) {
        if (view == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(13);
        }
        ViewInfo bounds2 = RenderService.getSafeBounds((ViewInfo)view);
        Object cookie = view.getCookie();
        if (cookie != null && cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            NlComponent component = snapshotToComponent.get(snapshot);
            if (component == null) {
                component = tagToComponent.get(snapshot.tag);
            }
            if (component != null && NlComponentHelperKt.getViewInfo(component) == null) {
                NlComponentHelperKt.setViewInfo(component, view);
                int left = parentX + bounds2.getLeft();
                int top = parentY + bounds2.getTop();
                int width = bounds2.getRight() - bounds2.getLeft();
                int height = bounds2.getBottom() - bounds2.getTop();
                NlComponentHelperKt.setBounds(component, left, top, Math.max(width, 1), Math.max(height, 1));
            }
        }
        parentX += bounds2.getLeft();
        parentY += bounds2.getTop();
        for (ViewInfo child : view.getChildren()) {
            NlModelHierarchyUpdater.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent);
        }
    }

    private static void fixBounds(@NotNull NlComponent root) {
        List<NlComponent> children;
        if (root == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(14);
        }
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root) == -1 && NlComponentHelperKt.getH(root) == -1) {
            computeBounds = true;
            NlComponent parent = root.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if (!(children = root.getChildren()).isEmpty()) {
            for (NlComponent child : children) {
                NlModelHierarchyUpdater.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root), NlComponentHelperKt.getY(root), NlComponentHelperKt.getW(root), NlComponentHelperKt.getH(root));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void clearDerivedData(@NotNull NlComponent component) {
        if (component == null) {
            NlModelHierarchyUpdater.$$$reportNull$$$0(15);
        }
        NlComponentHelperKt.setBounds(component, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "views";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/NlModelHierarchyUpdater";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/NlModelHierarchyUpdater";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootViews";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRootTag";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateBounds";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fixBounds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearDerivedData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

