/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.resources.Density;
import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.DefaultSceneManagerHierarchyProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.LayoutScannerConfiguration;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.ExecuteCallbacksResult;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.TouchEventResult;
import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.tools.idea.uibuilder.menu.NavigationViewSceneView;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.DesignSurfaceProgressIndicator;
import com.android.tools.idea.uibuilder.scene.MergingRenderingQueue;
import com.android.tools.idea.uibuilder.scene.NlModelHierarchyUpdater;
import com.android.tools.idea.uibuilder.scene.RealTimeSessionClock;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.scene.RenderingQueue;
import com.android.tools.idea.uibuilder.scene.SessionClock;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneDecoratorFactory;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LayoutlibSceneManager
extends SceneManager {
    private static final SceneDecoratorFactory DECORATOR_FACTORY = new NlSceneDecoratorFactory();
    @VisibleForTesting
    public static final String[] INTERACTIVE_CLASSES_TO_PRELOAD = new String[]{"android.view.MotionEvent", "androidx.compose.ui.input.pointer.PointerId", "androidx.compose.ui.input.pointer.MotionEventAdapterKt", "android.view.MotionEvent$PointerCoords", "androidx.compose.ui.input.pointer.PointerType", "androidx.compose.ui.input.pointer.PointerInputEventData", "androidx.compose.ui.input.pointer.PointerInputEvent", "androidx.compose.ui.input.pointer.PointerInputChangeEventProducer$PointerInputData", "androidx.compose.ui.input.pointer.PointerInputChange", "androidx.compose.ui.input.pointer.ConsumedData", "androidx.compose.ui.input.pointer.InternalPointerEvent", "androidx.compose.ui.input.pointer.PointerEventKt", "androidx.compose.ui.input.pointer.Node", "androidx.compose.ui.input.pointer.HitPathTracker$CustomEventDispatcherImpl", "androidx.compose.ui.input.pointer.CustomEventDispatcher", "androidx.compose.ui.input.pointer.NodeParent$removeDetachedPointerInputFilters$1", "androidx.compose.ui.input.pointer.NodeParent$removeDetachedPointerInputFilters$2", "androidx.compose.ui.input.pointer.NodeParent$removeDetachedPointerInputFilters$3", "androidx.compose.ui.input.pointer.PointerEventPass", "androidx.compose.ui.input.pointer.PointerEvent", "androidx.compose.ui.gesture.GestureUtilsKt", "androidx.compose.ui.input.pointer.PointerInputEventProcessorKt", "androidx.compose.ui.input.pointer.ProcessResult", "androidx.compose.runtime.snapshots.SnapshotStateObserver$applyObserver$1$2", "androidx.compose.ui.platform.AndroidComposeViewKt$sam$java_lang_Runnable$0", "androidx.compose.runtime.Invalidation", "androidx.compose.runtime.InvalidationResult", "androidx.compose.runtime.Recomposer$runRecomposeAndApplyChanges$2$4", "androidx.compose.runtime.PausableMonotonicFrameClock$withFrameNanos$1", "androidx.compose.ui.platform.AndroidUiFrameClock$withFrameNanos$2$callback$1", "androidx.compose.ui.platform.AndroidUiFrameClock$withFrameNanos$2$1", "kotlinx.coroutines.InvokeOnCancel", "androidx.compose.runtime.ComposerImpl$updateValue$2", "androidx.compose.runtime.ComposerImpl$realizeOperationLocation$2", "androidx.compose.runtime.ComposerImpl$realizeDowns$1", "androidx.compose.runtime.ComposerImpl$realizeUps$1", "androidx.compose.ui.platform.JvmActualsKt", "kotlinx.coroutines.JobCancellationException", "kotlinx.coroutines.CopyableThrowable", "kotlinx.coroutines.DebugStringsKt", "androidx.compose.material.ElevationDefaults", "androidx.compose.animation.core.AnimationKt", "androidx.compose.animation.core.TargetBasedAnimation", "androidx.compose.animation.core.Animation", "androidx.compose.animation.core.VectorizedTweenSpec", "androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec", "androidx.compose.animation.core.VectorizedFiniteAnimationSpec", "androidx.compose.animation.core.VectorizedAnimationSpec", "androidx.compose.animation.core.VectorizedFloatAnimationSpec", "androidx.compose.animation.core.FloatTweenSpec", "androidx.compose.animation.core.FloatAnimationSpec", "androidx.compose.animation.core.VectorizedFloatAnimationSpec$1", "androidx.compose.animation.core.Animations", "androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec$DefaultImpls", "androidx.compose.animation.core.VectorizedFiniteAnimationSpec$DefaultImpls", "androidx.compose.animation.core.VectorizedAnimationSpec$DefaultImpls", "androidx.compose.animation.core.Animatable$runAnimation$2", "kotlin.jvm.internal.Ref$BooleanRef", "androidx.compose.animation.core.Animatable$runAnimation$2$1", "androidx.compose.animation.core.SuspendAnimationKt", "androidx.compose.animation.core.SuspendAnimationKt$animate$4", "androidx.compose.animation.core.Animation$DefaultImpls", "androidx.compose.animation.core.SuspendAnimationKt$animate$startTimeNanosSpecified$1", "androidx.compose.runtime.MonotonicFrameClockKt", "androidx.compose.runtime.BroadcastFrameClock$FrameAwaiter", "androidx.compose.runtime.BroadcastFrameClock$withFrameNanos$2$1", "androidx.compose.material.ripple.RippleAnimation", "androidx.compose.material.ripple.RippleIndicationInstance$addRipple$ripple$1", "androidx.compose.animation.core.AnimationVector2D", "androidx.compose.material.ripple.RippleAnimation$1", "kotlinx.collections.immutable.internal.ListImplementation", "androidx.compose.ui.graphics.ClipOp", "androidx.compose.ui.graphics.AndroidCanvas$WhenMappings", "androidx.compose.ui.graphics.PointMode", "android.graphics.Region$Op", "androidx.compose.ui.input.pointer.NodeParent$removePointerId$2", "androidx.compose.animation.core.AnimationScope", "androidx.compose.animation.core.SuspendAnimationKt$animate$6", "androidx.compose.animation.core.SuspendAnimationKt$animate$7", "androidx.compose.material.ripple.RippleAnimation$fadeIn$2", "androidx.compose.material.ripple.RippleAnimation$fadeIn$2$1", "androidx.compose.material.ripple.RippleAnimation$fadeIn$2$2", "androidx.compose.material.ripple.RippleAnimation$fadeIn$2$3", "kotlinx.coroutines.JobSupport$ChildCompletion", "androidx.compose.animation.core.AnimationSpecKt", "kotlinx.coroutines.internal.StackTraceRecoveryKt", "kotlin.coroutines.jvm.internal.BaseContinuationImpl", "kotlinx.coroutines.internal.StackTraceRecoveryKt", "kotlinx.coroutines.internal.ExceptionsConstuctorKt", "kotlin.jvm.JvmClassMappingKt", "kotlin.jvm.internal.ClassReference", "kotlin.jvm.internal.ClassReference$Companion", "kotlin.jvm.functions.Function12", "kotlin.jvm.functions.Function22", "java.util.concurrent.locks.ReentrantReadWriteLock", "java.util.ArrayDeque", "kotlin.coroutines.jvm.internal.DebugMetadataKt", "kotlin.coroutines.jvm.internal.DebugMetadata", "java.lang.annotation.Annotation", "kotlin.annotation.Target", "java.lang.annotation.Retention", "java.lang.annotation.RetentionPolicy", "java.lang.annotation.Target", "kotlin.Metadata", "java.lang.reflect.Proxy", "java.lang.reflect.UndeclaredThrowableException", "java.lang.NoSuchMethodError", "java.lang.NoClassDefFoundError", "java.lang.reflect.InvocationHandler", "kotlin.annotation.Retention", "kotlin.coroutines.jvm.internal.ModuleNameRetriever", "kotlin.coroutines.jvm.internal.ModuleNameRetriever$Cache", "java.lang.ClassLoader", "java.lang.Module", "java.lang.module.ModuleDescriptor", "kotlinx.coroutines.TimeoutCancellationException", "java.util.IdentityHashMap", "androidx.compose.animation.core.AnimationEndReason", "androidx.compose.animation.core.AnimationResult"};
    @Nullable
    private SceneView mySecondarySceneView;
    private int myDpi;
    private final SelectionChangeListener mySelectionChangeListener;
    private final ModelChangeListener myModelChangeListener;
    private final ConfigurationListener myConfigurationChangeListener;
    private final boolean myAreListenersRegistered;
    private final DesignSurfaceProgressIndicator myProgressIndicator;
    private final RenderingQueue myRenderingQueue;
    private RenderTask myRenderTask;
    private SessionClock mySessionClock;
    private final Supplier<SessionClock> mySessionClockFactory;
    private final Object myRenderingTaskLock;
    private ResourceNotificationManager.ResourceVersion myRenderedVersion;
    private final ReentrantReadWriteLock myRenderResultLock;
    @Nullable
    private RenderResult myRenderResult;
    private final AtomicInteger myConfigurationUpdatedFlags;
    private long myElapsedFrameTimeMs;
    private final Object myFuturesLock;
    private final LinkedList<CompletableFuture<Void>> myRenderFutures;
    private final LinkedList<CompletableFuture<Void>> myPendingFutures;
    private final Semaphore myUpdateHierarchyLock;
    @NotNull
    private final ViewEditor myViewEditor;
    private final ListenerCollection<RenderListener> myRenderListeners;
    @NotNull
    private final Executor myRenderTaskDisposerExecutor;
    private Boolean myIsCurrentlyRendering;
    private boolean useTransparentRendering;
    private boolean useShrinkRendering;
    private boolean myUsePrivateClassLoader;
    private boolean myListenResourceChange;
    private boolean useShowDecorations;
    private boolean myRerenderWhenModelDerivedDataChanged;
    private boolean myUpdateAndRenderWhenActivated;
    private boolean myIsInteractive;
    private boolean useImagePool;
    private boolean myLogRenderErrors;
    private float quality;
    private boolean reportOutOfDateUserClasses;
    private ClassTransform myAdditionalProjectTransform;
    private ClassTransform myAdditionalNonProjectTransform;
    @NotNull
    private Runnable myOnNewModuleClassLoader;
    private final AtomicBoolean myForceInflate;
    private final AtomicBoolean isDisposed;
    private AtomicInteger myTouchEventsCounter;
    @NotNull
    private final LayoutScannerConfiguration myLayoutScannerConfig;
    private static final EnumSet<NlModel.ChangeType> powerModeChangesNotTriggeringRefresh = EnumSet.of(NlModel.ChangeType.RESOURCE_CHANGED, NlModel.ChangeType.RESOURCE_EDIT);
    private final AtomicBoolean isOutOfDate;
    private static boolean ourRenderViewPort;

    protected static LayoutEditorRenderResult.Trigger getTriggerFromChangeType(@Nullable NlModel.ChangeType changeType) {
        if (changeType == null) {
            return null;
        }
        switch (changeType) {
            case RESOURCE_EDIT: 
            case RESOURCE_CHANGED: {
                return LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE;
            }
            case EDIT: 
            case ADD_COMPONENTS: 
            case DELETE: 
            case DND_COMMIT: 
            case DND_END: 
            case DROP: 
            case RESIZE_END: 
            case RESIZE_COMMIT: {
                return LayoutEditorRenderResult.Trigger.EDIT;
            }
            case BUILD: {
                return LayoutEditorRenderResult.Trigger.BUILD;
            }
        }
        return null;
    }

    protected LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, @NotNull Executor renderTaskDisposerExecutor, @NotNull Function<Disposable, RenderingQueue> renderingQueueFactory, @NotNull SceneManager.SceneComponentHierarchyProvider sceneComponentProvider, @Nullable SceneManager.SceneUpdateListener sceneUpdateListener, @NotNull LayoutScannerConfiguration layoutScannerConfig, @NotNull Supplier<SessionClock> sessionClockFactory) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(0);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(1);
        }
        if (renderTaskDisposerExecutor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(2);
        }
        if (renderingQueueFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(3);
        }
        if (sceneComponentProvider == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(4);
        }
        if (layoutScannerConfig == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(5);
        }
        if (sessionClockFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(6);
        }
        super(model2, designSurface, sceneComponentProvider, sceneUpdateListener);
        this.myDpi = 0;
        this.mySelectionChangeListener = new SelectionChangeListener();
        this.myModelChangeListener = new ModelChangeListener();
        this.myConfigurationChangeListener = new ConfigurationChangeListener();
        this.myRenderingTaskLock = new Object();
        this.myRenderResultLock = new ReentrantReadWriteLock();
        this.myConfigurationUpdatedFlags = new AtomicInteger(0);
        this.myElapsedFrameTimeMs = -1L;
        this.myFuturesLock = new Object();
        this.myRenderFutures = new LinkedList();
        this.myPendingFutures = new LinkedList();
        this.myUpdateHierarchyLock = new Semaphore(1);
        this.myRenderListeners = ListenerCollection.createWithDirectExecutor();
        this.myIsCurrentlyRendering = false;
        this.useTransparentRendering = false;
        this.useShrinkRendering = false;
        this.myUsePrivateClassLoader = false;
        this.myListenResourceChange = true;
        this.myRerenderWhenModelDerivedDataChanged = true;
        this.myUpdateAndRenderWhenActivated = true;
        this.useImagePool = true;
        this.myLogRenderErrors = true;
        this.quality = 1.0f;
        this.reportOutOfDateUserClasses = false;
        this.myAdditionalProjectTransform = ClassTransform.getIdentity();
        this.myAdditionalNonProjectTransform = ClassTransform.getIdentity();
        this.myOnNewModuleClassLoader = () -> {};
        this.myForceInflate = new AtomicBoolean(false);
        this.isDisposed = new AtomicBoolean(false);
        this.myTouchEventsCounter = new AtomicInteger(0);
        this.isOutOfDate = new AtomicBoolean(false);
        this.myProgressIndicator = new DesignSurfaceProgressIndicator(designSurface);
        this.myRenderTaskDisposerExecutor = renderTaskDisposerExecutor;
        this.myRenderingQueue = renderingQueueFactory.apply(this);
        this.mySessionClockFactory = sessionClockFactory;
        this.createSceneView();
        this.getDesignSurface().getSelectionModel().addListener(this.mySelectionChangeListener);
        Scene scene = this.getScene();
        this.myViewEditor = new ViewEditorImpl(model2, scene);
        model2.getConfiguration().addListener(this.myConfigurationChangeListener);
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!components.isEmpty()) {
            NlComponent rootComponent = ((NlComponent)components.get(0)).getRoot();
            boolean previous = this.getScene().isAnimated();
            scene.setAnimated(false);
            List<SceneComponent> hierarchy = sceneComponentProvider.createHierarchy(this, rootComponent);
            SceneComponent root = hierarchy.isEmpty() ? null : hierarchy.get(0);
            this.updateFromComponent(root, new HashSet<SceneComponent>());
            scene.setRoot(root);
            this.updateTargets();
            scene.setAnimated(previous);
        }
        model2.addListener(this.myModelChangeListener);
        this.myAreListenersRegistered = true;
        this.myLayoutScannerConfig = layoutScannerConfig;
        scene.selectionChanged(this.getDesignSurface().getSelectionModel(), this.getDesignSurface().getSelectionModel().getSelection());
    }

    public LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, @NotNull SceneManager.SceneComponentHierarchyProvider sceneComponentProvider, @NotNull SceneManager.SceneUpdateListener sceneUpdateListener, @NotNull Supplier<SessionClock> sessionClockFactory) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(7);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(8);
        }
        if (sceneComponentProvider == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(9);
        }
        if (sceneUpdateListener == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(10);
        }
        if (sessionClockFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(11);
        }
        this(model2, designSurface, AppExecutorUtil.getAppExecutorService(), MergingRenderingQueue::new, sceneComponentProvider, sceneUpdateListener, LayoutScannerConfiguration.getDISABLED(), sessionClockFactory);
    }

    public LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, LayoutScannerConfiguration config) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(12);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(13);
        }
        this(model2, designSurface, AppExecutorUtil.getAppExecutorService(), MergingRenderingQueue::new, new LayoutlibSceneManagerHierarchyProvider(), null, config, RealTimeSessionClock::new);
    }

    @NotNull
    public ViewEditor getViewEditor() {
        ViewEditor viewEditor = this.myViewEditor;
        if (viewEditor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(14);
        }
        return viewEditor;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component) {
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(15);
        }
        Scene scene = this.getScene();
        assert (scene.getRoot() != null);
        TemporarySceneComponent tempComponent = new TemporarySceneComponent(this.getScene(), component);
        tempComponent.setTargetProvider(sceneComponent -> ImmutableList.of((Object)new ConstraintDragDndTarget()));
        scene.setAnimated(false);
        scene.getRoot().addChild(tempComponent);
        this.syncFromNlComponent(tempComponent);
        scene.setAnimated(true);
        TemporarySceneComponent temporarySceneComponent = tempComponent;
        if (temporarySceneComponent == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(16);
        }
        return temporarySceneComponent;
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        SceneDecoratorFactory sceneDecoratorFactory = DECORATOR_FACTORY;
        if (sceneDecoratorFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(17);
        }
        return sceneDecoratorFactory;
    }

    @Override
    public float getSceneScalingFactor() {
        return (float)this.getModel().getConfiguration().getDensity().getDpiValue() / (float)Density.DEFAULT_DENSITY;
    }

    @NotNull
    public LayoutScannerConfiguration getLayoutScannerConfig() {
        LayoutScannerConfiguration layoutScannerConfiguration = this.myLayoutScannerConfig;
        if (layoutScannerConfiguration == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(18);
        }
        return layoutScannerConfiguration;
    }

    @Override
    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        try {
            if (this.myAreListenersRegistered) {
                NlModel model2 = this.getModel();
                this.getDesignSurface().getSelectionModel().removeListener(this.mySelectionChangeListener);
                model2.getConfiguration().removeListener(this.myConfigurationChangeListener);
                model2.removeListener(this.myModelChangeListener);
            }
            this.myRenderListeners.clear();
            this.myProgressIndicator.stop();
        }
        finally {
            super.dispose();
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                this.myRenderTaskDisposerExecutor.execute(this::disposeRenderTask);
            } else {
                this.disposeRenderTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRenderTask(@Nullable RenderTask newTask) {
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                try {
                    this.myRenderTask.dispose();
                }
                catch (Throwable t) {
                    Logger.getInstance(LayoutlibSceneManager.class).warn(t);
                }
            }
            this.mySessionClock = this.mySessionClockFactory.get();
            this.myRenderTask = newTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeRenderTask() {
        RenderTask renderTask;
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            renderTask = this.myRenderTask;
            this.myRenderTask = null;
        }
        if (renderTask != null) {
            try {
                renderTask.dispose();
            }
            catch (Throwable t) {
                Logger.getInstance(LayoutlibSceneManager.class).warn(t);
            }
        }
        this.updateCachedRenderResult(null);
    }

    @Override
    @NotNull
    protected NlDesignSurface getDesignSurface() {
        NlDesignSurface nlDesignSurface = (NlDesignSurface)super.getDesignSurface();
        if (nlDesignSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(19);
        }
        return nlDesignSurface;
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NlModel model2 = this.getModel();
        DesignerEditorFileType type = model2.getType();
        if (type == MenuFileType.INSTANCE) {
            SceneView sceneView = this.createSceneViewsForMenu();
            if (sceneView == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(20);
            }
            return sceneView;
        }
        ScreenView primarySceneView = this.getDesignSurface().getScreenViewProvider().createPrimarySceneView(this.getDesignSurface(), this);
        this.mySecondarySceneView = this.getDesignSurface().getScreenViewProvider().createSecondarySceneView(this.getDesignSurface(), this);
        this.getDesignSurface().updateErrorDisplay();
        ScreenView screenView = primarySceneView;
        if (screenView == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(21);
        }
        return screenView;
    }

    @Override
    @NotNull
    public List<SceneView> getSceneViews() {
        ImmutableList.Builder builder2 = ImmutableList.builder().addAll(super.getSceneViews());
        if (this.mySecondarySceneView != null) {
            builder2.add((Object)this.mySecondarySceneView);
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(22);
        }
        return immutableList;
    }

    private SceneView createSceneViewsForMenu() {
        NlModel model2 = this.getModel();
        XmlTag tag = model2.getFile().getRootTag();
        ScreenView sceneView = tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view") ? ScreenView.newBuilder(this.getDesignSurface(), this).withLayersProvider(sv -> ImmutableList.of((Object)new ScreenViewLayer((ScreenView)sv))).withContentSizePolicy(NavigationViewSceneView.CONTENT_SIZE_POLICY).withShapePolicy(SceneView.SQUARE_SHAPE_POLICY).build() : ScreenView.newBuilder(this.getDesignSurface(), this).build();
        this.getDesignSurface().updateErrorDisplay();
        return sceneView;
    }

    @Nullable
    public SceneView getSecondarySceneView() {
        return this.mySecondarySceneView;
    }

    public void updateTargets() {
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            LayoutlibSceneManager.updateTargetProviders(root);
            root.updateTargets();
        }
    }

    private static void updateTargetProviders(@NotNull SceneComponent component) {
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(23);
        }
        ViewHandler handler = (ViewHandler)SlowOperations.allowSlowOperations(() -> NlComponentHelperKt.getViewHandler(component.getNlComponent()));
        component.setTargetProvider(handler);
        for (SceneComponent child : component.getChildren()) {
            LayoutlibSceneManager.updateTargetProviders(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private CompletableFuture<Void> requestRenderAsync(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("requestRender after LayoutlibSceneManager has been disposed");
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(24);
            }
            return completableFuture;
        }
        CompletableFuture<Void> callback2 = new CompletableFuture<Void>();
        Object object = this.myFuturesLock;
        synchronized (object) {
            this.myPendingFutures.add(callback2);
            if (this.myIsCurrentlyRendering.booleanValue()) {
                CompletableFuture<Void> completableFuture = callback2;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                if (completableFuture == null) {
                    LayoutlibSceneManager.$$$reportNull$$$0(25);
                }
                return completableFuture;
            }
            this.myIsCurrentlyRendering = true;
        }
        this.myRenderingQueue.queue(this.createRenderUpdate(trigger));
        CompletableFuture<Void> completableFuture = callback2;
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(26);
        }
        return completableFuture;
    }

    private Update createRenderUpdate(final @Nullable LayoutEditorRenderResult.Trigger trigger) {
        return new Update("model.render", 999){

            public void run() {
                LayoutlibSceneManager.this.renderAsync(trigger);
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        };
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRenderAsync() {
        return this.requestRenderAsync(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    @NotNull
    public CompletableFuture<Void> requestUserInitiatedRenderAsync() {
        this.forceReinflate();
        return this.requestRenderAsync(LayoutEditorRenderResult.Trigger.USER);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestLayoutAndRenderAsync(boolean animate) {
        if (this.getDesignSurface().getScreenViewProvider() == NlScreenViewProvider.BLUEPRINT) {
            CompletableFuture<Void> completableFuture = this.requestLayoutAsync(animate);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(27);
            }
            return completableFuture;
        }
        LayoutEditorRenderResult.Trigger trigger = LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType());
        if (this.getDesignSurface().isRenderingSynchronously()) {
            CompletionStage completionStage = this.renderAsync(trigger).thenRun(() -> this.notifyListenersModelLayoutComplete(animate));
            if (completionStage == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(28);
            }
            return completionStage;
        }
        CompletionStage completionStage = this.requestRenderAsync(trigger).whenCompleteAsync((result, ex) -> this.notifyListenersModelLayoutComplete(animate), (Executor)AppExecutorUtil.getAppExecutorService());
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(29);
        }
        return completionStage;
    }

    protected void requestModelUpdate() {
        if (this.isDisposed.get()) {
            return;
        }
        this.myProgressIndicator.start();
        this.myRenderingQueue.queue(new Update("model.update", 10){

            public void run() {
                NlModel model2 = LayoutlibSceneManager.this.getModel();
                Project project = model2.getModule().getProject();
                if (!project.isOpen()) {
                    return;
                }
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    if (model2.getVirtualFile().isValid() && !model2.getFacet().isDisposed()) {
                        LayoutlibSceneManager.this.updateModelAsync().whenComplete((result, ex) -> {
                            LayoutlibSceneManager.this.isOutOfDate.set(false);
                            LayoutlibSceneManager.this.myProgressIndicator.stop();
                        });
                    } else {
                        LayoutlibSceneManager.this.isOutOfDate.set(false);
                        LayoutlibSceneManager.this.myProgressIndicator.stop();
                    }
                });
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    public static void setRenderViewPort(boolean state) {
        ourRenderViewPort = state;
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }

    public void setTransparentRendering(boolean enabled) {
        this.useTransparentRendering = enabled;
    }

    public void setShrinkRendering(boolean enabled) {
        this.useShrinkRendering = enabled;
    }

    public void setListenResourceChange(boolean enabled) {
        this.myListenResourceChange = enabled;
    }

    public void setShowDecorations(boolean enabled) {
        if (this.useShowDecorations != enabled) {
            this.useShowDecorations = enabled;
            this.forceReinflate();
        }
    }

    public void setRerenderWhenModelDerivedDataChanged(boolean enabled) {
        this.myRerenderWhenModelDerivedDataChanged = enabled;
    }

    public void setUpdateAndRenderWhenActivated(boolean enable) {
        this.myUpdateAndRenderWhenActivated = enable;
    }

    public boolean isShowingDecorations() {
        return this.useShowDecorations;
    }

    public void setUseImagePool(boolean enabled) {
        this.useImagePool = enabled;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    public void setLogRenderErrors(boolean enabled) {
        this.myLogRenderErrors = enabled;
    }

    public void doNotReportOutOfDateUserClasses() {
        this.reportOutOfDateUserClasses = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public CompletableFuture<Void> requestLayoutAsync(boolean animate) {
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("requestLayout after LayoutlibSceneManager has been disposed");
        }
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(30);
            return completableFuture;
        }
        CompletionStage completionStage = this.myRenderTask.layout().thenAccept(result -> {
            if (result != null && !this.isDisposed.get()) {
                this.updateHierarchy((RenderResult)result);
                this.notifyListenersModelLayoutComplete(animate);
            }
        });
        // MONITOREXIT : object
        if (completionStage != null) return completionStage;
        LayoutlibSceneManager.$$$reportNull$$$0(31);
        return completionStage;
    }

    @Override
    public void layout(boolean animate) {
        try {
            this.requestLayoutAsync(animate).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("Unable to run layout()", (Throwable)e);
        }
    }

    @Nullable
    public RenderResult getRenderResult() {
        this.myRenderResultLock.readLock().lock();
        try {
            RenderResult renderResult = this.myRenderResult;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, Map<ResourceReference, ResourceValue>> map2 = Collections.emptyMap();
            Map<Object, Map<ResourceReference, ResourceValue>> map3 = map2;
            if (map3 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(32);
            }
            return map3;
        }
        Map map4 = this.myRenderResult.getDefaultProperties();
        Map map5 = map4;
        if (map5 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(33);
        }
        return map5;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, ResourceReference> getDefaultStyles() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, ResourceReference> map2 = Collections.emptyMap();
            Map<Object, ResourceReference> map3 = map2;
            if (map3 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(34);
            }
            return map3;
        }
        Map map4 = this.myRenderResult.getDefaultStyles();
        Map map5 = map4;
        if (map5 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(35);
        }
        return map5;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    private void updateHierarchy(@Nullable RenderResult result) {
        try {
            this.myUpdateHierarchyLock.acquire();
            try {
                if (result == null || !result.getRenderResult().isSuccess()) {
                    NlModelHierarchyUpdater.updateHierarchy(Collections.emptyList(), this.getModel());
                } else {
                    NlModelHierarchyUpdater.updateHierarchy(result, this.getModel());
                }
            }
            finally {
                this.myUpdateHierarchyLock.release();
            }
            this.getModel().checkStructure();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private CompletableFuture<RenderResult> inflateAsync(boolean force) {
        Configuration configuration = this.getModel().getConfiguration();
        Project project = this.getModel().getProject();
        if (project.isDisposed() || this.isDisposed.get()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(36);
            }
            return completableFuture;
        }
        ResourceNotificationManager resourceNotificationManager = ResourceNotificationManager.getInstance((Project)project);
        LayoutPullParsers.saveFileIfNecessary((PsiFile)this.getModel().getFile());
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null && !force) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var5_5
                if (completableFuture == null) {
                    LayoutlibSceneManager.$$$reportNull$$$0(37);
                }
                return completableFuture;
            }
        }
        this.fireOnInflateStart();
        AndroidFacet facet = this.getModel().getFacet();
        this.myRenderedVersion = resourceNotificationManager.getCurrentVersion(facet, (PsiFile)this.getModel().getFile(), configuration);
        RenderService renderService = RenderService.getInstance((Project)this.getModel().getProject());
        RenderLogger logger2 = this.myLogRenderErrors ? renderService.createLogger(facet) : renderService.getNopLogger();
        RenderService.RenderTaskBuilder renderTaskBuilder = renderService.taskBuilder(facet, configuration).withPsiFile((PsiFile)this.getModel().getFile()).withLayoutScanner(Boolean.valueOf(this.myLayoutScannerConfig.isLayoutScannerEnabled())).withLogger(logger2);
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.setupRenderTaskBuilder(renderTaskBuilder).build().thenCompose(newTask -> {
            if (newTask != null) {
                newTask.getLayoutlibCallback().setAdaptiveIconMaskPath(configuration.getAdaptiveShape().getPathDescription());
                return ((CompletableFuture)newTask.inflate().whenComplete((result, inflateException) -> {
                    Throwable exception = null;
                    if (inflateException != null) {
                        exception = inflateException;
                    } else if (result != null) {
                        exception = result.getRenderResult().getException();
                    }
                    if (exception != null) {
                        if (result == null || !result.getRenderResult().isSuccess()) {
                            logger2.error("INFLATE", "Error inflating the preview", exception, null, null);
                        }
                        Logger.getInstance(LayoutlibSceneManager.class).warn(exception);
                    }
                    if (this.getModel().getModule().isDisposed() || result == null || !result.getRenderResult().isSuccess() || this.isDisposed.get()) {
                        newTask.dispose();
                    } else {
                        this.updateRenderTask((RenderTask)newTask);
                    }
                })).handle((result, exception) -> result != null ? result : RenderResult.createRenderTaskErrorResult((PsiFile)this.getModel().getFile(), (Throwable)exception));
            }
            this.updateRenderTask(null);
            return CompletableFuture.completedFuture(RenderResult.createRenderTaskErrorResult((PsiFile)this.getModel().getFile(), (RenderLogger)logger2));
        })).thenApply(this::updateCachedRenderResultIfNotNull)).thenApply(result -> {
            if (project.isDisposed() || !result.getRenderResult().isSuccess()) {
                return result;
            }
            this.updateHierarchy((RenderResult)result);
            return result;
        })).thenApply(result -> {
            this.fireOnInflateComplete();
            return this.logIfSuccessful((RenderResult)result, null, CommonUsageTracker.RenderResultType.INFLATE);
        })).whenCompleteAsync(this::notifyModelUpdateIfSuccessful, (Executor)AppExecutorUtil.getAppExecutorService());
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(38);
        }
        return completionStage;
    }

    @Nullable
    private RenderResult updateCachedRenderResultIfNotNull(@Nullable RenderResult result) {
        if (result != null) {
            return this.updateCachedRenderResult(result);
        }
        return null;
    }

    @Nullable
    private RenderResult updateCachedRenderResult(@Nullable RenderResult result) {
        this.myRenderResultLock.writeLock().lock();
        try {
            if (this.myRenderResult != null && this.myRenderResult != result) {
                this.myRenderResult.dispose();
            }
            this.myRenderResult = result;
            RenderResult renderResult = result;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    @NotNull
    protected RenderService.RenderTaskBuilder setupRenderTaskBuilder(@NotNull RenderService.RenderTaskBuilder taskBuilder) {
        if (taskBuilder == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(39);
        }
        if (!this.useImagePool) {
            taskBuilder.disableImagePool();
        }
        if (this.quality < 1.0f) {
            taskBuilder.withDownscaleFactor(this.quality);
        }
        if (!this.useShowDecorations) {
            taskBuilder.disableDecorations();
        }
        if (this.useShrinkRendering) {
            taskBuilder.withRenderingMode(SessionParams.RenderingMode.SHRINK);
        }
        if (this.useTransparentRendering) {
            taskBuilder.useTransparentBackground();
        }
        if (!this.getDesignSurface().getPreviewWithToolsVisibilityAndPosition()) {
            taskBuilder.disableToolsVisibilityAndPosition();
        }
        if (this.myUsePrivateClassLoader) {
            taskBuilder.usePrivateClassLoader();
        }
        if (this.myIsInteractive) {
            taskBuilder.preloadClasses(Arrays.asList(INTERACTIVE_CLASSES_TO_PRELOAD));
        }
        if (!this.reportOutOfDateUserClasses) {
            taskBuilder.doNotReportOutOfDateUserClasses();
        }
        taskBuilder.setProjectClassesTransform(this.myAdditionalProjectTransform).setNonProjectClassesTransform(this.myAdditionalNonProjectTransform).setOnNewClassLoader(this.myOnNewModuleClassLoader);
        RenderService.RenderTaskBuilder renderTaskBuilder = taskBuilder;
        if (renderTaskBuilder == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(40);
        }
        return renderTaskBuilder;
    }

    private void notifyModelUpdateIfSuccessful(@Nullable RenderResult result, @Nullable Throwable exception) {
        if (exception != null) {
            Logger.getInstance(LayoutlibSceneManager.class).warn(exception);
        }
        if (result != null && result.getRenderResult().isSuccess()) {
            this.notifyListenersModelUpdateComplete();
        }
    }

    @NotNull
    public CompletableFuture<Void> updateModelAsync() {
        CompletableFuture<Void> completableFuture = this.updateModelAndProcessResultsAsync(result -> null);
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(41);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> updateModelAndProcessResultsAsync(Function<? super RenderResult, Void> resultProcessing) {
        if (this.isDisposed.get()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(42);
            }
            return completableFuture;
        }
        CompletionStage completionStage = this.inflateAsync(true).thenApply(resultProcessing);
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(43);
        }
        return completionStage;
    }

    protected void notifyListenersModelLayoutComplete(boolean animate) {
        this.getModel().notifyListenersModelChangedOnLayout(animate);
    }

    protected void notifyListenersModelUpdateComplete() {
        this.getModel().notifyListenersModelDerivedDataChanged();
    }

    private void logConfigurationChange(@NotNull DesignSurface surface2) {
        int flags;
        if (surface2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(44);
        }
        if ((flags = this.myConfigurationUpdatedFlags.getAndSet(0)) != 0) {
            NlAnalyticsManager analyticsManager = ((NlDesignSurface)surface2).getAnalyticsManager();
            if ((flags & 8) != 0) {
                analyticsManager.trackThemeChange();
            }
            if ((flags & 0x20) != 0) {
                analyticsManager.trackApiLevelChange();
            }
            if ((flags & 0x10) != 0) {
                analyticsManager.trackLanguageChange();
            }
            if ((flags & 2) != 0) {
                analyticsManager.trackDeviceChange();
            }
        }
    }

    @Nullable
    private RenderResult logIfSuccessful(@Nullable RenderResult result, @Nullable LayoutEditorRenderResult.Trigger trigger, @NotNull CommonUsageTracker.RenderResultType resultType) {
        if (resultType == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(45);
        }
        if (result != null && result.getRenderResult().isSuccess()) {
            CommonUsageTracker.Companion.getInstance(this.getDesignSurface()).logRenderResult(trigger, result, resultType);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected CompletableFuture<RenderResult> renderAsync(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        CompletionStage completionStage;
        if (this.isDisposed.get()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(46);
            }
            return completableFuture;
        }
        Object object = this.myFuturesLock;
        synchronized (object) {
            this.myIsCurrentlyRendering = true;
            this.myRenderFutures.addAll(this.myPendingFutures);
            this.myPendingFutures.clear();
        }
        try {
            NlDesignSurface surface2 = this.getDesignSurface();
            this.logConfigurationChange(surface2);
            this.getModel().resetLastChange();
            this.fireOnRenderStart();
            long renderStartTimeMs = System.currentTimeMillis();
            completionStage = ((CompletableFuture)((CompletableFuture)this.renderImplAsync().thenApply(result -> this.logIfSuccessful((RenderResult)result, trigger, CommonUsageTracker.RenderResultType.RENDER))).thenApply(this::updateCachedRenderResultIfNotNull)).thenApply(result -> {
                if (result != null) {
                    long renderTimeMs = System.currentTimeMillis() - renderStartTimeMs;
                    NlDiagnosticsManager.getWriteInstance(surface2).recordRender(renderTimeMs, (long)(result.getRenderedImage().getWidth() * result.getRenderedImage().getHeight()) * 4L);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!this.isDisposed.get()) {
                        this.update();
                    }
                });
                this.fireOnRenderComplete();
                this.completeRender();
                return result;
            });
        }
        catch (Throwable e) {
            if (!this.getModel().getFacet().isDisposed()) {
                this.fireOnRenderFail(e);
                this.completeRender();
                throw e;
            }
            this.completeRender();
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(48);
            }
            return completableFuture;
        }
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(47);
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPendingRenders() {
        Object object = this.myFuturesLock;
        synchronized (object) {
            return !this.myPendingFutures.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRender() {
        ImmutableList callbacks;
        Object object = this.myFuturesLock;
        synchronized (object) {
            callbacks = ImmutableList.copyOf(this.myRenderFutures);
            this.myRenderFutures.clear();
            this.myIsCurrentlyRendering = false;
        }
        this.isOutOfDate.set(false);
        callbacks.forEach(callback2 -> callback2.complete(null));
        if (this.hasPendingRenders()) {
            this.requestRenderAsync(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public boolean isRendering() {
        Object object = this.myFuturesLock;
        synchronized (object) {
            return this.myIsCurrentlyRendering;
        }
    }

    @NotNull
    private CompletableFuture<RenderResult> renderImplAsync() {
        CompletionStage completionStage = ((CompletableFuture)this.inflateAsync(this.myForceInflate.getAndSet(false)).thenCompose(inflateResult -> {
            boolean inflated = inflateResult != null && inflateResult.getRenderResult().isSuccess();
            long elapsedFrameTimeMs = this.myElapsedFrameTimeMs;
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask == null || inflateResult != null && !inflateResult.getRenderResult().isSuccess()) {
                    this.getDesignSurface().updateErrorDisplay();
                    return CompletableFuture.completedFuture(null);
                }
                if (elapsedFrameTimeMs != -1L) {
                    this.myRenderTask.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(elapsedFrameTimeMs));
                }
                return this.myRenderTask.render().thenApply(result -> {
                    if (result != null && !inflated) {
                        this.updateHierarchy((RenderResult)result);
                    }
                    return result;
                });
            }
        })).handle((result, exception) -> {
            if (exception != null) {
                return RenderResult.createRenderTaskErrorResult((PsiFile)this.getModel().getFile(), (Throwable)exception);
            }
            return result;
        });
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(49);
        }
        return completionStage;
    }

    public void setElapsedFrameTimeMs(long ms) {
        this.myElapsedFrameTimeMs = ms;
    }

    protected void fireOnInflateStart() {
        this.myRenderListeners.forEach(RenderListener::onInflateStarted);
    }

    protected void fireOnInflateComplete() {
        this.myRenderListeners.forEach(RenderListener::onInflateCompleted);
    }

    protected void fireOnRenderStart() {
        this.myRenderListeners.forEach(RenderListener::onRenderStarted);
    }

    protected void fireOnRenderComplete() {
        this.myRenderListeners.forEach(RenderListener::onRenderCompleted);
    }

    protected void fireOnRenderFail(@NotNull Throwable e) {
        if (e == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(50);
        }
        this.myRenderListeners.forEach(listener2 -> listener2.onRenderFailed(e));
    }

    public void addRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(51);
        }
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("addRenderListener after LayoutlibSceneManager has been disposed");
        }
        this.myRenderListeners.add((Object)listener2);
    }

    public void removeRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(52);
        }
        this.myRenderListeners.remove((Object)listener2);
    }

    public void forceReinflate() {
        this.myForceInflate.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CompletableFuture<ExecuteCallbacksResult> executeCallbacksAsync() {
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("executeCallbacks after LayoutlibSceneManager has been disposed");
        }
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask == null) {
            CompletableFuture<ExecuteCallbacksResult> completableFuture = CompletableFuture.completedFuture(ExecuteCallbacksResult.EMPTY);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(53);
            return completableFuture;
        }
        CompletableFuture completableFuture = this.myRenderTask.executeCallbacks(this.currentTimeNanos());
        // MONITOREXIT : object
        if (completableFuture != null) return completableFuture;
        LayoutlibSceneManager.$$$reportNull$$$0(54);
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CompletableFuture<Void> executeInRenderSessionAsync(@NotNull Runnable block) {
        if (block == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(55);
        }
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask != null) {
            CompletableFuture completableFuture = this.myRenderTask.runAsyncRenderActionWithSession(block);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(56);
            return completableFuture;
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        // MONITOREXIT : object
        if (completableFuture != null) return completableFuture;
        LayoutlibSceneManager.$$$reportNull$$$0(57);
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long currentTimeNanos() {
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            return this.mySessionClock.getTimeNanos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSessionClock() {
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            this.mySessionClock.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSessionClock() {
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            this.mySessionClock.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CompletableFuture<TouchEventResult> triggerTouchEventAsync(@NotNull RenderSession.TouchEventType type, int x, int y) {
        if (type == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(58);
        }
        if (this.isDisposed.get()) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("executeCallbacks after LayoutlibSceneManager has been disposed");
        }
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(59);
            return completableFuture;
        }
        this.myTouchEventsCounter.incrementAndGet();
        CompletableFuture completableFuture = this.myRenderTask.triggerTouchEvent(type, x, y, this.currentTimeNanos());
        // MONITOREXIT : object
        if (completableFuture != null) return completableFuture;
        LayoutlibSceneManager.$$$reportNull$$$0(60);
        return completableFuture;
    }

    public boolean executeCallbacksAndRequestRender(@Nullable Runnable callback2) {
        return this.executeCallbacksAndRequestRender(30L, TimeUnit.MILLISECONDS, callback2);
    }

    public boolean executeCallbacksAndRequestRender(long timeout, TimeUnit timeoutUnit, @Nullable Runnable callback2) {
        try {
            if (callback2 != null) {
                RenderService.getRenderAsyncActionExecutor().runAsyncActionWithTimeout(timeout, timeoutUnit, Executors.callable(callback2)).get(timeout, timeoutUnit);
            }
            this.executeCallbacksAsync().thenCompose(b -> this.requestRenderAsync());
            return true;
        }
        catch (Exception e) {
            Logger.getInstance(LayoutlibSceneManager.class).debug("executeCallbacksAndRequestRender did not complete successfully", (Throwable)e);
            return false;
        }
    }

    public void setInteractive(boolean interactive) {
        this.myIsInteractive = interactive;
        this.getSceneViews().forEach(sv -> sv.setAnimated(interactive));
    }

    public boolean getInteractive() {
        return this.myIsInteractive;
    }

    public void setUsePrivateClassLoader(boolean usePrivateClassLoader) {
        this.myUsePrivateClassLoader = usePrivateClassLoader;
    }

    public boolean isUsePrivateClassLoader() {
        return this.myUsePrivateClassLoader;
    }

    @NotNull
    public void setProjectClassesTransform(@NotNull ClassTransform transform) {
        if (transform == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(61);
        }
        this.myAdditionalProjectTransform = transform;
    }

    @NotNull
    public void setNonProjectClassesTransform(@NotNull ClassTransform transform) {
        if (transform == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(62);
        }
        this.myAdditionalNonProjectTransform = transform;
    }

    @NotNull
    public void setOnNewClassLoader(@NotNull Runnable runnable) {
        if (runnable == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(63);
        }
        this.myOnNewModuleClassLoader = runnable;
    }

    @Override
    public boolean activate(@NotNull Object source) {
        boolean active;
        if (source == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(64);
        }
        if ((active = super.activate(source)) && this.myUpdateAndRenderWhenActivated) {
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance((Project)this.getModel().getProject());
            ResourceNotificationManager.ResourceVersion version = manager.getCurrentVersion(this.getModel().getFacet(), (PsiFile)this.getModel().getFile(), this.getModel().getConfiguration());
            if (!version.equals((Object)this.myRenderedVersion)) {
                this.requestModelUpdate();
                this.getModel().updateTheme();
            } else {
                this.requestLayoutAndRenderAsync(false);
            }
        }
        return active;
    }

    @Override
    public boolean deactivate(@NotNull Object source) {
        boolean deactivated;
        if (source == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(65);
        }
        if (deactivated = super.deactivate(source)) {
            this.myRenderingQueue.deactivate();
            this.completeRender();
            this.disposeRenderTask();
        }
        return deactivated;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reasons) {
        if (reasons == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(66);
        }
        if (this.myListenResourceChange) {
            super.resourcesChanged(reasons);
        }
    }

    public void resetTouchEventsCounter() {
        this.myTouchEventsCounter.set(0);
    }

    public int getTouchEventsCount() {
        return this.myTouchEventsCounter.get();
    }

    @Override
    public boolean isOutOfDate() {
        return this.isOutOfDate.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTaskDisposerExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingQueueFactory";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponentProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutScannerConfig";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionClockFactory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneUpdateListener";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskBuilder";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reasons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutScannerConfig";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateSceneView";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "requestRenderAsync";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayoutAndRenderAsync";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayoutAsync";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStyles";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "inflateAsync";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "setupRenderTaskBuilder";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "updateModelAsync";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "updateModelAndProcessResultsAsync";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "renderAsync";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "renderImplAsync";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCallbacksAsync";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInRenderSessionAsync";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "triggerTouchEventAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateTargetProviders";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setupRenderTaskBuilder";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationChange";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "logIfSuccessful";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fireOnRenderFail";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addRenderListener";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeRenderListener";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "executeInRenderSessionAsync";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "triggerTouchEventAsync";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setProjectClassesTransform";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setNonProjectClassesTransform";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setOnNewClassLoader";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "resourcesChanged";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class LayoutlibSceneManagerHierarchyProvider
    extends DefaultSceneManagerHierarchyProvider {
        protected LayoutlibSceneManagerHierarchyProvider() {
        }

        @Override
        public void syncFromNlComponent(@NotNull SceneComponent sceneComponent) {
            if (sceneComponent == null) {
                LayoutlibSceneManagerHierarchyProvider.$$$reportNull$$$0(0);
            }
            super.syncFromNlComponent(sceneComponent);
            NlComponent component = sceneComponent.getNlComponent();
            boolean animate = sceneComponent.getScene().isAnimated() && !sceneComponent.hasNoDimension();
            SceneManager manager = sceneComponent.getScene().getSceneManager();
            if (animate) {
                long time = System.currentTimeMillis();
                sceneComponent.setPositionTarget(Coordinates.pxToDp(manager, NlComponentHelperKt.getX(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getY(component)), time);
                sceneComponent.setSizeTarget(Coordinates.pxToDp(manager, NlComponentHelperKt.getW(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getH(component)), time);
            } else {
                sceneComponent.setPosition(Coordinates.pxToDp(manager, NlComponentHelperKt.getX(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getY(component)));
                sceneComponent.setSize(Coordinates.pxToDp(manager, NlComponentHelperKt.getW(component)), Coordinates.pxToDp(manager, NlComponentHelperKt.getH(component)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneComponent", "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$LayoutlibSceneManagerHierarchyProvider", "syncFromNlComponent"));
        }
    }

    private class ConfigurationChangeListener
    implements ConfigurationListener {
        private ConfigurationChangeListener() {
        }

        public boolean changed(int flags) {
            int newDpi;
            LayoutlibSceneManager.this.myConfigurationUpdatedFlags.getAndUpdate(value2 -> value2 |= flags);
            if ((flags & 2) != 0 && LayoutlibSceneManager.this.myDpi != (newDpi = LayoutlibSceneManager.this.getModel().getConfiguration().getDensity().getDpiValue())) {
                LayoutlibSceneManager.this.myDpi = newDpi;
                LayoutlibSceneManager.this.update();
            }
            return true;
        }
    }

    private class SelectionChangeListener
    implements SelectionListener {
        private SelectionChangeListener() {
        }

        @Override
        public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
            if (model2 == null) {
                SelectionChangeListener.$$$reportNull$$$0(0);
            }
            if (selection == null) {
                SelectionChangeListener.$$$reportNull$$$0(1);
            }
            LayoutlibSceneManager.this.updateTargets();
            LayoutlibSceneManager.this.getScene().needsRebuildList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selection";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$SelectionChangeListener";
            objectArray[2] = "selectionChanged";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model2) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
            NlDesignSurface surface2 = LayoutlibSceneManager.this.getDesignSurface();
            if (!LayoutlibSceneManager.this.myRerenderWhenModelDerivedDataChanged) {
                CompletableFuture.runAsync(() -> LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(surface2.getSelectionModel(), surface2.getSelectionModel().getSelection()), (Executor)EdtExecutorService.getInstance());
                return;
            }
            LayoutlibSceneManager.this.requestRenderAsync(LayoutlibSceneManager.getTriggerFromChangeType(model2.getLastChangeType())).thenRunAsync(() -> LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(surface2.getSelectionModel(), surface2.getSelectionModel().getSelection()), (Executor)EdtExecutorService.getInstance());
        }

        @Override
        public void modelChanged(@NotNull NlModel model2) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            if (((Boolean)StudioFlags.DESIGN_TOOLS_POWER_SAVE_MODE_SUPPORT.get()).booleanValue() && PowerSaveMode.isEnabled() && powerModeChangesNotTriggeringRefresh.contains((Object)model2.getLastChangeType())) {
                LayoutlibSceneManager.this.isOutOfDate.set(true);
                return;
            }
            LayoutlibSceneManager.this.requestModelUpdate();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!LayoutlibSceneManager.this.isDisposed.get()) {
                    LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(LayoutlibSceneManager.this.getDesignSurface().getSelectionModel(), LayoutlibSceneManager.this.getDesignSurface().getSelectionModel().getSelection());
                }
            });
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    boolean previous = LayoutlibSceneManager.this.getScene().isAnimated();
                    LayoutlibSceneManager.this.getScene().setAnimated(animate);
                    LayoutlibSceneManager.this.update();
                    LayoutlibSceneManager.this.getScene().setAnimated(previous);
                }
            });
        }

        @Override
        public void modelLiveUpdate(@NotNull NlModel model2, boolean animate) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            LayoutlibSceneManager.this.requestLayoutAndRenderAsync(animate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelLiveUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

