/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.ui.spring;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.uibuilder.property.ui.spring.SpringMode;
import com.android.tools.idea.uibuilder.property.ui.spring.SpringModelChangeListener;
import com.android.tools.idea.uibuilder.property.ui.spring.SpringParameter;
import com.android.tools.idea.uibuilder.property.ui.spring.SpringWidgetModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.Timer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWidget
extends JPanel {
    private static final Color GRID_COLOR = StudioColorsKt.getSecondaryGraphLines();
    private static final Color GRID_TEXT_COLOR = StudioColorsKt.getGraphLabel();
    private static final Color MAIN_PLOT_COLOR = StudioColorsKt.getGraphLines();
    private static final Color CRITICAL_PLOT_COLOR = StudioColorsKt.getGraphLines();
    private static final Color ENVELOPE_PLOT_COLOR = StudioColorsKt.getGraphLines();
    private static final Color OVERLAY_TEXT_COLOR = StudioColorsKt.getGraphLines();
    private static final Color CONTROL_POINT_COLOR = StudioColorsKt.getGraphLines();
    private static final Color BALL_PLOT_COLOR = StudioColorsKt.getLinkForeground();
    float mDestination = 1.0f;
    float myStiffness = 400.0f;
    float myDamping = 0.5f;
    float myMass = 1.0f;
    float myThreshold = 0.001f;
    float myCriticallyDamping;
    float mInitialVelocity = 0.0f;
    float mInitialPosition = 0.0f;
    float mApproxDuration = 0.0f;
    float mFrequency = 0.0f;
    boolean mBounce = false;
    float mInitialVelocityRange = 4.0f;
    boolean mUseSpring = true;
    float mDuration = 2.0f;
    float mMaxAcceleration = 2.0f;
    float mMaxVelocity = 2.0f;
    StopLogicEngine stopLogicEngine = new StopLogicEngine();
    plotInfo plotInfo = new plotInfo();
    ArrayList<ActionListener> listeners = new ArrayList();
    static final boolean ADVANCED = false;
    private float mSamplingInterval = 0.016f;
    private BasicPlot mMainPlot;
    boolean animate = false;
    ArrayList<DrawItem> baseDraw = new ArrayList();
    ArrayList<PlotItem> plotDraw = new ArrayList();
    DrawItem stats = new DrawItem(){
        int x;
        int y;
        DecimalFormat df = new DecimalFormat("###.##");

        @Override
        public void paint(Graphics2D g, int w, int h) {
            this.y = SpringWidget.this.plotInfo.ins_top + 30;
            this.x = w - 100;
            g.setColor(OVERLAY_TEXT_COLOR);
            this.right("Base freq: ", this.df.format(SpringWidget.this.mFrequency) + "hz", g);
            this.right("Duration: ", this.df.format(SpringWidget.this.mApproxDuration * 1000.0f) + "ms", g);
            this.right("Critically Damping: ", this.df.format(SpringWidget.this.myCriticallyDamping) + "  ", g);
        }

        void right(String str1, String str2, Graphics2D g) {
            Rectangle2D bounds2 = g.getFontMetrics().getStringBounds(str1, g);
            g.drawString(str1, (float)this.x - (float)bounds2.getWidth(), (float)this.y);
            g.drawString(str2, this.x + 2, this.y);
            this.y = (int)((double)this.y + (bounds2.getHeight() + 7.0));
        }
    };
    DrawItem mAnimation = new DrawItem(){
        float pos;
        int stop;
        final int delay = 16;
        final int DECAY_FRAMES = 30;
        final Timer animate = new Timer(16, e -> this.animate());
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                animate.start();
                stop = 30;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                stop = 29;
            }
        };
        {
            this.animate.setRepeats(true);
            SpringWidget.this.addMouseListener(this.mouseAdapter);
        }

        void animate() {
            if (this.stop == 0) {
                this.animate.stop();
            } else if (this.stop < 30) {
                --this.stop;
            }
            this.pos += 16.0f / (SpringWidget.this.mDuration * 1000.0f);
            if (this.pos > 1.0f) {
                this.pos = 0.0f;
            }
            SpringWidget.this.repaint();
        }

        @Override
        public void paint(Graphics2D g, int w, int h) {
            if (this.stop == 0 || SpringWidget.this.mMainPlot == null) {
                return;
            }
            float[] xplot = SpringWidget.this.mMainPlot.getX();
            float[] yplot = SpringWidget.this.mMainPlot.getY();
            int index = (int)((float)xplot.length * this.pos);
            int y = (int)SpringWidget.this.plotInfo.getY(h, yplot[index]);
            int x = (int)SpringWidget.this.plotInfo.getX(w, xplot[index]);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color color2 = BALL_PLOT_COLOR;
            if (this.stop < 30) {
                int alpha = this.stop * 255 / 30;
                color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), alpha);
            }
            g.setColor(color2);
            g.fillRoundRect(x - 3, y - 3, 6, 6, 6, 6);
            g.fillRoundRect(w - SpringWidget.this.plotInfo.ins_right / 2 - 5, y - 5, 10, 10, 10, 10);
        }
    };
    DrawItem mInitialVelocityCtl = new DrawItem(){
        int half_size = 5;
        DecimalFormat df = new DecimalFormat("0.0");

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(CONTROL_POINT_COLOR);
            float ctl_range = h - SpringWidget.this.plotInfo.ins_bottom - SpringWidget.this.plotInfo.ins_top;
            int center = (int)(ctl_range / 2.0f + (float)SpringWidget.this.plotInfo.ins_top);
            float y = 1.0f - SpringWidget.this.mInitialVelocity / SpringWidget.this.mInitialVelocityRange;
            int ypoint = (int)((float)SpringWidget.this.plotInfo.ins_top + (y *= ctl_range / 2.0f));
            g.fillRect(this.half_size + 1, center, 1, ypoint - center);
            int px = 1 + this.half_size;
            int py = ypoint;
            if (SpringWidget.this.mInitialVelocity == 0.0f) {
                g.fillRoundRect(1, ypoint - this.half_size, this.half_size * 2, this.half_size * 2, this.half_size * 2, this.half_size * 2);
            } else if (SpringWidget.this.mInitialVelocity < 0.0f) {
                g.drawLine(px, py, px - 5, py - 5);
                g.drawLine(px, py, px + 5, py - 5);
            } else {
                g.drawLine(px, py, px - 5, py + 5);
                g.drawLine(px, py, px + 5, py + 5);
            }
            String str = "v0:";
            Rectangle2D rec = g.getFontMetrics().getStringBounds(str, g);
            int lineHeight = (int)rec.getHeight();
            int yoff = SpringWidget.this.mInitialVelocity >= 0.0f ? -lineHeight * 2 + this.half_size : this.half_size * 4;
            g.drawString(str, 1, ypoint + yoff);
            str = this.df.format(SpringWidget.this.mInitialVelocity);
            g.drawString(str, 1, ypoint + (yoff += lineHeight));
        }
    };
    DrawItem mAxis = new DrawItem(){
        Color drawing = new Color(0xAAAAAA);
        Color mGridColor = new Color(4825223);

        @Override
        public void paint(Graphics2D g, int w, int h) {
            if (!SpringWidget.this.plotInfo.draw_axis) {
                return;
            }
            g.setColor(this.drawing);
            g.setColor(this.mGridColor);
            g.drawLine(SpringWidget.this.plotInfo.ins_left, SpringWidget.this.plotInfo.ins_top, SpringWidget.this.plotInfo.ins_left, h - SpringWidget.this.plotInfo.ins_bottom);
            g.drawLine(SpringWidget.this.plotInfo.ins_left, h - SpringWidget.this.plotInfo.ins_bottom, w - SpringWidget.this.plotInfo.ins_right, h - SpringWidget.this.plotInfo.ins_bottom);
        }
    };
    DrawItem mGrid = new DrawItem(){
        Color mGridColor = GRID_COLOR;
        Color mGridTextColor = GRID_TEXT_COLOR;
        private float mPeriodMultiplier = 1.0f;
        DecimalFormat df = new DecimalFormat("##0.0");

        @Override
        public void paint(Graphics2D g, int w, int h) {
            int ix;
            float i;
            if (!SpringWidget.this.plotInfo.draw_grid) {
                return;
            }
            g.setColor(this.mGridColor);
            int draw_width = w - SpringWidget.this.plotInfo.ins_left - SpringWidget.this.plotInfo.ins_right;
            float e = 1.0E-4f * (SpringWidget.this.plotInfo.maxx - SpringWidget.this.plotInfo.minx);
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getAscent();
            if (SpringWidget.this.plotInfo.mTickX > 0.0f) {
                for (i = SpringWidget.this.plotInfo.minx + SpringWidget.this.plotInfo.mTickX; i <= SpringWidget.this.plotInfo.maxx - SpringWidget.this.plotInfo.mTickX + e; i += SpringWidget.this.plotInfo.mTickX) {
                    ix = (int)((float)draw_width * (i - SpringWidget.this.plotInfo.minx) / (SpringWidget.this.plotInfo.maxx - SpringWidget.this.plotInfo.minx) + (float)SpringWidget.this.plotInfo.ins_left);
                    String str = this.df.format(i);
                    int sw = fm.stringWidth(str) / 2;
                    g.setColor(this.mGridTextColor);
                    g.drawString(str, ix - sw, h - SpringWidget.this.plotInfo.ins_bottom + ascent + SpringWidget.this.plotInfo.mTextGap);
                }
            }
            g.setColor(this.mGridColor);
            for (i = SpringWidget.this.plotInfo.minx; i <= SpringWidget.this.plotInfo.maxx + e; i += SpringWidget.this.plotInfo.mTickX) {
                ix = (int)((float)draw_width * (i - SpringWidget.this.plotInfo.minx) / (SpringWidget.this.plotInfo.maxx - SpringWidget.this.plotInfo.minx) + (float)SpringWidget.this.plotInfo.ins_left);
                g.setColor(this.mGridColor);
                g.drawLine(ix, SpringWidget.this.plotInfo.ins_top, ix, h - SpringWidget.this.plotInfo.ins_bottom);
            }
            int draw_height = h - SpringWidget.this.plotInfo.ins_top - SpringWidget.this.plotInfo.ins_bottom;
            e = 1.0E-4f * (SpringWidget.this.plotInfo.maxy - SpringWidget.this.plotInfo.miny);
            int hightoff = -fm.getHeight() / 2 + ascent;
            int y0 = (int)((float)draw_height * (1.0f - (0.0f - SpringWidget.this.plotInfo.miny) / (SpringWidget.this.plotInfo.maxy - SpringWidget.this.plotInfo.miny)) + (float)SpringWidget.this.plotInfo.ins_top);
            for (float i2 = SpringWidget.this.plotInfo.miny; i2 <= SpringWidget.this.plotInfo.maxy + e; i2 += SpringWidget.this.plotInfo.mTickY) {
                int iy = (int)((float)draw_height * (1.0f - (i2 - SpringWidget.this.plotInfo.miny) / (SpringWidget.this.plotInfo.maxy - SpringWidget.this.plotInfo.miny)) + (float)SpringWidget.this.plotInfo.ins_top);
                g.setColor(this.mGridColor);
                g.drawLine(SpringWidget.this.plotInfo.ins_left, iy, w - SpringWidget.this.plotInfo.ins_right, iy);
                String str = this.df.format(i2);
                int sw = fm.stringWidth(str);
                g.setColor(this.mGridTextColor);
                g.drawString(str, SpringWidget.this.plotInfo.ins_left - sw - SpringWidget.this.plotInfo.mTextGap, iy + hightoff);
            }
        }
    };
    DrawItem clear = new DrawItem(){

        @Override
        public void paint(Graphics2D g, int w, int h) {
            g.setColor(SpringWidget.this.getBackground());
            g.fillRect(0, 0, w, h);
        }
    };

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    void recalc() {
        this.plotDraw.clear();
        this.plotWave();
    }

    void plotWave() {
        if (this.mUseSpring) {
            this.plotSpring();
        } else {
            this.plotDecay();
        }
    }

    void plotDecay() {
        float duration = this.mDuration;
        this.stopLogicEngine.config(this.mInitialPosition, this.mDestination, this.mInitialVelocity, duration, this.mMaxAcceleration, this.mMaxVelocity);
        float dt = 0.016f;
        int len = (int)(duration / dt);
        float[] ya = new float[len];
        float[] xa = new float[len];
        float x = 0.0f;
        for (int i = 0; i < xa.length; ++i) {
            xa[i] = x += dt;
            ya[i] = this.stopLogicEngine.getInterpolation(x);
        }
        this.mMainPlot = new BasicPlot(xa, ya, MAIN_PLOT_COLOR);
        this.plotDraw.add(this.mMainPlot);
        this.plotInfo.calcRange(this.plotDraw);
        this.repaint();
    }

    void plotSpring() {
        double k = this.myStiffness;
        double c = this.myDamping;
        double m = this.myMass;
        this.mFrequency = (float)(Math.sqrt(k / m) / (Math.PI * 2));
        double f = Math.sqrt(k / m);
        this.myCriticallyDamping = (float)(2.0 * Math.sqrt(this.myMass * this.myStiffness));
        this.mApproxDuration = this.calcThreshold(this.mDestination, this.myStiffness, this.myDamping, this.myMass, this.myThreshold, 20.0f);
        this.plotWave(MAIN_PLOT_COLOR, this.mDestination, this.myStiffness, this.myDamping, this.myMass, this.mApproxDuration);
    }

    float calcThreshold(double destination, double stiffness, double damping, double mass, double threashold, float maxDuration) {
        double k = stiffness;
        double c = damping;
        double m = mass;
        float dt = 0.016f;
        float v0 = this.mInitialVelocity;
        float x0 = this.mInitialPosition;
        boolean positive = destination > (double)this.mInitialPosition;
        int len = (int)(maxDuration / dt);
        double x = x0;
        double v = v0;
        float t = 0.0f;
        for (int i = 0; i < len; ++i) {
            double dx = x - destination;
            double a = (-dx * k - v * c) / m;
            double vavg = v + a * (double)dt / 2.0;
            double xavg = x + (double)dt * vavg / 2.0 - destination;
            a = (-xavg * k - vavg * c) / m;
            double pos = (float)(x += (double)dt * ((v += a * (double)dt) + a * (double)dt / 2.0));
            if (this.mBounce) {
                if (positive) {
                    if (pos > destination) {
                        pos = 2.0 * destination - pos;
                        v = -v;
                        x = 2.0 * destination - x;
                    }
                } else if (pos < destination) {
                    pos = 2.0 * destination - pos;
                    v = -v;
                    x = 2.0 * destination - x;
                }
            }
            t += dt;
            dx = x - destination;
            double energy_x_2 = dx * dx * k + m * v * v;
            double max_p = Math.sqrt(energy_x_2 / k);
            if (!(max_p < threashold)) continue;
            return t;
        }
        return maxDuration;
    }

    void plotMax(Color color2, double destination, double stiffness, double damping, double mass, float duration) {
        double k = stiffness;
        double c = damping;
        double m = mass;
        float dt = 0.004f;
        float v0 = this.mInitialVelocity;
        float x0 = this.mInitialPosition;
        boolean positive = destination > (double)this.mInitialPosition;
        int len = (int)(duration / dt);
        float[] ya = new float[len];
        float[] xa = new float[len];
        double x = x0;
        double v = v0;
        float t = 0.0f;
        for (int i = 0; i < xa.length; ++i) {
            double dx = x - destination;
            double a = (-dx * k - v * c) / m;
            double vavg = v + a * (double)dt / 2.0;
            double xavg = x + (double)dt * vavg / 2.0 - destination;
            a = (-xavg * k - vavg * c) / m;
            x += (double)dt * (v + a * (double)dt / 2.0);
            v += a * (double)dt;
            if (this.mBounce && x < 0.0) {
                v = -v;
                x = -x;
            }
            dx = x - destination;
            double energy_x_2 = dx * dx * k + m * v * v;
            double max_p = Math.sqrt(energy_x_2 / k);
            ya[i] = (float)max_p;
            xa[i] = t += dt;
        }
        this.plotDraw.add(new BasicPlot(xa, ya, color2));
        this.plotInfo.calcRange(this.plotDraw);
        this.repaint();
    }

    void plotWave(Color color2, double destination, double stiffness, double damping, double mass, float duration) {
        double k = stiffness;
        double c = damping;
        double m = mass;
        float dt = this.mSamplingInterval;
        float v0 = this.mInitialVelocity;
        float x0 = this.mInitialPosition;
        boolean positive = destination > (double)this.mInitialPosition;
        int len = (int)(duration / dt);
        float[] ya = new float[len];
        float[] xa = new float[len];
        double critical = Math.PI / (Math.sqrt(this.myStiffness / this.myMass) * (double)this.mSamplingInterval * 4.0);
        int n = (int)(1.0 + critical * 4.0);
        dt /= (float)n;
        double x = x0;
        double v = v0;
        float t = 0.0f;
        for (int i = 0; i < xa.length; ++i) {
            for (int j = 0; j < n; ++j) {
                double dx = x - destination;
                double a = (-dx * k - v * c) / m;
                double vavg = v + a * (double)dt / 2.0;
                double xavg = x + (double)dt * vavg / 2.0 - destination;
                a = (-xavg * k - vavg * c) / m;
                x += (double)dt * (v + a * (double)dt / 2.0);
                v += a * (double)dt;
                if (!this.mBounce) continue;
                if (positive) {
                    if (!(x > destination)) continue;
                    x = 2.0 * destination - x;
                    v = -v;
                    if (i + 1 >= xa.length) continue;
                    ya[i] = (float)destination;
                    xa[i] = t + dt / 2.0f;
                    ++i;
                    continue;
                }
                if (!(x < destination)) continue;
                x = 2.0 * destination - x;
                v = -v;
                if (i + 1 >= xa.length) continue;
                ya[i] = (float)destination;
                xa[i] = t + dt / 2.0f;
                ++i;
            }
            ya[i] = (float)x;
            xa[i] = t += dt * (float)n;
        }
        this.mMainPlot = new BasicPlot(xa, ya, color2);
        this.plotDraw.add(this.mMainPlot);
        this.plotInfo.calcRange(this.plotDraw);
        this.repaint();
    }

    public SpringWidget() {
        this.baseDraw.add(this.clear);
        this.baseDraw.add(this.mAxis);
        this.baseDraw.add(this.mGrid);
        this.baseDraw.add(this.mAnimation);
        this.animate = true;
    }

    public double getGraphX(float x) {
        int draw_width = this.getWidth() - this.plotInfo.ins_left - this.plotInfo.ins_right;
        return this.plotInfo.minx + (this.plotInfo.maxx - this.plotInfo.minx) * (x - (float)this.plotInfo.ins_left) / (float)draw_width;
    }

    public double getGraphY(float y) {
        int draw_height = this.getHeight() - this.plotInfo.ins_top - this.plotInfo.ins_bottom;
        return this.plotInfo.miny + 1.0f - (this.plotInfo.maxy - this.plotInfo.miny) * (y - (float)this.plotInfo.ins_top) / (float)draw_height;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        this.plotInfo.calcRangeTicks(w, h);
        Graphics2D g2d = (Graphics2D)g;
        for (DrawItem drawItem : this.baseDraw) {
            drawItem.paint(g2d, w, h);
        }
        for (DrawItem drawItem : this.plotDraw) {
            drawItem.paint(g2d, w, h);
        }
    }

    public void addBasicPlot(float[] x, float[] y, Color c) {
        this.plotDraw.add(new BasicPlot(x, y, c));
        this.plotInfo.calcRange(this.plotDraw);
        this.repaint();
    }

    public void setFunction(double minx, double maxx, Color c, Function f) {
        float[] x = new float[100];
        float[] y = new float[x.length];
        double last = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double in = minx + maxx * ((double)i / (double)(x.length - 1));
            x[i] = (float)in;
            double value2 = (float)f.f(in);
            if ((Double.isNaN(value2) || Double.isInfinite(value2)) && (Double.isNaN(value2 = (double)((float)f.f(in + 1.0E-6))) || Double.isInfinite(value2))) {
                value2 = last;
            }
            y[i] = (float)value2;
            last = value2;
        }
        this.plotDraw.clear();
        this.plotDraw.add(new BasicPlot(x, y, c));
        this.plotInfo.calcRange(this.plotDraw);
        this.repaint();
    }

    public void addFunction(double minx, double maxx, Color c, Function f) {
        float[] x = new float[512];
        float[] y = new float[512];
        double last = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double in = minx + maxx * ((double)i / (double)(x.length - 1));
            x[i] = (float)in;
            double value2 = (float)f.f(in);
            if ((Double.isNaN(value2) || Double.isInfinite(value2)) && (Double.isNaN(value2 = (double)((float)f.f(in + 1.0E-6))) || Double.isInfinite(value2))) {
                value2 = last;
            }
            y[i] = (float)value2;
            last = value2;
        }
        this.plotDraw.add(new BasicPlot(x, y, c));
        this.plotInfo.calcRange(this.plotDraw);
        this.repaint();
    }

    static SpringWidget setupFrame(JFrame frame) {
        SpringWidget p = new SpringWidget();
        frame.setContentPane(p);
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 800, 600);
        return p;
    }

    static SpringWidget plot(double minx, double maxx, Color c, Function f) {
        JFrame frame = new JFrame("Graph");
        SpringWidget p = SpringWidget.setupFrame(frame);
        p.addFunction(minx, maxx, c, f);
        frame.setVisible(true);
        return p;
    }

    static SpringWidget plot(double minx, double maxx, Function ... f) {
        JFrame frame = new JFrame("Graph");
        SpringWidget p = SpringWidget.setupFrame(frame);
        ColorGen colorGen = new ColorGen();
        for (Function function : f) {
            p.addFunction(minx, maxx, colorGen.getColor(), function);
        }
        frame.setVisible(true);
        return p;
    }

    public float getStiffness() {
        return this.myStiffness;
    }

    public void setStiffness(float stiffness) {
        this.myStiffness = stiffness;
        this.recalc();
    }

    public float getDamping() {
        return this.myDamping;
    }

    public void setDamping(float damping) {
        this.myDamping = damping;
        this.recalc();
    }

    public float getMass() {
        return this.myMass;
    }

    public void setMass(float mass) {
        this.myMass = mass;
        this.recalc();
    }

    public float getThreshold() {
        return this.myThreshold;
    }

    public void setThreshold(float threshold) {
        this.myThreshold = threshold;
        this.recalc();
    }

    public boolean isBounce() {
        return this.mBounce;
    }

    public void setBounce(boolean bounce) {
        this.mBounce = bounce;
        this.recalc();
    }

    public boolean isUseSpring() {
        return this.mUseSpring;
    }

    public void setUseSpring(boolean useSpring) {
        this.mUseSpring = useSpring;
        this.recalc();
    }

    public void setMode(SpringMode mode) {
        switch (mode) {
            case NORMAL: {
                this.mUseSpring = false;
                break;
            }
            case SPRING_WITH_DAMP_CONSTANT: {
                this.mUseSpring = true;
                break;
            }
            case SPRING_WITH_DAMP_RATIO: {
                this.mUseSpring = true;
                this.myMass = 1.0f;
            }
        }
        this.recalc();
    }

    public float getDuration() {
        return this.mDuration;
    }

    public void setDuration(float duration) {
        this.mDuration = duration;
        this.recalc();
    }

    public float getMaxAcceleration() {
        return this.mMaxAcceleration;
    }

    public void setMaxAcceleration(float maxAcceleration) {
        this.mMaxAcceleration = maxAcceleration;
        this.recalc();
    }

    public float getMaxVelocity() {
        return this.mMaxVelocity;
    }

    public void setMaxVelocity(float maxVelocity) {
        this.mMaxVelocity = maxVelocity;
        this.recalc();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
    }

    public static JPanel panelWithUI(SpringWidgetModel model2) {
        return new mainUI(model2);
    }

    public static void log(String str) {
        Throwable t = new Throwable();
        StackTraceElement s = t.getStackTrace()[1];
        String line = ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + s.getMethodName() + "() ";
        System.out.println(line + str);
    }

    public static void log(String str, int n) {
        Throwable t = new Throwable();
        StackTraceElement[] st = t.getStackTrace();
        Object line = "";
        for (int i = 1; i < n; ++i) {
            StackTraceElement s = st[i];
            line = (String)line + ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + s.getMethodName() + "() " + str + "\n";
        }
        System.out.println((String)line);
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame("OnSwipe");
        final JPanel panel2 = SpringWidget.panelWithUI(null);
        frame.setContentPane(panel2);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        panel2.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                System.out.println(">>>>>" + panel2.getWidth() + " , " + panel2.getHeight());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Nullable
    private static SliderSpec getSliderSpec(SpringParameter parameter) {
        switch (parameter) {
            case MAX_ACC: {
                return new SliderSpec(0.1f, 100.0f, 2);
            }
            case MAX_VEL: {
                return new SliderSpec(0.1f, 10.0f, 2);
            }
            case DURATION: {
                return new SliderSpec(100.0f, 10000.0f, 1);
            }
            case MASS: {
                return new SliderSpec(0, 10, 1);
            }
            case DAMPING: {
                return new SliderSpec(0, 100, 3);
            }
            case STIFFNESS: {
                return new SliderSpec(40, 2000, 2);
            }
            case THRESHOLD: {
                return new SliderSpec(1.0E-4f, 0.9f, 4);
            }
            case DAMPING_RATIO: {
                return new SliderSpec(0.01f, 2.0f, 2);
            }
        }
        return null;
    }

    private static boolean isUseSlider(SpringParameter parameter) {
        return !parameter.equals((Object)SpringParameter.BOUNDARY);
    }

    private static SpringMode getMatchingMode(String modeName) {
        for (SpringMode mode : SpringMode.values()) {
            if (!mode.displayName.equals(modeName)) continue;
            return mode;
        }
        return SpringMode.NORMAL;
    }

    @NotNull
    private static SpringParameter[] getAllParameters(SpringWidgetModel model2) {
        SpringMode[] supportedModes = model2.getSupportedModes();
        SpringParameter[] springParameterArray = (SpringParameter[])Arrays.stream(supportedModes).flatMap(mode -> mode.parameters.stream()).toArray(SpringParameter[]::new);
        if (springParameterArray == null) {
            SpringWidget.$$$reportNull$$$0(0);
        }
        return springParameterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/ui/spring/SpringWidget", "getAllParameters"));
    }

    private static class SliderSpec {
        public final int sliderMin;
        public final int sliderMax;
        public final int scale;

        public SliderSpec(int min, int max, int decimals) {
            this.scale = (int)Math.pow(10.0, decimals);
            this.sliderMin = min * this.scale;
            this.sliderMax = max * this.scale;
        }

        public SliderSpec(float min, float max, int decimals) {
            this.scale = (int)Math.pow(10.0, decimals);
            this.sliderMin = (int)(min * (float)this.scale);
            this.sliderMax = (int)(max * (float)this.scale);
        }
    }

    private static class MyChangeListener
    implements SpringModelChangeListener {
        Runnable modelChangedCallback;

        public MyChangeListener(Runnable callback2) {
            this.modelChangedCallback = callback2;
        }

        @Override
        public void onModelChanged() {
            this.modelChangedCallback.run();
        }
    }

    static class mainUI
    extends JPanel {
        ArrayList<JComponent> components = new ArrayList();
        SpringWidget myGraph = new SpringWidget();
        SpringParameter[] allParameters;
        String spacing = "XXXXXXXXX";
        JPanel mainControlsPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        ButtonGroup group = new ButtonGroup();
        JPanel modeSelectorPanel = new JPanel();
        CardLayout cardLayout = new CardLayout();
        JPanel ctlCards = new JPanel(this.cardLayout);
        HashMap<SpringMode, JPanel> modeToControls = new HashMap();
        HashMap<SpringParameter, JSlider> parameterToSlider = new HashMap();
        Boolean isUpdatingFromModel;

        mainUI(SpringWidgetModel model2) {
            super(new BorderLayout());
            this.allParameters = SpringWidget.getAllParameters(model2);
            this.isUpdatingFromModel = true;
            this.initializeGraph(model2);
            this.initializeControls(model2);
            this.isUpdatingFromModel = false;
            model2.addListener(new MyChangeListener(() -> this.updateWidget(model2)));
        }

        private void updateModel(SpringParameter parameter, SpringWidgetModel model2, float value2) {
            Application application = ApplicationManager.getApplication();
            String valueString = Float.toString(value2);
            application.invokeLaterOnWriteThread(() -> model2.setValue(parameter, valueString));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.components != null) {
                for (JComponent component : this.components) {
                    component.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
                }
            }
            this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        }

        private void initializeGraph(SpringWidgetModel model2) {
            HashMap<SpringParameter, Float> valuesInModel = new HashMap<SpringParameter, Float>();
            SpringParameter[] springParameterArray = this.allParameters;
            int n = springParameterArray.length;
            for (int i = 0; i < n; ++i) {
                SpringParameter parameter;
                Float parameterValue = StringsKt.toFloatOrNull((String)model2.getValue(parameter = springParameterArray[i]));
                valuesInModel.put(parameter, Float.valueOf(parameterValue != null ? parameterValue.floatValue() : 1.0f));
            }
            this.updateAllGraph(valuesInModel);
        }

        private void initializeControls(SpringWidgetModel model2) {
            SpringMode initialMode = model2.getStartingMode() != null ? model2.getStartingMode() : model2.getSupportedModes()[0];
            mainUI panel2 = this;
            panel2.add(this.myGraph);
            this.components.add(this.mainControlsPanel);
            this.components.add(this.topPanel);
            this.components.add(this.modeSelectorPanel);
            this.topPanel.add(this.modeSelectorPanel);
            this.mainControlsPanel.add((Component)this.topPanel, "North");
            panel2.add((Component)this.mainControlsPanel, "South");
            this.components.add(this.ctlCards);
            this.mainControlsPanel.add(this.ctlCards);
            this.myGraph.setMode(initialMode);
            this.addModeSelector(model2.getSupportedModes(), initialMode);
            for (SpringMode mode : model2.getSupportedModes()) {
                this.addControlsForMode(mode, model2);
            }
            this.cardLayout.show(this.ctlCards, initialMode.displayName);
            this.myGraph.plotWave();
            panel2.setPreferredSize(new Dimension(300, 430));
            panel2.setMinimumSize(new Dimension(300, 430));
            panel2.setSize(new Dimension(300, 430));
            panel2.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
            for (JComponent component : this.components) {
                component.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
            }
        }

        private void addModeSelector(SpringMode[] supportedModes, SpringMode defaultMode) {
            if (supportedModes.length <= 1) {
                return;
            }
            ActionListener actionListener = e -> {
                Object source = e.getSource();
                if (!(source instanceof JRadioButton)) {
                    return;
                }
                if (!((JRadioButton)source).isSelected()) {
                    return;
                }
                String selectedModeName = ((JRadioButton)source).getName();
                SpringMode selectedMode = SpringWidget.getMatchingMode(selectedModeName);
                this.myGraph.setMode(selectedMode);
                this.cardLayout.show(this.ctlCards, selectedModeName);
                this.modeToControls.forEach((mode, panel2) -> {
                    boolean isModeSelected = mode.equals((Object)selectedMode);
                    for (Component component : panel2.getComponents()) {
                        component.setEnabled(isModeSelected);
                    }
                });
            };
            for (SpringMode mode : supportedModes) {
                JRadioButton radioButton = new JRadioButton(mode.displayName);
                radioButton.setName(mode.displayName);
                if (mode.equals((Object)defaultMode)) {
                    radioButton.setSelected(true);
                }
                radioButton.addActionListener(actionListener);
                this.group.add(radioButton);
                this.modeSelectorPanel.add(radioButton);
                this.components.add(radioButton);
            }
            this.components.add(this.modeSelectorPanel);
        }

        private void addControlsForMode(SpringMode mode, SpringWidgetModel model2) {
            Collection<SpringParameter> parametersToAdd = mode.parameters;
            JPanel controlsPanel = new JPanel(new GridLayout(parametersToAdd.size() + 1, 1));
            for (SpringParameter parameter : parametersToAdd) {
                if (!SpringWidget.isUseSlider(parameter)) continue;
                JPanel line = new JPanel(new BorderLayout());
                JLabel title = new JLabel(this.spacing);
                title.setPreferredSize(title.getPreferredSize());
                title.setText(parameter.displayName);
                title.setHorizontalAlignment(4);
                SliderSpec sliderSpec = SpringWidget.getSliderSpec(parameter);
                if (sliderSpec == null) continue;
                int initialValue = (int)(this.getGraphValue(parameter) * (float)sliderSpec.scale);
                JSlider slider2 = new JSlider(sliderSpec.sliderMin, sliderSpec.sliderMax);
                slider2.setOpaque(false);
                JLabel value2 = new JLabel("XXXXXXX");
                value2.setOpaque(false);
                value2.setPreferredSize(value2.getPreferredSize());
                value2.setText("" + initialValue * sliderSpec.scale);
                line.add((Component)title, "West");
                line.add((Component)value2, "East");
                float rescale = sliderSpec.scale;
                slider2.addChangeListener(event -> {
                    float f = (float)slider2.getValue() / rescale;
                    f = (float)((int)(f * 10000.0f)) / 10000.0f;
                    value2.setText(Float.toString(f));
                    this.updateGraph(parameter, f, mode.equals((Object)SpringMode.SPRING_WITH_DAMP_RATIO));
                    if (!slider2.getValueIsAdjusting() && !this.isUpdatingFromModel.booleanValue()) {
                        this.updateModel(parameter, model2, f);
                    }
                });
                line.add(slider2);
                slider2.setValue(initialValue);
                this.parameterToSlider.put(parameter, slider2);
                this.components.add(slider2);
                this.components.add(value2);
                this.components.add(line);
                this.components.add(title);
                controlsPanel.add(line);
            }
            if (!mode.equals((Object)SpringMode.NORMAL)) {
                JPanel line = new JPanel(new BorderLayout());
                JLabel title = new JLabel(this.spacing);
                title.setPreferredSize(title.getPreferredSize());
                title.setText("Bounce");
                title.setHorizontalAlignment(4);
                JCheckBox checkBox = new JCheckBox();
                this.components.add(title);
                this.components.add(checkBox);
                this.components.add(line);
                checkBox.addActionListener(e -> this.myGraph.setBounce(checkBox.isSelected()));
                line.add((Component)title, "West");
                line.add(checkBox);
                controlsPanel.add(line);
            }
            this.components.add(controlsPanel);
            this.ctlCards.add((Component)controlsPanel, mode.displayName);
        }

        private float getGraphValue(SpringParameter parameter) {
            switch (parameter) {
                case MAX_ACC: {
                    return this.myGraph.getMaxAcceleration();
                }
                case MAX_VEL: {
                    return this.myGraph.getMaxVelocity();
                }
                case DURATION: {
                    return this.myGraph.getDuration() * 1000.0f;
                }
                case MASS: {
                    return this.myGraph.getMass();
                }
                case DAMPING: {
                    return this.myGraph.getDamping();
                }
                case STIFFNESS: {
                    return this.myGraph.getStiffness();
                }
                case THRESHOLD: {
                    return this.myGraph.getThreshold();
                }
                case DAMPING_RATIO: {
                    float stiffness = this.myGraph.getStiffness();
                    float damping = this.myGraph.getDamping();
                    return damping / (2.0f * (float)Math.sqrt(stiffness));
                }
            }
            return 1.0f;
        }

        private void updateGraph(SpringParameter parameter, float value2, boolean usesRatio) {
            switch (parameter) {
                case MAX_ACC: {
                    this.myGraph.setMaxAcceleration(value2);
                    break;
                }
                case MAX_VEL: {
                    this.myGraph.setMaxVelocity(value2);
                    break;
                }
                case DURATION: {
                    this.myGraph.setDuration(value2 / 1000.0f);
                    break;
                }
                case MASS: {
                    this.myGraph.setMass(value2);
                    break;
                }
                case DAMPING: {
                    this.myGraph.setDamping(value2);
                    break;
                }
                case STIFFNESS: {
                    if (!usesRatio) {
                        this.myGraph.setStiffness(value2);
                        break;
                    }
                    float oldStiffness = this.myGraph.getStiffness();
                    float oldDamping = this.myGraph.getDamping();
                    float dampingRatio = oldDamping / (2.0f * (float)Math.sqrt(oldStiffness));
                    float newDamping = 2.0f * (float)Math.sqrt(value2) * dampingRatio;
                    this.myGraph.setStiffness(value2);
                    this.myGraph.setDamping(newDamping);
                    break;
                }
                case THRESHOLD: {
                    this.myGraph.setThreshold(value2);
                    break;
                }
                case DAMPING_RATIO: {
                    float stiffness = this.myGraph.getStiffness();
                    this.myGraph.setMass(1.0f);
                    this.myGraph.setDamping(2.0f * (float)Math.sqrt(stiffness) * value2);
                    break;
                }
            }
        }

        private void updateAllGraph(HashMap<SpringParameter, Float> parametersValues) {
            block10: for (SpringParameter parameter : parametersValues.keySet()) {
                switch (parameter) {
                    case MAX_ACC: {
                        this.myGraph.setMaxAcceleration(parametersValues.get((Object)parameter).floatValue());
                        continue block10;
                    }
                    case MAX_VEL: {
                        this.myGraph.setMaxVelocity(parametersValues.get((Object)parameter).floatValue());
                        continue block10;
                    }
                    case DURATION: {
                        this.myGraph.setDuration(parametersValues.get((Object)parameter).floatValue() / 1000.0f);
                        continue block10;
                    }
                    case MASS: {
                        this.myGraph.setMass(parametersValues.get((Object)parameter).floatValue());
                        continue block10;
                    }
                    case DAMPING: {
                        this.myGraph.setDamping(parametersValues.get((Object)parameter).floatValue());
                        continue block10;
                    }
                    case STIFFNESS: {
                        float stiffness;
                        if (!parametersValues.containsKey((Object)SpringParameter.DAMPING_RATIO)) {
                            stiffness = parametersValues.get((Object)SpringParameter.STIFFNESS).floatValue();
                            this.myGraph.setStiffness(stiffness);
                            continue block10;
                        }
                        stiffness = parametersValues.get((Object)SpringParameter.STIFFNESS).floatValue();
                        float dampingRatio = parametersValues.get((Object)SpringParameter.DAMPING_RATIO).floatValue();
                        this.myGraph.setMass(1.0f);
                        this.myGraph.setDamping(2.0f * (float)Math.sqrt(stiffness) * dampingRatio);
                        this.myGraph.setStiffness(stiffness);
                        continue block10;
                    }
                    case THRESHOLD: {
                        this.myGraph.setThreshold(parametersValues.get((Object)parameter).floatValue());
                        continue block10;
                    }
                    case DAMPING_RATIO: {
                        float stiffness = parametersValues.get((Object)SpringParameter.STIFFNESS).floatValue();
                        float dampingRatio = parametersValues.get((Object)SpringParameter.DAMPING_RATIO).floatValue();
                        this.myGraph.setMass(1.0f);
                        this.myGraph.setDamping(2.0f * (float)Math.sqrt(stiffness) * dampingRatio);
                        this.myGraph.setStiffness(stiffness);
                        continue block10;
                    }
                }
            }
        }

        private void updateWidget(SpringWidgetModel model2) {
            this.isUpdatingFromModel = true;
            for (SpringParameter parameter : this.allParameters) {
                SliderSpec sliderSpec;
                JSlider slider2;
                String valueString = model2.getValue(parameter);
                Float value2 = StringsKt.toFloatOrNull((String)valueString);
                if (value2 == null || (slider2 = this.parameterToSlider.get((Object)parameter)) == null || (sliderSpec = SpringWidget.getSliderSpec(parameter)) == null) continue;
                slider2.setValue((int)(value2.floatValue() * (float)sliderSpec.scale));
            }
            this.isUpdatingFromModel = false;
        }
    }

    public static class StopLogicEngine {
        private float mStage1Velocity;
        private float mStage2Velocity;
        private float mStage3Velocity;
        private float mStage1Duration;
        private float mStage2Duration;
        private float mStage3Duration;
        private float mStage1EndPosition;
        private float mStage2EndPosition;
        private float mStage3EndPosition;
        private int mNumberOfStages;
        private String mType;
        private boolean mBackwards = false;
        private float mStartPosition;
        private float mLastPosition;
        private boolean mDone = false;
        private static final float EPSILON = 1.0E-5f;

        public String debug(String desc, float time) {
            String ret = desc + " ===== " + this.mType + "\n";
            ret = ret + desc + (this.mBackwards ? "backwards" : "forward ") + " time = " + time + "  stages " + this.mNumberOfStages + "\n";
            ret = ret + desc + " dur " + this.mStage1Duration + " vel " + this.mStage1Velocity + " pos " + this.mStage1EndPosition + "\n";
            if (this.mNumberOfStages > 1) {
                ret = ret + desc + " dur " + this.mStage2Duration + " vel " + this.mStage2Velocity + " pos " + this.mStage2EndPosition + "\n";
            }
            if (this.mNumberOfStages > 2) {
                ret = ret + desc + " dur " + this.mStage3Duration + " vel " + this.mStage3Velocity + " pos " + this.mStage3EndPosition + "\n";
            }
            if (time <= this.mStage1Duration) {
                ret = ret + desc + "stage 0\n";
                return ret;
            }
            if (this.mNumberOfStages == 1) {
                ret = ret + desc + "end stage 0\n";
                return ret;
            }
            if ((time -= this.mStage1Duration) < this.mStage2Duration) {
                ret = ret + desc + " stage 1\n";
                return ret;
            }
            if (this.mNumberOfStages == 2) {
                ret = ret + desc + "end stage 1\n";
                return ret;
            }
            if ((time -= this.mStage2Duration) < this.mStage3Duration) {
                ret = ret + desc + " stage 2\n";
                return ret;
            }
            ret = ret + desc + " end stage 2\n";
            return ret;
        }

        public float getVelocity(float x) {
            if (x <= this.mStage1Duration) {
                return this.mStage1Velocity + (this.mStage2Velocity - this.mStage1Velocity) * x / this.mStage1Duration;
            }
            if (this.mNumberOfStages == 1) {
                return 0.0f;
            }
            if ((x -= this.mStage1Duration) < this.mStage2Duration) {
                return this.mStage2Velocity + (this.mStage3Velocity - this.mStage2Velocity) * x / this.mStage2Duration;
            }
            if (this.mNumberOfStages == 2) {
                return this.mStage2EndPosition;
            }
            if ((x -= this.mStage2Duration) < this.mStage3Duration) {
                return this.mStage3Velocity - this.mStage3Velocity * x / this.mStage3Duration;
            }
            return this.mStage3EndPosition;
        }

        private float calcY(float time) {
            this.mDone = false;
            if (time <= this.mStage1Duration) {
                return this.mStage1Velocity * time + (this.mStage2Velocity - this.mStage1Velocity) * time * time / (2.0f * this.mStage1Duration);
            }
            if (this.mNumberOfStages == 1) {
                return this.mStage1EndPosition;
            }
            if ((time -= this.mStage1Duration) < this.mStage2Duration) {
                return this.mStage1EndPosition + this.mStage2Velocity * time + (this.mStage3Velocity - this.mStage2Velocity) * time * time / (2.0f * this.mStage2Duration);
            }
            if (this.mNumberOfStages == 2) {
                return this.mStage2EndPosition;
            }
            if ((time -= this.mStage2Duration) <= this.mStage3Duration) {
                return this.mStage2EndPosition + this.mStage3Velocity * time - this.mStage3Velocity * time * time / (2.0f * this.mStage3Duration);
            }
            this.mDone = true;
            return this.mStage3EndPosition;
        }

        public void config(float currentPos, float destination, float currentVelocity, float maxTime, float maxAcceleration, float maxVelocity) {
            this.mDone = false;
            this.mStartPosition = currentPos;
            boolean bl = this.mBackwards = currentPos > destination;
            if (this.mBackwards) {
                this.setup(-currentVelocity, currentPos - destination, maxAcceleration, maxVelocity, maxTime);
            } else {
                this.setup(currentVelocity, destination - currentPos, maxAcceleration, maxVelocity, maxTime);
            }
        }

        public float getInterpolation(float v) {
            float y = this.calcY(v);
            this.mLastPosition = v;
            return this.mBackwards ? this.mStartPosition - y : this.mStartPosition + y;
        }

        public float getVelocity() {
            return this.mBackwards ? -this.getVelocity(this.mLastPosition) : this.getVelocity(this.mLastPosition);
        }

        public boolean isStopped() {
            return this.getVelocity() < 1.0E-5f && Math.abs(this.mStage3EndPosition - this.mLastPosition) < 1.0E-5f;
        }

        private void setup(float velocity, float distance, float maxAcceleration, float maxVelocity, float maxTime) {
            this.mDone = false;
            if (velocity == 0.0f) {
                velocity = 1.0E-4f;
            }
            this.mStage1Velocity = velocity;
            float min_time_to_stop = velocity / maxAcceleration;
            float stopDistance = min_time_to_stop * velocity / 2.0f;
            if (velocity < 0.0f) {
                float timeToZeroVelocity = -velocity / maxAcceleration;
                float reversDistanceTraveled = timeToZeroVelocity * velocity / 2.0f;
                float totalDistance = distance - reversDistanceTraveled;
                float peak_v = (float)Math.sqrt(maxAcceleration * totalDistance);
                if (peak_v < maxVelocity) {
                    this.mType = "backward accelerate, decelerate";
                    this.mNumberOfStages = 2;
                    this.mStage1Velocity = velocity;
                    this.mStage2Velocity = peak_v;
                    this.mStage3Velocity = 0.0f;
                    this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
                    this.mStage2Duration = peak_v / maxAcceleration;
                    this.mStage1EndPosition = (velocity + peak_v) * this.mStage1Duration / 2.0f;
                    this.mStage2EndPosition = distance;
                    this.mStage3EndPosition = distance;
                    return;
                }
                this.mType = "backward accelerate cruse decelerate";
                this.mNumberOfStages = 3;
                this.mStage1Velocity = velocity;
                this.mStage2Velocity = maxVelocity;
                this.mStage3Velocity = maxVelocity;
                this.mStage1Duration = (maxVelocity - velocity) / maxAcceleration;
                this.mStage3Duration = maxVelocity / maxAcceleration;
                float accDist = (velocity + maxVelocity) * this.mStage1Duration / 2.0f;
                float decDist = maxVelocity * this.mStage3Duration / 2.0f;
                this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
                this.mStage1EndPosition = accDist;
                this.mStage2EndPosition = distance - decDist;
                this.mStage3EndPosition = distance;
                return;
            }
            if (stopDistance >= distance) {
                this.mType = "hard stop";
                float time = 2.0f * distance / velocity;
                this.mNumberOfStages = 1;
                this.mStage1Velocity = velocity;
                this.mStage2Velocity = 0.0f;
                this.mStage1EndPosition = distance;
                this.mStage1Duration = time;
                return;
            }
            float distance_before_break = distance - stopDistance;
            float cruseTime = distance_before_break / velocity;
            if (cruseTime + min_time_to_stop < maxTime) {
                this.mType = "cruse decelerate";
                this.mNumberOfStages = 2;
                this.mStage1Velocity = velocity;
                this.mStage2Velocity = velocity;
                this.mStage3Velocity = 0.0f;
                this.mStage1EndPosition = distance_before_break;
                this.mStage2EndPosition = distance;
                this.mStage1Duration = cruseTime;
                this.mStage2Duration = velocity / maxAcceleration;
                return;
            }
            float peak_v = (float)Math.sqrt(maxAcceleration * distance + velocity * velocity / 2.0f);
            this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
            this.mStage2Duration = peak_v / maxAcceleration;
            if (peak_v < maxVelocity) {
                this.mType = "accelerate decelerate";
                this.mNumberOfStages = 2;
                this.mStage1Velocity = velocity;
                this.mStage2Velocity = peak_v;
                this.mStage3Velocity = 0.0f;
                this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
                this.mStage2Duration = peak_v / maxAcceleration;
                this.mStage1EndPosition = (velocity + peak_v) * this.mStage1Duration / 2.0f;
                this.mStage2EndPosition = distance;
                return;
            }
            this.mType = "accelerate cruse decelerate";
            this.mNumberOfStages = 3;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = maxVelocity;
            this.mStage3Velocity = maxVelocity;
            this.mStage1Duration = (maxVelocity - velocity) / maxAcceleration;
            this.mStage3Duration = maxVelocity / maxAcceleration;
            float accDist = (velocity + maxVelocity) * this.mStage1Duration / 2.0f;
            float decDist = maxVelocity * this.mStage3Duration / 2.0f;
            this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
            this.mStage1EndPosition = accDist;
            this.mStage2EndPosition = distance - decDist;
            this.mStage3EndPosition = distance;
        }
    }

    static class ColorGen {
        double sx;
        double sy;
        double count = 0.0;

        ColorGen() {
        }

        Color getColor() {
            double angle;
            float hue;
            if (this.count < 1.0) {
                hue = (float)Math.random();
                angle = (double)hue * Math.PI * 2.0;
            } else {
                angle = Math.toRadians(180.0) + Math.atan2(this.sy, this.sx);
                hue = (float)(angle / (Math.PI * 2));
            }
            this.sx += Math.cos(angle);
            this.sy += Math.sin(angle);
            this.count += 1.0;
            return Color.getHSBColor(hue, 0.9f, 0.8f);
        }
    }

    class BasicPlot
    implements PlotItem {
        private float old_min_draw_y;
        private int[] tmpX = new int[0];
        private int[] tmpY = new int[0];
        int[] xp = new int[0];
        int[] yp = new int[0];
        Color color = Color.BLACK;
        Stroke stroke = new BasicStroke(1.5f, 1, 1);
        float[] xPoints;
        float[] yPoints;

        @Override
        public float[] getX() {
            return this.xPoints;
        }

        @Override
        public float[] getY() {
            return this.yPoints;
        }

        BasicPlot(float[] x, float[] y, Color c) {
            this.color = c;
            this.xPoints = x;
            this.yPoints = y;
        }

        @Override
        public void paint(Graphics2D g, int w, int h) {
            if (this.xPoints.length == 0) {
                return;
            }
            int draw_width = w - SpringWidget.this.plotInfo.ins_left - SpringWidget.this.plotInfo.ins_right;
            int draw_height = h - SpringWidget.this.plotInfo.ins_top - SpringWidget.this.plotInfo.ins_bottom;
            if (this.xp.length < this.xPoints.length * 2) {
                this.xp = new int[this.xPoints.length * 2];
                this.yp = new int[this.xPoints.length * 2];
                this.tmpX = new int[this.xPoints.length * 2 + 2];
                this.tmpY = new int[this.xPoints.length * 2 + 2];
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.color);
            g.setStroke(this.stroke);
            float y0 = (float)draw_height * (1.0f - (0.0f - SpringWidget.this.plotInfo.miny) / (SpringWidget.this.plotInfo.maxy - SpringWidget.this.plotInfo.miny)) + (float)SpringWidget.this.plotInfo.ins_top;
            for (int i = 0; i < this.xPoints.length; ++i) {
                float x = (float)draw_width * (this.xPoints[i] - SpringWidget.this.plotInfo.minx) / (SpringWidget.this.plotInfo.maxx - SpringWidget.this.plotInfo.minx) + (float)SpringWidget.this.plotInfo.ins_left;
                float y = (float)draw_height * (1.0f - (this.yPoints[i] - SpringWidget.this.plotInfo.miny) / (SpringWidget.this.plotInfo.maxy - SpringWidget.this.plotInfo.miny)) + (float)SpringWidget.this.plotInfo.ins_top;
                this.xp[i] = (int)x;
                this.yp[i] = (int)y;
            }
            g.drawPolyline(this.xp, this.yp, this.xPoints.length);
        }
    }

    static interface PlotItem
    extends DrawItem {
        public float[] getX();

        public float[] getY();
    }

    static interface Function {
        public double f(double var1);
    }

    static class plotInfo {
        boolean draw_axis = true;
        boolean draw_grid = true;
        int mTextGap = 2;
        int ins_top = 20;
        int ins_left = 25;
        int ins_bottom = 25;
        int ins_right = 20;
        float actual_miny;
        float actual_maxx;
        float actual_maxy;
        float actual_minx;
        private float last_minx;
        private float mTickY;
        private float mTickX;
        private float minx;
        private float last_maxx;
        private float maxx;
        private float maxy;
        private float miny;
        private float last_miny;
        private float last_maxy;

        plotInfo() {
        }

        float getY(int h, float y) {
            int draw_height = h - this.ins_top - this.ins_bottom;
            return (float)draw_height * (1.0f - (y - this.miny) / (this.maxy - this.miny)) + (float)this.ins_top;
        }

        float getX(int w, float x) {
            int draw_width = w - this.ins_left - this.ins_right;
            return (float)draw_width * (x - this.minx) / (this.maxx - this.minx) + (float)this.ins_left;
        }

        void calcRangeTicks(int width, int height) {
            double dx = this.actual_maxx - this.actual_minx;
            double dy = this.actual_maxy - this.actual_miny;
            double border = 1.09345;
            if (Double.isInfinite(dx) || Double.isInfinite(dy)) {
                return;
            }
            this.mTickX = (float)com.android.tools.idea.uibuilder.property.ui.spring.SpringWidget$plotInfo.calcTick(width, dx);
            dx = (double)this.mTickX * Math.ceil(border * dx / (double)this.mTickX);
            double tx = ((double)(this.actual_minx + this.actual_maxx) - dx) / 2.0;
            tx = (double)this.mTickX * Math.floor(tx / (double)this.mTickX);
            this.minx = 0.0f;
            tx = ((double)(this.actual_minx + this.actual_maxx) + dx) / 2.0;
            tx = (double)this.mTickX * Math.ceil(tx / (double)this.mTickX);
            this.maxx = (float)tx;
            this.last_minx = this.actual_minx;
            this.last_maxx = this.actual_maxx;
            this.mTickY = (float)com.android.tools.idea.uibuilder.property.ui.spring.SpringWidget$plotInfo.calcTick(height, dy);
            dy = (double)this.mTickY * Math.ceil(border * dy / (double)this.mTickY);
            double ty = ((double)(this.actual_miny + this.actual_maxy) - dy) / 2.0;
            ty = (double)this.mTickY * Math.floor(ty / (double)this.mTickY);
            this.miny = 0.0f;
            ty = ((double)(this.actual_miny + this.actual_maxy) + dy) / 2.0;
            ty = (double)this.mTickY * Math.ceil(ty / (double)this.mTickY);
            this.maxy = (float)ty;
            this.last_miny = this.actual_miny;
            this.last_maxy = this.actual_maxy;
        }

        private static double frac(double x) {
            return x - Math.floor(x);
        }

        public static double calcTick(int scr, double range) {
            int aprox_x_ticks = scr / 200;
            int type = 1;
            double best = Math.log10(range / (double)aprox_x_ticks);
            double n = Math.log10(range / (double)(aprox_x_ticks * 2));
            if (com.android.tools.idea.uibuilder.property.ui.spring.SpringWidget$plotInfo.frac(n) < com.android.tools.idea.uibuilder.property.ui.spring.SpringWidget$plotInfo.frac(best)) {
                best = n;
                type = 2;
            }
            if (com.android.tools.idea.uibuilder.property.ui.spring.SpringWidget$plotInfo.frac(n = Math.log10(range / (double)(aprox_x_ticks * 5))) < com.android.tools.idea.uibuilder.property.ui.spring.SpringWidget$plotInfo.frac(best)) {
                best = n;
                type = 5;
            }
            return (double)type * Math.pow(10.0, Math.floor(best));
        }

        public void setRange(float minx, float maxx, float miny, float maxy) {
            this.actual_maxx = maxx;
            this.actual_maxy = maxy;
            this.actual_minx = minx;
            this.actual_miny = miny;
        }

        public void calcRange(ArrayList<PlotItem> plotDraw) {
            this.resetRange();
            for (PlotItem plotItem : plotDraw) {
                this.measure(plotItem.getX(), plotItem.getY());
            }
            this.setRange(this.minx, this.maxx, this.miny, this.maxy);
        }

        public void resetRange() {
            this.minx = Float.MAX_VALUE;
            this.miny = Float.MAX_VALUE;
            this.maxx = -3.4028235E38f;
            this.maxy = -3.4028235E38f;
        }

        void measure(float[] xPoints, float[] yPoints) {
            if (xPoints == null | yPoints == null) {
                return;
            }
            for (int i = 0; i < xPoints.length; ++i) {
                float x = xPoints[i];
                float y = yPoints[i];
                this.minx = Math.min(this.minx, x);
                this.miny = Math.min(this.miny, y);
                this.maxx = Math.max(this.maxx, x);
                this.maxy = Math.max(this.maxy, y);
            }
            if (Float.isInfinite(this.miny)) {
                this.miny = -0.2f;
                SpringWidget.log("!");
            }
            if (Float.isInfinite(this.maxy)) {
                this.maxy = 1.2f;
                SpringWidget.log("!");
            }
        }
    }

    static interface DrawItem {
        public void paint(Graphics2D var1, int var2, int var3);
    }
}

