/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.panel.api.HelpSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.html.HtmlEscapers;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/uibuilder/property/support/HelpActions;", "", "()V", "help", "Lcom/intellij/openapi/actionSystem/AnAction;", "getHelp", "()Lcom/intellij/openapi/actionSystem/AnAction;", "lineEndingRegex", "Lkotlin/text/Regex;", "secondaryHelp", "getSecondaryHelp", "createHelpText", "", "property", "Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "allowEmptyDescription", "", "filterRawAttributeComment", "comment", "findNamespacePrefix", "getAttributeAnchor", "componentName", "getHelpUrl", "toHelpUrl", "intellij.android.designer"})
public final class HelpActions {
    @NotNull
    private static final AnAction help;
    @NotNull
    private static final AnAction secondaryHelp;
    private static final Regex lineEndingRegex;
    @NotNull
    public static final HelpActions INSTANCE;

    @NotNull
    public final AnAction getHelp() {
        return help;
    }

    @NotNull
    public final AnAction getSecondaryHelp() {
        return secondaryHelp;
    }

    @VisibleForTesting
    @Nullable
    public final String toHelpUrl(@NotNull String componentName, @NotNull NlPropertyItem property) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string2 = this.getAttributeAnchor(componentName, property);
        if (string2 == null) {
            return null;
        }
        String anchor = string2;
        return this.getHelpUrl(componentName, property) + anchor;
    }

    private final String getHelpUrl(String componentName, NlPropertyItem property) {
        String dotLayoutParams = Intrinsics.areEqual((Object)componentName, (Object)"android.view.ViewGroup") && StringsKt.startsWith$default((String)property.getName(), (String)"layout_margin", (boolean)false, (int)2, null) ? ".MarginLayoutParams" : (StringsKt.startsWith$default((String)property.getName(), (String)"layout_", (boolean)false, (int)2, null) ? ".LayoutParams" : "");
        return "https://developer.android.com/reference/" + StringsKt.replace$default((String)componentName, (char)'.', (char)'/', (boolean)false, (int)4, null) + dotLayoutParams + ".html";
    }

    private final String getAttributeAnchor(String componentName, NlPropertyItem property) {
        return StringsKt.startsWith$default((String)componentName, (String)"android.view.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)componentName, (String)"android.widget.", (boolean)false, (int)2, null) ? "#attr_android:" + property.getName() : (StringsKt.startsWith$default((String)componentName, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)componentName, (String)"androidx.", (boolean)false, (int)2, null) ? "" : null);
    }

    @NlsSafe
    @NotNull
    public final String createHelpText(@NotNull NlPropertyItem property, boolean allowEmptyDescription) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Object object = property.getDefinition();
        if (object == null || (object = object.getDescription(null)) == null) {
            object = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"property.definition?.getDescription(null) ?: \"\"");
        String description = this.filterRawAttributeComment((String)object);
        CharSequence charSequence = description;
        if (charSequence.length() == 0 && !allowEmptyDescription) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("<html><b>");
        sb.append(this.findNamespacePrefix(property));
        sb.append(property.getName());
        CharSequence charSequence2 = description;
        if (charSequence2.length() == 0) {
            sb.append("</b>");
        } else {
            sb.append(":</b><br/>");
            sb.append(description);
        }
        sb.append("</html>");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    private final String findNamespacePrefix(NlPropertyItem property) {
        ResourceNamespace.Resolver resolver = property.getNamespaceResolver();
        if (Intrinsics.areEqual((Object)resolver, (Object)ResourceNamespace.Resolver.TOOLS_ONLY) && Intrinsics.areEqual((Object)property.getNamespace(), (Object)"http://schemas.android.com/apk/res/android")) {
            return "android:";
        }
        String string2 = resolver.uriToPrefix(property.getNamespace());
        if (string2 == null) {
            return "";
        }
        String prefix = string2;
        return prefix + ":";
    }

    @VisibleForTesting
    @NotNull
    public final String filterRawAttributeComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        CharSequence charSequence = comment;
        Regex regex = lineEndingRegex;
        String string2 = " ";
        String string3 = HtmlEscapers.htmlEscaper().escape(regex.replace(charSequence, string2));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"HtmlEscapers.htmlEscaper\u2026ce(lineEndingRegex, \" \"))");
        return string3;
    }

    private HelpActions() {
    }

    static {
        HelpActions helpActions;
        INSTANCE = helpActions = new HelpActions();
        help = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NlPropertyItem nlPropertyItem = (NlPropertyItem)event.getDataContext().getData(HelpSupport.Companion.getPROPERTY_ITEM());
                if (nlPropertyItem == null) {
                    return;
                }
                NlPropertyItem property = nlPropertyItem;
                XmlTag xmlTag = ((NlComponent)CollectionsKt.first(property.getComponents())).getBackend().getTag();
                if (xmlTag == null) {
                    return;
                }
                XmlTag tag = xmlTag;
                String string2 = StringKt.nullize$default((String)HelpActions.INSTANCE.createHelpText(property, false), (boolean)false, (int)1, null);
                if (string2 == null) {
                    return;
                }
                String documentation = string2;
                DocumentationManager.getInstance((Project)property.getProject()).showJavaDocInfo((PsiElement)tag, (PsiElement)tag, true, null, documentation, true);
            }
        };
        secondaryHelp = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NlPropertyItem property = (NlPropertyItem)event.getDataContext().getData(HelpSupport.Companion.getPROPERTY_ITEM());
                Object object = property;
                if (object == null || (object = ((NlPropertyItem)object).getComponentName()) == null) {
                    return;
                }
                Object componentName = object;
                String string2 = HelpActions.INSTANCE.toHelpUrl((String)componentName, property);
                if (string2 == null) {
                    return;
                }
                String url = string2;
                BrowserUtil.browse((String)url);
            }
        };
        lineEndingRegex = new Regex("\n *");
    }
}

