/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.PropertyComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.inspector.InspectorUtilKt;
import com.android.tools.idea.uibuilder.property.inspector.SampleCustomPanel;
import com.android.tools.property.panel.api.EditorProvider;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertyItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J \u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J \u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J\u0006\u0010 \u001a\u00020\u0010J \u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/uibuilder/property/inspector/ViewInspectorBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "editorProvider", "Lcom/android/tools/property/panel/api/EditorProvider;", "Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/property/panel/api/EditorProvider;)V", "cachedCustomPanels", "", "", "Lcom/android/tools/idea/uibuilder/api/CustomPanel;", "viewHandlerManager", "Lcom/android/tools/idea/uibuilder/handlers/ViewHandlerManager;", "Lorg/jetbrains/annotations/NotNull;", "attachToInspector", "", "inspector", "Lcom/android/tools/property/panel/api/InspectorPanel;", "properties", "Lcom/android/tools/property/panel/api/PropertiesTable;", "getTitleLine", "Lkotlin/Function0;", "Lcom/android/tools/property/panel/api/InspectorLineModel;", "createCustomPanel", "tagName", "findProperty", "propertyName", "findPropertyByName", "attrName", "getFirstComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "resetCache", "setupCustomPanel", "Ljavax/swing/JPanel;", "Companion", "intellij.android.designer"})
public final class ViewInspectorBuilder {
    private final ViewHandlerManager viewHandlerManager;
    private final Map<String, CustomPanel> cachedCustomPanels;
    private final EditorProvider<NlPropertyItem> editorProvider;
    private static final List<String> TAG_EXCEPTIONS;
    @NotNull
    public static final Companion Companion;

    public final void resetCache() {
        this.cachedCustomPanels.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<NlPropertyItem> properties, @NotNull Function0<? extends InspectorLineModel> getTitleLine) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)inspector, (String)"inspector");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(getTitleLine, (String)"getTitleLine");
        String string2 = InspectorUtilKt.getTagName(properties);
        if (string2 == null) {
            return;
        }
        String tagName = string2;
        if (TAG_EXCEPTIONS.contains(tagName)) {
            return;
        }
        NlComponent nlComponent = this.getFirstComponent(properties);
        if (nlComponent == null) {
            return;
        }
        NlComponent firstComponent = nlComponent;
        ViewHandler viewHandler = this.viewHandlerManager.getHandler(firstComponent);
        if (viewHandler == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)viewHandler, (String)"viewHandlerManager.getHa\u2026firstComponent) ?: return");
        ViewHandler handler = viewHandler;
        List<String> list = handler.getInspectorProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"handler.inspectorProperties");
        List<String> attributes = list;
        JPanel custom = this.setupCustomPanel(tagName, properties);
        if (attributes.isEmpty() && custom == null) {
            return;
        }
        InspectorLineModel titleLine = (InspectorLineModel)getTitleLine.invoke();
        if (custom != null) {
            inspector.addComponent((JComponent)custom, titleLine);
        }
        Iterable iterable = attributes;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)"visibility") ^ true && Intrinsics.areEqual((Object)it, (Object)"alpha") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NlPropertyItem nlPropertyItem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
            if (this.findProperty(string3, properties) == null) continue;
            NlPropertyItem it$iv$iv = nlPropertyItem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            NlPropertyItem it = (NlPropertyItem)element$iv;
            boolean bl = false;
            inspector.addEditor(EditorProvider.DefaultImpls.createEditor$default(this.editorProvider, (PropertyItem)it, (boolean)false, (int)2, null), titleLine);
        }
    }

    private final NlPropertyItem findProperty(String propertyName, PropertiesTable<NlPropertyItem> properties) {
        NlPropertyItem nlPropertyItem;
        String string2 = StringUtil.trimStart((String)propertyName, (String)"tools:");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.trimStart(pro\u2026me, TOOLS_NS_NAME_PREFIX)");
        String attrName = string2;
        NlPropertyItem property = this.findPropertyByName(attrName, properties);
        boolean isDesignProperty = StringsKt.startsWith$default((String)propertyName, (String)"tools:", (boolean)false, (int)2, null);
        if (isDesignProperty) {
            nlPropertyItem = property;
            if (nlPropertyItem == null || (nlPropertyItem = nlPropertyItem.getDesignProperty()) == null) {
                nlPropertyItem = (NlPropertyItem)properties.getOrNull("http://schemas.android.com/tools", attrName);
            }
        } else {
            nlPropertyItem = property;
        }
        return nlPropertyItem;
    }

    private final NlPropertyItem findPropertyByName(String attrName, PropertiesTable<NlPropertyItem> properties) {
        NlPropertyItem nlPropertyItem;
        NlPropertyItem srcCompat;
        if (Intrinsics.areEqual((Object)attrName, (Object)"src") && (srcCompat = (NlPropertyItem)properties.getOrNull("http://schemas.android.com/apk/res-auto", "srcCompat")) != null) {
            return srcCompat;
        }
        NlPropertyItem nlPropertyItem2 = (NlPropertyItem)properties.getOrNull("http://schemas.android.com/apk/res/android", attrName);
        if (nlPropertyItem2 == null) {
            nlPropertyItem2 = nlPropertyItem = (NlPropertyItem)properties.getOrNull("http://schemas.android.com/apk/res-auto", attrName);
        }
        if (nlPropertyItem2 == null) {
            nlPropertyItem = (NlPropertyItem)properties.getOrNull("", attrName);
        }
        return nlPropertyItem;
    }

    private final NlComponent getFirstComponent(PropertiesTable<NlPropertyItem> properties) {
        Object object = (NlPropertyItem)properties.getFirst();
        return object != null && (object = ((NlPropertyItem)object).getComponents()) != null ? (NlComponent)CollectionsKt.firstOrNull((List)object) : null;
    }

    private final JPanel setupCustomPanel(String tagName, PropertiesTable<NlPropertyItem> properties) {
        CustomPanel panel2;
        CustomPanel customPanel = this.cachedCustomPanels.get(tagName);
        if (customPanel == null) {
            customPanel = panel2 = this.createCustomPanel(tagName);
        }
        if (Intrinsics.areEqual((Object)panel2, (Object)SampleCustomPanel.INSTANCE)) {
            return null;
        }
        NlPropertyItem nlPropertyItem = (NlPropertyItem)properties.getFirst();
        if (nlPropertyItem == null) {
            return null;
        }
        NlPropertyItem property = nlPropertyItem;
        NlComponent nlComponent = (NlComponent)CollectionsKt.singleOrNull(property.getComponents());
        if (nlComponent == null) {
            return null;
        }
        NlComponent component = nlComponent;
        panel2.useComponent(component, property.getModel().getSurface());
        return panel2.getPanel();
    }

    private final CustomPanel createCustomPanel(String tagName) {
        ViewHandler handler = this.viewHandlerManager.getHandler(tagName);
        Object object = handler;
        if (object == null || (object = ((PropertyComponentHandler)object).getCustomPanel()) == null) {
            object = SampleCustomPanel.INSTANCE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"handler?.customPanel ?: SampleCustomPanel.INSTANCE");
        Object panel2 = object;
        this.cachedCustomPanels.put(tagName, (CustomPanel)panel2);
        return panel2;
    }

    public ViewInspectorBuilder(@NotNull Project project, @NotNull EditorProvider<? super NlPropertyItem> editorProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(editorProvider, (String)"editorProvider");
        this.editorProvider = editorProvider;
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
        Intrinsics.checkNotNullExpressionValue((Object)viewHandlerManager, (String)"ViewHandlerManager.get(project)");
        this.viewHandlerManager = viewHandlerManager;
        this.cachedCustomPanels = new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        TAG_EXCEPTIONS = CollectionsKt.listOf((Object[])new String[]{"TextView", "ProgressBar"});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/uibuilder/property/inspector/ViewInspectorBuilder$Companion;", "", "()V", "TAG_EXCEPTIONS", "", "", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

