/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.SdkConstants;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0007\u001a\u0012\u0010\u000f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"CUSTOM_DENSITY_ID", "", "updateConfigurationScreenSize", "", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "xDimension", "", "yDimension", "original", "Lcom/android/sdklib/devices/Device;", "currentActivityIsDerivedFromAppCompatActivity", "", "Lcom/android/tools/idea/common/model/NlModel;", "moduleDependsOnAppCompat", "overrideConfigurationDensity", "density", "Lcom/android/resources/Density;", "intellij.android.designer"})
public final class NlModelHelperKt {
    @NotNull
    public static final String CUSTOM_DENSITY_ID = "Custom Density";

    @JvmOverloads
    public static final void updateConfigurationScreenSize(@NotNull Configuration configuration, int xDimension, int yDimension, @Nullable Device original) {
        Device device;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (original == null) {
            return;
        }
        Device.Builder deviceBuilder = new Device.Builder(original);
        deviceBuilder.setTagId(original.getTagId());
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device2 = device = deviceBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)device2, (String)"device");
        Iterator iterator = device2.getAllStates().iterator();
        while (iterator.hasNext()) {
            Screen screen;
            State state;
            State state2 = state = (State)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)state2, (String)"state");
            Hardware hardware = state2.getHardware();
            Intrinsics.checkNotNullExpressionValue((Object)hardware, (String)"state.hardware");
            Screen screen2 = screen = hardware.getScreen();
            Intrinsics.checkNotNullExpressionValue((Object)screen2, (String)"screen");
            screen2.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            Density density = screen.getPixelDensity();
            Intrinsics.checkNotNullExpressionValue((Object)density, (String)"screen.pixelDensity");
            double dpi = density.getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(ScreenSize.getScreenSize((Double)diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio((int)xDimension, (int)yDimension));
            Hardware hardware2 = device.getDefaultHardware();
            Intrinsics.checkNotNullExpressionValue((Object)hardware2, (String)"device.defaultHardware");
            Screen screen3 = hardware2.getScreen();
            Intrinsics.checkNotNullExpressionValue((Object)screen3, (String)"device.defaultHardware.screen");
            screen.setScreenRound(screen3.getScreenRound());
            Hardware hardware3 = device.getDefaultHardware();
            Intrinsics.checkNotNullExpressionValue((Object)hardware3, (String)"device.defaultHardware");
            Screen screen4 = hardware3.getScreen();
            Intrinsics.checkNotNullExpressionValue((Object)screen4, (String)"device.defaultHardware.screen");
            screen.setChin(screen4.getChin());
        }
        State newState2 = xDimension > yDimension ? device.getState("Landscape") : device.getState("Portrait");
        configuration.setEffectiveDevice(device, newState2);
    }

    public static /* synthetic */ void updateConfigurationScreenSize$default(Configuration configuration, int n, int n2, Device device, int n3, Object object) {
        if ((n3 & 8) != 0) {
            device = configuration.getCachedDevice();
        }
        NlModelHelperKt.updateConfigurationScreenSize(configuration, n, n2, device);
    }

    @JvmOverloads
    public static final void updateConfigurationScreenSize(@NotNull Configuration configuration, int xDimension, int yDimension) {
        NlModelHelperKt.updateConfigurationScreenSize$default(configuration, xDimension, yDimension, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationDensity(@NotNull NlModel $this$overrideConfigurationDensity, @NotNull Density density) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Device device;
        Intrinsics.checkNotNullParameter((Object)$this$overrideConfigurationDensity, (String)"$this$overrideConfigurationDensity");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Configuration configuration = $this$overrideConfigurationDensity.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
        Device device2 = configuration.getCachedDevice();
        if (device2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)device2, (String)"configuration.cachedDevice ?: return");
        Device original = device2;
        Device.Builder deviceBuilder = new Device.Builder(original);
        deviceBuilder.setTagId(original.getTagId());
        deviceBuilder.setName("Custom");
        deviceBuilder.setId(CUSTOM_DENSITY_ID);
        Device device3 = device = deviceBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)device3, (String)"device");
        List list = device3.getAllStates();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"device.allStates");
        Iterable iterable = list;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            Hardware hardware = v4.getHardware();
            Intrinsics.checkNotNullExpressionValue((Object)hardware, (String)"it.hardware");
            Screen screen = hardware.getScreen();
            collection.add(screen);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Screen it = (Screen)element$iv;
            boolean bl = false;
            Screen screen = it;
            Intrinsics.checkNotNullExpressionValue((Object)screen, (String)"it");
            screen.setPixelDensity(density);
        }
        $this$overrideConfigurationDensity.getConfiguration().setEffectiveDevice(device, device.getDefaultState());
    }

    @Deprecated(message="Use NlModel.module.dependsOnAppCompat()", replaceWith=@ReplaceWith(imports={}, expression="com.android.tools.idea.util.dependsOnAppCompat()"))
    public static final boolean moduleDependsOnAppCompat(@NotNull NlModel $this$moduleDependsOnAppCompat) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleDependsOnAppCompat, (String)"$this$moduleDependsOnAppCompat");
        Module module = $this$moduleDependsOnAppCompat.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
        return DependencyManagementUtil.dependsOnAppCompat((Module)module);
    }

    public static final boolean currentActivityIsDerivedFromAppCompatActivity(@NotNull NlModel $this$currentActivityIsDerivedFromAppCompatActivity) {
        PsiClass activityClass;
        Intrinsics.checkNotNullParameter((Object)$this$currentActivityIsDerivedFromAppCompatActivity, (String)"$this$currentActivityIsDerivedFromAppCompatActivity");
        Configuration configuration = $this$currentActivityIsDerivedFromAppCompatActivity.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
        String string2 = configuration.getActivity();
        if (string2 == null) {
            return true;
        }
        Object activityClassName = string2;
        String string3 = activityClassName;
        Intrinsics.checkNotNull((Object)string3);
        if (StringsKt.startsWith$default((String)string3, (String)".", (boolean)false, (int)2, null)) {
            AndroidFacet androidFacet = $this$currentActivityIsDerivedFromAppCompatActivity.getFacet();
            Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"facet");
            String string4 = StringUtil.notNullize((String)AndroidManifestUtils.getPackageName((AndroidFacet)androidFacet));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringUtil.notNullize(getPackageName(facet))");
            String pkg = string4;
            activityClassName = pkg + (String)activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$this$currentActivityIsDerivedFromAppCompatActivity.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)$this$currentActivityIsDerivedFromAppCompatActivity.getModule(), (String)"module");
        for (activityClass = facade.findClass((String)activityClassName, (v3403697).getModuleScope()); activityClass != null && !SdkConstants.CLASS_APP_COMPAT_ACTIVITY.isEquals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }
}

