/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.utils.SdkUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class IncludeTagCreator
extends SimpleViewCreator {
    private String myNewLayoutResource;

    public IncludeTagCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            IncludeTagCreator.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            IncludeTagCreator.$$$reportNull$$$0(1);
        }
        if (screenView == null) {
            IncludeTagCreator.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            IncludeTagCreator.$$$reportNull$$$0(3);
        }
        super(mockup, model2, screenView, selection);
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(4);
        }
        this.myNewLayoutResource = this.createNewIncludedLayout();
        super.addAttributes(transaction);
        if (this.myNewLayoutResource != null) {
            IncludeTagCreator.addIncludeAttribute(transaction, this.myNewLayoutResource);
        }
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return "include";
    }

    @Override
    public NlComponent addToModel() {
        NlComponent component = this.getMockup().getComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_RECYCLER_VIEW_V7)) {
            this.addListItemAttribute(component);
            return component;
        }
        return super.addToModel();
    }

    private void addListItemAttribute(NlComponent component) {
        String newLayoutResource = this.createNewIncludedLayout();
        NlWriteCommandActionUtil.run(component, "Add listitem attribute", () -> component.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + newLayoutResource));
    }

    private static void addIncludeAttribute(@NotNull AttributesTransaction transaction, @NotNull String resourceName) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(5);
        }
        if (resourceName == null) {
            IncludeTagCreator.$$$reportNull$$$0(6);
        }
        transaction.setAttribute(null, "layout", "@layout/" + resourceName);
    }

    private String createNewIncludedLayout() {
        AndroidFacet facet = this.getMockup().getComponent().getModel().getFacet();
        XmlFile newFile = CreateResourceFileAction.createFileResource((AndroidFacet)facet, (ResourceFolderType)ResourceFolderType.LAYOUT, null, null, null, (boolean)true, null, null, null, (boolean)false);
        if (newFile == null) {
            return null;
        }
        XmlTag rootTag = newFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        DesignSurface surface2 = this.getScreenView().getSurface();
        final LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
        if (manager != null) {
            VirtualFile virtualFile = newFile.getVirtualFile();
            final NlModel model2 = NlModel.builder(facet, virtualFile, ConfigurationManager.getOrCreateInstance((AndroidFacet)facet).getConfiguration(virtualFile)).withParentDisposable((Disposable)newFile.getProject()).withComponentRegistrar(this.getScreenView().getSceneManager().getModel().getComponentRegistrar()).build();
            manager.addRenderListener(new RenderListener(){

                @Override
                public void onRenderCompleted() {
                    manager.removeRenderListener(this);
                    if (model2.getComponents().isEmpty()) {
                        return;
                    }
                    NlComponent component = (NlComponent)model2.getComponents().get(0);
                    AttributesTransaction transaction = component.startAttributeTransaction();
                    IncludeTagCreator.this.addShowInAttribute(transaction);
                    IncludeTagCreator.this.addSizeAttributes(transaction, IncludeTagCreator.this.getAndroidBounds());
                    IncludeTagCreator.this.addMockupAttributes(transaction, IncludeTagCreator.this.getSelectionBounds());
                    NlWriteCommandActionUtil.run(component, "", transaction::commit);
                }
            });
        }
        return SdkUtils.fileNameToResourceName((String)newFile.getName());
    }

    private void addShowInAttribute(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(7);
        }
        String showInName = SdkUtils.fileNameToResourceName((String)this.getModel().getFile().getName());
        transaction.setAttribute("http://schemas.android.com/tools", "showIn", "@layout/" + showInName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addIncludeAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addShowInAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

