/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.adtui.device.DeviceArtPainter;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdManagerUtils;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceSelectionPopup
extends DialogWrapper {
    private static final String OK_BUTTON_TEXT = "OK";
    private static final String TITLE = "Change Device to Match Mockup";
    private static final String PROMPT_HELP_TEXT = "Only displaying devices with same aspect ratio as the image.";
    private static final JBColor ERROR_COLOR = JBColor.RED;
    private static final String NO_DEVICE_MESSAGE = "No device or AVD matching the image dimension has been found.\nCreate a new AVD with the same aspect ratio as the image or choose another image for better result.";
    private static final Color MESSAGE_COLOR = JBColor.foreground();
    private static final Logger LOGGER = Logger.getInstance(DeviceSelectionPopup.class);
    private final Configuration myConfiguration;
    private final Dimension myImageSize;
    private final BufferedImage myImage;
    private JPanel myPanel;
    private JComboBox myDevicesComboBox;
    private JButton myNewDeviceButton;
    private JLabel promptLabel;
    private JPanel myPreviewPanel;
    private JTextPane myMessage;
    private List<Device> myMatchingDevices;
    @Nullable
    private Device mySelectedDevice;
    private ScreenOrientation myScreenOrientation;
    private BufferedImage myDeviceFrame;
    private Map<String, BufferedImage> myImageCache;
    private boolean myNoMatchingDevice;

    @Nullable
    protected String getHelpId() {
        return null;
    }

    public DeviceSelectionPopup(Project project, Configuration configuration, BufferedImage image) {
        super(project, true);
        this.myConfiguration = configuration;
        this.myImage = image;
        this.$$$setupUI$$$();
        this.myMatchingDevices = new ArrayList<Device>();
        this.myImageCache = new HashMap<String, BufferedImage>();
        this.myImageSize = new Dimension(image.getWidth(), image.getHeight());
        this.mySelectedDevice = configuration.getDevice();
        this.setTitle(TITLE);
        this.setHorizontalStretch(1.2f);
        this.myHelpAction.setEnabled(false);
        this.setOKButtonText(OK_BUTTON_TEXT);
        this.init();
    }

    private void initDeviceList(Configuration configuration) {
        this.myNoMatchingDevice = false;
        if (!this.myMatchingDevices.isEmpty()) {
            this.myMatchingDevices.clear();
        }
        if (this.myDevicesComboBox.getItemCount() > 0) {
            this.myDevicesComboBox.removeAllItems();
        }
        int lastNexusIndex = 0;
        int lastMatchIndex = 0;
        int lastNexusRatioIndex = 0;
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        ImmutableList deviceList = configurationManager.getDevices();
        double imageRatio = (double)this.myImageSize.width / (double)this.myImageSize.height;
        this.myScreenOrientation = this.myImageSize.width <= this.myImageSize.height ? ScreenOrientation.PORTRAIT : ScreenOrientation.LANDSCAPE;
        for (Device device : deviceList) {
            Dimension screenSize = device.getScreenSize(this.myScreenOrientation);
            if (screenSize == null) continue;
            if (this.myImageSize.equals(screenSize)) {
                if (HardwareConfigHelper.isNexus((Device)device)) {
                    this.myMatchingDevices.add(lastNexusIndex++, device);
                    continue;
                }
                if (!HardwareConfigHelper.isGeneric((Device)device)) continue;
                this.myMatchingDevices.add(lastNexusIndex + lastMatchIndex++, device);
                continue;
            }
            if (!DeviceSelectionPopup.ratioAlmostEqual(imageRatio, screenSize)) continue;
            if (HardwareConfigHelper.isNexus((Device)device)) {
                this.myMatchingDevices.add(lastNexusIndex + lastMatchIndex + lastNexusRatioIndex++, device);
                continue;
            }
            this.myMatchingDevices.add(device);
        }
        if (this.myMatchingDevices.isEmpty()) {
            if (this.findMatchingAvd(configurationManager, imageRatio)) {
                return;
            }
            this.myMatchingDevices.add(configuration.getDevice());
            this.myNoMatchingDevice = true;
        }
        for (Device device : this.myMatchingDevices) {
            String deviceLabel = HardwareConfigHelper.isNexus((Device)device) ? HardwareConfigHelper.getNexusLabel((Device)device) : (HardwareConfigHelper.isGeneric((Device)device) ? HardwareConfigHelper.getGenericLabel((Device)device) : device.getId());
            if (device == this.myConfiguration.getDevice()) {
                deviceLabel = String.format("* %s (current)", deviceLabel);
            }
            this.myDevicesComboBox.addItem(deviceLabel);
        }
        this.mySelectedDevice = this.myMatchingDevices.get(0);
        this.myDevicesComboBox.setSelectedIndex(0);
        this.updateDevicePreview();
    }

    private boolean findMatchingAvd(ConfigurationManager configurationManager, double imageRatio) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)configurationManager.getModule());
        if (facet == null) {
            return false;
        }
        AvdManager avdManager = AvdManagerUtils.getAvdManagerSilently((AndroidFacet)facet);
        if (avdManager != null) {
            AvdInfo[] allAvds;
            for (AvdInfo avd : allAvds = avdManager.getAllAvds()) {
                Dimension screenSize;
                Device device = configurationManager.createDeviceForAvd(avd);
                if (device == null || !this.myImageSize.equals(screenSize = device.getScreenSize(this.myScreenOrientation)) && !DeviceSelectionPopup.ratioAlmostEqual(imageRatio, screenSize)) continue;
                String avdName = "AVD: " + avd.getName();
                this.myDevicesComboBox.addItem(avdName);
                this.myMatchingDevices.add(device);
            }
        }
        return !this.myMatchingDevices.isEmpty();
    }

    private static boolean ratioAlmostEqual(double imageRatio, Dimension screenSize) {
        return Math.abs((double)screenSize.width / (double)screenSize.height - imageRatio) < 0.01;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            DeviceSelectionPopup.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDevicesComboBox;
    }

    protected JComponent createCenterPanel() {
        this.initDeviceList(this.myConfiguration);
        this.initMessage();
        this.initDeviceComboBox();
        this.initNewButton();
        return this.myPanel;
    }

    private void initNewButton() {
        this.myNewDeviceButton.addActionListener(e -> {
            ModelWizardDialog dialog = AvdWizardUtils.createAvdWizard((Component)this.getContentPane(), null);
            if (dialog.showAndGet()) {
                AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true);
                this.initDeviceList(this.myConfiguration);
            }
        });
    }

    private void initDeviceComboBox() {
        this.myDevicesComboBox.addActionListener(event -> this.updateDevicePreview());
    }

    private void initMessage() {
        this.myMessage.setEditable(false);
        this.myMessage.setFont(this.promptLabel.getFont());
        this.myMessage.setBackground(this.myPanel.getBackground());
        StyledDocument doc = this.myMessage.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        if (this.myNoMatchingDevice) {
            this.myMessage.setText(NO_DEVICE_MESSAGE);
            this.myMessage.setForeground((Color)ERROR_COLOR);
        } else {
            this.myMessage.setText(PROMPT_HELP_TEXT);
            this.myMessage.setForeground(MESSAGE_COLOR);
        }
    }

    private void updateDevicePreview() {
        int selectedIndex = this.myDevicesComboBox.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
            this.myDevicesComboBox.setSelectedIndex(0);
        }
        this.mySelectedDevice = this.myMatchingDevices.get(selectedIndex);
        if (this.mySelectedDevice == null) {
            this.myDeviceFrame = null;
            return;
        }
        if (this.myImageCache.containsKey(this.mySelectedDevice.getId())) {
            this.myDeviceFrame = this.myImageCache.get(this.mySelectedDevice.getId());
            this.myPreviewPanel.repaint();
        } else {
            this.myDeviceFrame = null;
            this.myPreviewPanel.repaint();
            DeviceArtPainter deviceArtPainter = DeviceArtPainter.getInstance();
            if (deviceArtPainter.hasDeviceFrame(this.mySelectedDevice)) {
                new Thread(() -> {
                    try {
                        this.myDeviceFrame = deviceArtPainter.createFrame(this.myImage, this.mySelectedDevice, this.myScreenOrientation, true, 1.0, null);
                    }
                    catch (IllegalStateException artDescriptorException) {
                        LOGGER.warn((Throwable)artDescriptorException);
                        this.myDeviceFrame = this.myImage;
                    }
                    finally {
                        UIUtil.invokeLaterIfNeeded(() -> this.myPreviewPanel.repaint());
                    }
                }).start();
            } else {
                this.myDeviceFrame = this.myImage;
            }
        }
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.mySelectedDevice != null) {
            this.setConfigurationDevice(this.mySelectedDevice);
        }
    }

    private void setConfigurationDevice(@NotNull Device selectedDevice) {
        if (selectedDevice == null) {
            DeviceSelectionPopup.$$$reportNull$$$0(1);
        }
        State state = selectedDevice.getDefaultState().deepCopy();
        this.myConfiguration.setDeviceStateName(state.getName());
        this.myConfiguration.getConfigurationManager().selectDevice(selectedDevice);
    }

    private void createUIComponents() {
        this.myPreviewPanel = new MyPreviewPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JButton jButton;
        JComboBox jComboBox;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.promptLabel = jLabel = new JLabel();
        jLabel.setText("Best matching device:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDevicesComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JPanel jPanel2 = this.myPreviewPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myNewDeviceButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/RefactoringBundle", DeviceSelectionPopup.class).getString("migration.new.button"));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myMessage = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setText("");
        jPanel.add((Component)jTextPane, new GridConstraints(1, 0, 1, 3, 0, 3, 7, 3, null, new Dimension(150, 50), null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(3, 0, 1, 3, 2, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/DeviceSelectionPopup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/DeviceSelectionPopup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationDevice";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPreviewPanel
    extends JPanel {
        AffineTransform myTransform = new AffineTransform();

        public MyPreviewPanel() {
            this.setPreferredSize(new Dimension(100, 600));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (DeviceSelectionPopup.this.myDeviceFrame == null || DeviceSelectionPopup.this.mySelectedDevice == null) {
                if (DeviceSelectionPopup.this.mySelectedDevice == null) {
                    this.drawCenteredString(g, "No device selected", this.getBounds(), g.getFont());
                } else {
                    this.drawCenteredString(g, CommonBundle.getLoadingTreeNodeText(), this.getBounds(), g.getFont());
                }
                return;
            }
            Dimension screenSize = DeviceSelectionPopup.this.mySelectedDevice.getScreenSize(DeviceSelectionPopup.this.myScreenOrientation);
            if (screenSize != null) {
                int sw = this.getWidth();
                int sh = this.getHeight();
                int iw = DeviceSelectionPopup.this.myDeviceFrame.getWidth();
                int ih = DeviceSelectionPopup.this.myDeviceFrame.getHeight();
                float scale = Math.min((float)sw / (float)iw, (float)sh / (float)ih);
                this.myTransform.setToIdentity();
                this.myTransform.translate(((float)sw - (float)iw * scale) / 2.0f, ((float)sh - (float)ih * scale) / 2.0f);
                this.myTransform.scale(scale, scale);
                Graphics2D g2d = (Graphics2D)g;
                AffineTransform tx = g2d.getTransform();
                g2d.transform(this.myTransform);
                g2d.drawImage(DeviceSelectionPopup.this.myDeviceFrame, 0, 0, iw, ih, null);
                g2d.setTransform(tx);
            }
        }

        public void drawCenteredString(Graphics g, String text, Rectangle rect, Font font) {
            FontMetrics metrics = g.getFontMetrics(font);
            int x = (rect.width - metrics.stringWidth(text)) / 2;
            int y = (rect.height - metrics.getHeight()) / 2 + metrics.getAscent();
            g.setFont(font);
            g.drawString(text, x, y);
            g.dispose();
        }
    }
}

