/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class AnimatedComponentSplitter
extends ThreeComponentsSplitter {
    private static final int DEFAULT_ANIMATION_DURATION = 150;
    private boolean myIsFirstShowing;
    private boolean myIsLastShowing;
    private int myFirstClosedSize;
    private int myLastClosedSize;

    public AnimatedComponentSplitter(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            AnimatedComponentSplitter.$$$reportNull$$$0(0);
        }
        super(disposable2);
        this.myFirstClosedSize = 0;
        this.myLastClosedSize = 0;
    }

    public AnimatedComponentSplitter(boolean vertical, @NotNull Disposable disposable2) {
        if (disposable2 == null) {
            AnimatedComponentSplitter.$$$reportNull$$$0(1);
        }
        super(vertical, disposable2);
        this.myFirstClosedSize = 0;
        this.myLastClosedSize = 0;
    }

    public AnimatedComponentSplitter(boolean vertical, boolean onePixelDividers, @NotNull Disposable disposable2) {
        if (disposable2 == null) {
            AnimatedComponentSplitter.$$$reportNull$$$0(2);
        }
        super(vertical, onePixelDividers, disposable2);
        this.myFirstClosedSize = 0;
        this.myLastClosedSize = 0;
    }

    public boolean isFirstShowing() {
        return this.myIsFirstShowing;
    }

    public boolean isLastShowing() {
        return this.myIsLastShowing;
    }

    public void showAnimateFirst(boolean show2) {
        int targetSize = show2 ? this.getFirstOpenSize() : this.myLastClosedSize;
        int startSize = this.getFirstSize();
        if (show2 && startSize > this.getFirstOpenSize() || !show2 && startSize < this.myFirstClosedSize) {
            return;
        }
        AnimatedComponentSplitter.showAnimate((Consumer<Integer>)((Consumer)this::setFirstSize), targetSize, startSize);
    }

    public void showAnimateLast(boolean show2) {
        int targetSize = show2 ? this.getLastOpenSize() : this.myLastClosedSize;
        int startSize = this.getLastSize();
        if (show2 && startSize > this.getLastOpenSize() || !show2 && startSize < this.myLastClosedSize) {
            return;
        }
        AnimatedComponentSplitter.showAnimate((Consumer<Integer>)((Consumer)this::setLastSize), targetSize, startSize);
    }

    private static void showAnimate(@NotNull Consumer<Integer> setSizeMethod, int targetSize, int startSize) {
        if (setSizeMethod == null) {
            AnimatedComponentSplitter.$$$reportNull$$$0(3);
        }
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer(20, e -> {
            float t = (float)(System.currentTimeMillis() - startTime) / 150.0f;
            if (t >= 1.0f) {
                t = 1.0f;
                ((Timer)e.getSource()).stop();
            }
            int delta = targetSize - startSize;
            int size = Math.round((float)startSize + (float)delta * t);
            setSizeMethod.consume((Object)size);
        });
        timer.setRepeats(true);
        timer.start();
    }

    public void showAnimateChild(@NotNull JComponent child, boolean show2) {
        if (child == null) {
            AnimatedComponentSplitter.$$$reportNull$$$0(4);
        }
        if (this.getFirstComponent() == child) {
            this.showAnimateFirst(show2);
        } else if (this.getLastComponent() == child) {
            this.showAnimateLast(show2);
        }
    }

    public void setFirstSize(int size) {
        this.myIsFirstShowing = size > 1;
        super.setFirstSize(size);
    }

    public void setLastSize(int size) {
        this.myIsLastShowing = size > 1;
        super.setLastSize(size);
    }

    protected int getFirstOpenSize() {
        return Math.round((float)this.getWidth() / 3.0f);
    }

    protected int getLastOpenSize() {
        return this.getFirstOpenSize();
    }

    public void setFirstClosedSize(int firstClosedSize) {
        this.myFirstClosedSize = firstClosedSize;
    }

    public void setLastClosedSize(int lastClosedSize) {
        this.myLastClosedSize = lastClosedSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setSizeMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/AnimatedComponentSplitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showAnimate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showAnimateChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

