/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ExtractedColor
implements Comparable<ExtractedColor> {
    private final int myColor;
    private final int myOccurrence;
    private final Set<Integer> myNeighborColor;

    public ExtractedColor(int color2, int occurrence, @Nullable Set<Integer> neighborColor) {
        this.myColor = color2;
        this.myOccurrence = occurrence;
        this.myNeighborColor = neighborColor != null ? neighborColor : new HashSet(0);
    }

    public int getColor() {
        return this.myColor;
    }

    public int getOccurrence() {
        return this.myOccurrence;
    }

    public Set<Integer> getNeighborColor() {
        return this.myNeighborColor;
    }

    public String toString() {
        return String.format(Locale.US, "#%05X", this.myColor);
    }

    @Override
    public int compareTo(ExtractedColor o) {
        return o.getOccurrence() - this.myOccurrence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtractedColor that = (ExtractedColor)o;
        return this.myColor == that.myColor;
    }

    public int hashCode() {
        return this.myColor;
    }
}

