/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.backgroundremove;

import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class HistoryManager<T> {
    private static final int DEFAULT_MAX_HISTORY = 10;
    private final ArrayDeque<T> myUndoStack = new ArrayDeque(10);
    private final ArrayDeque<T> myRedoStack = new ArrayDeque(10);
    private int myMaxHistory = 10;

    public void setOriginalImage(@NotNull T firstObject) {
        if (firstObject == null) {
            HistoryManager.$$$reportNull$$$0(0);
        }
        this.myUndoStack.clear();
        this.myUndoStack.addLast(firstObject);
    }

    public void setMaxHistory(int maxHistory) {
        this.myMaxHistory = maxHistory;
    }

    public void pushUndo(@NotNull T object) {
        if (object == null) {
            HistoryManager.$$$reportNull$$$0(1);
        }
        if (!this.myRedoStack.isEmpty()) {
            this.myRedoStack.clear();
        }
        this.myUndoStack.addLast(object);
        if (this.myUndoStack.size() > this.myMaxHistory) {
            this.myUndoStack.removeFirst();
        }
    }

    public T undo() {
        if (this.canUndo()) {
            if (this.myUndoStack.size() == 1) {
                return this.myUndoStack.getLast();
            }
            T poppedObject = this.myUndoStack.removeLast();
            this.myRedoStack.addLast(poppedObject);
        }
        return this.getCurrentObject();
    }

    public T getCurrentObject() {
        return this.myUndoStack.peekLast();
    }

    public T redo() {
        if (!this.myRedoStack.isEmpty()) {
            this.myUndoStack.addLast(this.myRedoStack.removeLast());
        }
        return this.getCurrentObject();
    }

    public boolean canUndo() {
        return this.myUndoStack.size() > 1;
    }

    public boolean canRedo() {
        return !this.myRedoStack.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/backgroundremove/HistoryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setOriginalImage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "pushUndo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

