/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionBar {
    private final List<SceneComponent> myItems;
    private final List<SceneComponent> myOverflowItems;
    private final Rectangle myItemBounds;
    private final Rectangle myOverflowItemBounds;

    ActionBar(@NotNull SceneComponent group) {
        if (group == null) {
            ActionBar.$$$reportNull$$$0(0);
        }
        this.myItems = new ArrayList<SceneComponent>();
        this.myOverflowItems = new ArrayList<SceneComponent>();
        this.addToItemsOrOverflowItems(group);
        this.myItems.sort((item1, item2) -> Integer.compare(item1.getDrawX(), item2.getDrawX()));
        this.myOverflowItems.sort((item1, item2) -> Integer.compare(item1.getDrawY(), item2.getDrawY()));
        this.myItemBounds = ActionBar.getBounds(this.myItems);
        this.myOverflowItemBounds = ActionBar.getBounds(this.myOverflowItems);
    }

    private void addToItemsOrOverflowItems(@NotNull SceneComponent group) {
        if (group == null) {
            ActionBar.$$$reportNull$$$0(1);
        }
        group.getChildren().stream().filter(item -> item.getDrawWidth() != -1 && item.getDrawHeight() != -1).forEach(item -> {
            if (NlComponentHelperKt.getViewInfo(item.getNlComponent()) == null) {
                this.addToItemsOrOverflowItems((SceneComponent)item);
                return;
            }
            switch (NlComponentHelperKt.getViewInfo(item.getNlComponent()).getViewType()) {
                case ACTION_BAR_MENU: {
                    this.myItems.add((SceneComponent)item);
                    break;
                }
                case ACTION_BAR_OVERFLOW_MENU: {
                    this.myOverflowItems.add((SceneComponent)item);
                    break;
                }
            }
        });
    }

    @Nullable
    private static Rectangle getBounds(@NotNull List<SceneComponent> items) {
        if (items == null) {
            ActionBar.$$$reportNull$$$0(2);
        }
        if (items.isEmpty()) {
            return null;
        }
        SceneComponent firstItem = items.get(0);
        Rectangle bounds2 = firstItem.fillRect(null);
        Rectangle temp = new Rectangle();
        items.subList(1, items.size()).forEach(item -> bounds2.add(item.fillRect(temp)));
        return bounds2;
    }

    @NotNull
    List<SceneComponent> getItems() {
        List<SceneComponent> list = this.myItems;
        if (list == null) {
            ActionBar.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    List<SceneComponent> getOverflowItems() {
        List<SceneComponent> list = this.myOverflowItems;
        if (list == null) {
            ActionBar.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    Rectangle getItemBounds() {
        return this.myItemBounds;
    }

    @Nullable
    Rectangle getOverflowItemBounds() {
        return this.myOverflowItemBounds;
    }

    boolean contains(int x, int y) {
        return this.myItemBounds.contains(x, y) || this.myOverflowItemBounds.contains(x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/menu/ActionBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/menu/ActionBar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverflowItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addToItemsOrOverflowItems";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

